package com.bxm.localnews.user.service.handler;

import com.bxm.localnews.user.service.intefaces.BarrelHandler;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * handler的顺序关系
 */
public class HandlerOrder {

    private static Map<Class<? extends BarrelHandler>, Integer> BarrelHandlerMap = Maps.newHashMap();

    static {

        //首选桶
        BarrelHandlerMap.put(WeightPreferredBarrelHandler.class, 1);

        //备用桶
        BarrelHandlerMap.put(WeightAlternateBarrelHandler.class, 2);

        //必须要有个兜底策略，不然有些用户都进不了桶了
        BarrelHandlerMap.put(WeightDefaultBarrelHandler.class, 3);

    }

    public static int get(Class<? extends BarrelHandler> clazz) {
        return BarrelHandlerMap.get(clazz);
    }
}
