package com.bxm.localnews.user.service.handler;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.user.param.NativeRecommendContext;
import com.bxm.localnews.user.param.WeightParam;
import com.bxm.localnews.user.service.impl.BarrelInterceptorChain;
import com.bxm.newidea.component.tools.SpringContextHolder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 默认策略（桶）
 * 按分值计算排序的策略
 */
@Service
@Slf4j
public class WeightDefaultBarrelHandler extends AbstractWeightBarrelHandler<NativeRecommendContext> {

    @Autowired
    private BarrelInterceptorChain barrelInterceptorChain;

    @Override
    protected List<Long> doHandle(NativeRecommendContext nativeRecommendContext) {
        log.debug("到达默认桶，使用指定参数进行推荐：[{}]",JSONObject.toJSON(nativeRecommendContext));
        String weightStr = recommendProperties.getWeight().getOrDefault(supportWeight(),null);
        nativeRecommendContext.addParam("weight",
                weightStr != null ? JSONObject.parseObject(weightStr, WeightParam.class) : new WeightParam());
        barrelInterceptorChain.invoke(nativeRecommendContext, this);
        return new ArrayList<>();
    }

    @Override
    public String supportWeight() {
        return "default-score";
    }
}