package com.bxm.localnews.user.service.impl;

import com.bxm.localnews.user.param.NativeRecommendContext;
import com.bxm.localnews.user.service.NativeRecommendService;
import com.bxm.localnews.user.service.intefaces.BarrelHandler;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;

@Service
public class NativeRecommendServiceImpl implements NativeRecommendService,ApplicationRunner, ApplicationContextAware {

    private ApplicationContext applicationContext;

    protected Collection<? extends BarrelHandler> barrelHandlerCollection = new ArrayList<>();

    @Override
    public void run(ApplicationArguments args) {
        //在启动的时候获得所有的桶
        barrelHandlerCollection = applicationContext.getBeansOfType(BarrelHandler.class).values()
                .stream().sorted(Comparator.comparingInt(Ordered::getOrder))
                .collect(Collectors.toList());
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }


    @Override
    public NativeRecommendContext listRecommendUser(NativeRecommendContext nativeRecommendContext) {
        for (BarrelHandler barrelHandler : barrelHandlerCollection) {
            if (barrelHandler.support(nativeRecommendContext)) {
                barrelHandler.handle(nativeRecommendContext);
                return nativeRecommendContext;
            }
        }
        //默认
        return nativeRecommendContext;
    }
}
