/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.service.impl;

import com.bxm.localnews.user.constant.DeductPointStatusEnum;
import com.bxm.localnews.user.domain.PointOrderMapper;
import com.bxm.localnews.user.domain.UserAccountMapper;
import com.bxm.localnews.user.enums.GoldEnum;
import com.bxm.localnews.user.enums.GoldFlowTypeEnum;
import com.bxm.localnews.user.param.AccountGoldParam;
import com.bxm.localnews.user.param.DeductPointParam;
import com.bxm.localnews.user.param.StoreNeceParam;
import com.bxm.localnews.user.service.AccountService;
import com.bxm.localnews.user.service.UserAccountService;
import com.bxm.localnews.user.vo.PointOrder;
import com.bxm.localnews.user.vo.UserAccount;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccountServiceImpl
implements AccountService {
    private static final Logger log = LoggerFactory.getLogger(AccountServiceImpl.class);
    @Autowired
    private UserAccountMapper userAccountMapper;
    @Autowired
    private PointOrderMapper pointOrderMapper;
    @Autowired
    private UserAccountService userAccountService;

    @Override
    public BigDecimal selectGoldByUserId(StoreNeceParam storeNeceParam) {
        BigDecimal point = this.selectUsableGoldByUserId(Long.valueOf(storeNeceParam.getAppUid()));
        return point;
    }

    @Override
    public Boolean deductUserGold(DeductPointParam deductPointParam) {
        BigDecimal deductPoint;
        PointOrder pointOrder = this.addPointOrder(deductPointParam);
        BigDecimal userBalance = this.selectUsableGoldByUserId(Long.valueOf(deductPointParam.getAppUid()));
        if (userBalance.compareTo(deductPoint = new BigDecimal(deductPointParam.getPoint().longValue())) < 0) {
            return Boolean.FALSE;
        }
        AccountGoldParam param = new AccountGoldParam(Long.valueOf(deductPointParam.getAppUid()), GoldEnum.CONSUME_GOLD.name(), Boolean.valueOf(false), Integer.valueOf(deductPoint.intValue()), pointOrder.getId(), GoldFlowTypeEnum.EXCHANGE_GOODS.getName());
        this.userAccountService.addGold(param);
        return true;
    }

    @Override
    public void deductConfirmUserGold(DeductPointParam deductPointParam) {
        PointOrder pointOrder = this.pointOrderMapper.getPointOrder(Long.valueOf(deductPointParam.getAppUid()), deductPointParam.getOrderNum());
        if (pointOrder != null) {
            String status = DeductPointStatusEnum.getStatusByStatus(deductPointParam.getStatus());
            if (DeductPointStatusEnum.FAIL.getStatus().equals(status)) {
                log.info("\u7528\u6237[{}]\u79ef\u5206\u5546\u57ce\u91d1\u5e01\u9000\u56de.......", (Object)deductPointParam.getAppUid());
                BigDecimal returnGold = new BigDecimal("-" + pointOrder.getDeductBalance());
                AccountGoldParam param = new AccountGoldParam(Long.valueOf(deductPointParam.getAppUid()), GoldEnum.USABLE_GOLD.name(), Boolean.valueOf(false), Integer.valueOf(returnGold.intValue()), pointOrder.getId(), GoldFlowTypeEnum.STORE_ADD_BALANCE.getName());
                this.userAccountService.addGold(param);
            }
            pointOrder.setUpdateTime(new Date());
            pointOrder.setStatus(deductPointParam.getStatus());
            this.pointOrderMapper.updateByPrimaryKeySelective(pointOrder);
        }
    }

    @Override
    public void addUserGold(DeductPointParam deductPointParam) {
        PointOrder pointOrder = this.addPointOrder(deductPointParam);
        BigDecimal addPoint = new BigDecimal(deductPointParam.getPoint().longValue());
        AccountGoldParam param = new AccountGoldParam(Long.valueOf(deductPointParam.getAppUid()), GoldEnum.USABLE_GOLD.name(), Boolean.valueOf(true), Integer.valueOf(addPoint.intValue()), pointOrder.getId(), GoldFlowTypeEnum.STORE_ADD_BALANCE.getName());
        this.userAccountService.addGold(param);
    }

    @Override
    public BigDecimal selectUsableGoldByUserId(Long userId) {
        UserAccount userAccount = this.userAccountMapper.getUserAccount(userId);
        if (null != userAccount) {
            return BigDecimal.valueOf(userAccount.getUsableGold().intValue());
        }
        return BigDecimal.ZERO;
    }

    private PointOrder addPointOrder(DeductPointParam deductPointParam) {
        PointOrder pointOrder = new PointOrder();
        pointOrder.setBxmOrderNo(deductPointParam.getOrderNum());
        pointOrder.setOrderNo(deductPointParam.getAppOrderNum());
        pointOrder.setUserId(Long.valueOf(deductPointParam.getAppUid()));
        pointOrder.setDeductBalance(Long.valueOf(deductPointParam.getPoint().longValue()));
        pointOrder.setDescription(deductPointParam.getDescription());
        pointOrder.setStatus(deductPointParam.getStatus());
        pointOrder.setCreateTime(new Date());
        this.pointOrderMapper.insertSelective(pointOrder);
        return pointOrder;
    }
}

