/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.UserAuthMapper;
import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.enums.AwardTypeEnum;
import com.bxm.localnews.user.enums.CashEnum;
import com.bxm.localnews.user.enums.CashFlowConvertTypeEnum;
import com.bxm.localnews.user.enums.CashFlowTypeEnum;
import com.bxm.localnews.user.enums.InviteRecordStateEnum;
import com.bxm.localnews.user.integration.AppVersionIntegrationService;
import com.bxm.localnews.user.integration.BizLogIntegrationService;
import com.bxm.localnews.user.integration.InviteRelationIntegrationService;
import com.bxm.localnews.user.integration.QuartzManageIntegrationService;
import com.bxm.localnews.user.integration.SmsIntegrationService;
import com.bxm.localnews.user.integration.UserNewsIntegrationService;
import com.bxm.localnews.user.integration.VipIntegrationService;
import com.bxm.localnews.user.param.AccountCashParam;
import com.bxm.localnews.user.param.RiskParam;
import com.bxm.localnews.user.service.CashFlowService;
import com.bxm.localnews.user.service.InviteRecordService;
import com.bxm.localnews.user.service.LoginService;
import com.bxm.localnews.user.service.RiskRecordService;
import com.bxm.localnews.user.service.UserAccountService;
import com.bxm.localnews.user.service.UserAuthService;
import com.bxm.localnews.user.service.UserLoginHistoryService;
import com.bxm.localnews.user.service.UserService;
import com.bxm.localnews.user.service.UserSyncService;
import com.bxm.localnews.user.vo.InviteRecord;
import com.bxm.localnews.user.vo.LoginInfo;
import com.bxm.localnews.user.vo.LoginMeta;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserAccount;
import com.bxm.localnews.user.vo.UserAuth;
import com.bxm.newidea.component.log.LogMarker;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="loginService")
@RefreshScope
public class LoginServiceImpl
implements LoginService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private SmsIntegrationService smsIntegrationService;
    @Resource
    private UserAuthMapper userAuthMapper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private InviteRelationIntegrationService inviteRelationIntegrationService;
    @Resource
    private UserService userService;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private AppVersionIntegrationService appVersionIntegrationService;
    @Resource
    private UserAuthService userAuthService;
    @Resource
    private BizLogIntegrationService bizLogIntegrationService;
    @Resource
    private VipIntegrationService vipIntegrationService;
    @Resource
    private UserLoginHistoryService userLoginHistoryService;
    @Resource
    private UserNewsIntegrationService userNewsIntegrationService;
    @Resource
    private UserSyncService userSyncService;
    @Resource
    private InviteRecordService inviteRecordService;
    @Resource
    private UserAccountService userAccountService;
    @Resource
    private QuartzManageIntegrationService quartzManageIntegrationService;
    @Resource
    private CashFlowService cashFlowService;
    @Resource
    private RiskRecordService riskRecordService;

    @Override
    public Json<LoginMeta> doLogin(LoginInfo loginInfo, BasicParam basicParam) {
        Message message;
        boolean flag = false;
        if (this.appVersionIntegrationService.inWhiteList(loginInfo.getLoginName()).booleanValue()) {
            flag = true;
            loginInfo.setCode("123456");
        }
        if (!this.checkParam(loginInfo)) {
            this.logger.info("doLogin failed:" + loginInfo);
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u9519\u8bef");
        }
        UserAuth userAuth = this.userAuthMapper.selectByUserAuth(loginInfo.getType(), loginInfo.getLoginName());
        if (1 != loginInfo.getType() && null == userAuth) {
            if (this.getPublishState(basicParam).booleanValue()) {
                LoginMeta meta = new LoginMeta();
                meta.setCode(512);
                return ResultUtil.genSuccessResult((Object)meta);
            }
            return this.registerAndBindingPhone(loginInfo, basicParam.getPlatform(), null, basicParam.getChnl());
        }
        if (this.checkRetrievePwd(loginInfo) && !(message = this.retrievePwd(loginInfo, userAuth, flag)).isSuccess()) {
            return ResultUtil.genFailedResult((String)((String)message.getMessages().get(0)));
        }
        if (this.checkVerifyPwd(loginInfo) && !(message = this.verifyPwd(loginInfo.getPassword(), userAuth)).isSuccess()) {
            return ResultUtil.genFailedResult((String)message.getLashMessaage());
        }
        LoginMeta meta = this.updateUserAfterLogin(userAuth, loginInfo, basicParam);
        if (null != meta && meta.getUser() != null) {
            this.bizLogIntegrationService.login(meta.getUser().getId());
        }
        return ResultUtil.genSuccessResult((Object)meta);
    }

    private Boolean getPublishState(BasicParam basicParam) {
        return this.appVersionIntegrationService.getPublishState(basicParam);
    }

    private boolean checkVerifyPwd(LoginInfo loginInfo) {
        return 1 == loginInfo.getType() && StringUtils.isNotBlank((CharSequence)loginInfo.getPassword()) && loginInfo.getResetPwd() == false;
    }

    private boolean checkRetrievePwd(LoginInfo loginInfo) {
        return 1 == loginInfo.getType() && StringUtils.isNotBlank((CharSequence)loginInfo.getPassword()) && null != loginInfo.getResetPwd() && loginInfo.getResetPwd() != false;
    }

    private Message retrievePwd(LoginInfo loginInfo, UserAuth userAuth, boolean flag) {
        if (null == userAuth) {
            return Message.build((boolean)false, (String)"\u624b\u673a\u53f7\u7801\u672a\u6ce8\u518c\uff0c\u8bf7\u524d\u5f80\u6ce8\u518c");
        }
        if (!flag && !this.smsIntegrationService.verifySmsCodeByType(Byte.valueOf((byte)6), loginInfo.getLoginName(), loginInfo.getCode()).booleanValue()) {
            return Message.build((boolean)false, (String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u9a8c\u8bc1\u7801");
        }
        String encodePwd = MD5Util.hgmd5((String)loginInfo.getPassword());
        userAuth.setCredential(encodePwd);
        this.userAuthMapper.updateByPrimaryKeySelective(userAuth);
        return Message.build((boolean)true);
    }

    private Message verifyPwd(String password, UserAuth userAuth) {
        String encodePwd = MD5Util.hgmd5((String)password);
        if (null == userAuth) {
            return Message.build((boolean)false, (String)"\u624b\u673a\u53f7\u7801\u672a\u6ce8\u518c\uff0c\u8bf7\u524d\u5f80\u6ce8\u518c");
        }
        if (!userAuth.getCredential().equals(encodePwd)) {
            return Message.build((boolean)false, (String)"\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef");
        }
        return Message.build((boolean)true);
    }

    private LoginMeta updateUserAfterLogin(UserAuth userAuth, LoginInfo loginInfo, BasicParam basicParam) {
        User user = this.userMapper.selectByPrimaryKey(userAuth.getUserId());
        boolean isFirstLogin = StringUtils.isBlank((CharSequence)user.getEquipment());
        this.updateNicknameAndHeadImg(loginInfo, user);
        this.updateWechat(loginInfo, user, basicParam.getPlatform());
        this.userLoginHistoryService.save(user, loginInfo);
        this.callAsyncUpdateLocation(loginInfo, user);
        UserInfoDTO dto = this.getUpdateUser(loginInfo, user);
        LoginMeta meta = new LoginMeta(dto, isFirstLogin);
        if (isFirstLogin && loginInfo.getType() == 3) {
            this.logger.info("\u7528\u6237\u7b2c\u4e00\u6b21\u5fae\u4fe1\u6388\u6743\u767b\u9646-----\u7ed1\u5b9aVIP\u9080\u8bf7\u5173\u7cfb");
            this.dealVipActivation(user.getId(), loginInfo.getLoginName());
            this.userNewsIntegrationService.initUserNewsImage(user.getId(), null);
        }
        this.redisHashMapAdapter.put(RedisConfig.USER_INFO, userAuth.getUserId().toString(), (Object)JSON.toJSONString((Object)meta.getUser()));
        return meta;
    }

    private UserInfoDTO getUpdateUser(LoginInfo loginInfo, User user) {
        if (StringUtils.isNotBlank((CharSequence)loginInfo.getEquipment())) {
            user.setEquipment(loginInfo.getEquipment());
        }
        user.setToken(this.userService.getToken());
        user.setExpiretime(this.userService.getExpireTime());
        user.setRefreshtoken(user.getRefreshtoken());
        user.setLastLoginTime(new Date());
        user.setLastLoginIp(loginInfo.getLastLoginIp());
        this.logger.debug("\u7528\u6237[{}]\u5bf9\u5e94\u7684\u72b6\u6001\uff1a[{}]", (Object)user.getId(), (Object)user.getState());
        this.logger.debug("\u7528\u6237\u72b6\u6001\u662f\u5426\u5904\u4e8e\u672a\u6fc0\u6d3b\u72b6\u6001\uff1a[{}]", (Object)(2 == user.getState() ? 1 : 0));
        if (2 == user.getState()) {
            UserAccount userAccount = this.userAccountService.getUserAccountDetail(user.getId());
            if (userAccount.getTotalCash().compareTo(BigDecimal.ZERO) > 0) {
                user.setReceiveRedPacket(Byte.valueOf((byte)0));
            }
            user.setState(Byte.valueOf((byte)1));
            Long equipmentExisted = this.userService.checkExistEquipment(loginInfo.getEquipment());
            Long relationId = null;
            if (equipmentExisted > 0L) {
                InviteRecord inviteRecord;
                if (null != user.getInviteUserId() && null != (inviteRecord = this.inviteRecordService.getInviteRecordByInvitedUser(user.getInviteUserId(), user.getId()))) {
                    relationId = inviteRecord.getId();
                    this.updateInviteUserState(inviteRecord, false);
                }
                this.updateUserCashState(userAccount, relationId, false);
            } else {
                InviteRecord inviteRecord;
                if (null != user.getInviteUserId() && null != (inviteRecord = this.inviteRecordService.getInviteRecordByInvitedUser(user.getInviteUserId(), user.getId()))) {
                    relationId = inviteRecord.getId();
                    this.updateInviteUserState(inviteRecord, true);
                }
                this.updateUserCashState(userAccount, relationId, true);
            }
            this.quartzManageIntegrationService.removeInviteTask(user.getInviteUserId() + "_" + user.getId());
        }
        this.userMapper.updateByPrimaryKeySelective(user);
        return this.userService.getUserToDTO(user);
    }

    private void updateUserCashState(UserAccount userAccount, Long relationId, Boolean isEffective) {
        BigDecimal cash = this.cashFlowService.getMySelfBounty(userAccount.getUserId());
        this.logger.debug("\u65b0\u7528\u6237[{}]\u9996\u6b21\u767b\u9646\u4e34\u65f6\u8d4f\u91d1[{}]\u8f6c\u6362\u4e3a\u53ef\u63d0\u73b0\u8d4f\u91d1", (Object)userAccount.getUserId(), (Object)cash);
        if (cash.compareTo(BigDecimal.ZERO) > 0) {
            if (Boolean.TRUE.equals(isEffective)) {
                AccountCashParam param = new AccountCashParam(userAccount.getUserId(), CashEnum.TEMP_CASH.name(), Boolean.valueOf(false), cash, relationId, null, CashFlowConvertTypeEnum.TEMP_TO_DRAWABLE.name());
                this.userAccountService.transferCash(param);
            } else {
                AccountCashParam accountCashParam = new AccountCashParam();
                accountCashParam.setUserId(userAccount.getUserId());
                accountCashParam.setCashType(CashEnum.TEMP_CASH.name());
                accountCashParam.setAddTotal(Boolean.valueOf(false));
                accountCashParam.setCashFlowType(CashFlowTypeEnum.INVALID_PACKET.name());
                accountCashParam.setCash(new BigDecimal(-1).multiply(cash));
                accountCashParam.setRelationId(relationId);
                this.userAccountService.addCash(accountCashParam);
            }
        }
    }

    private void updateInviteUserState(InviteRecord inviteRecord, Boolean isEffective) {
        if (inviteRecord == null) {
            return;
        }
        if (!InviteRecordStateEnum.ACCEPT_INVITE.name().equals(inviteRecord.getInviteState())) {
            this.logger.info("\u5f53\u524d\u9080\u8bf7\u4eba[{}]\u4e0e\u53d7\u9080\u4eba[{}]\u7684\u72b6\u6001\u5904\u4e8e[{}]------\u4e0d\u4e88\u5904\u7406", new Object[]{inviteRecord.getUserId(), inviteRecord.getInvitedUserId(), inviteRecord.getInviteState()});
        }
        if (Boolean.TRUE.equals(isEffective)) {
            AccountCashParam param = new AccountCashParam(inviteRecord.getUserId(), CashEnum.STABILIZE_CASH.name(), Boolean.valueOf(false), inviteRecord.getAward(), inviteRecord.getId(), CashFlowTypeEnum.PROMOTE_BOUNTY.name(), CashFlowConvertTypeEnum.TEMP_TO_STABILIZE.name());
            this.userAccountService.transferCash(param);
            inviteRecord.setInviteState(InviteRecordStateEnum.LOGIN_APP.getName());
            inviteRecord.setEffectTime(null);
            inviteRecord.setAwardType(AwardTypeEnum.CASH.name());
            this.inviteRecordService.updateInviteRecord(inviteRecord);
        } else {
            AccountCashParam accountCashParam = new AccountCashParam();
            accountCashParam.setUserId(inviteRecord.getUserId());
            accountCashParam.setCashType(CashEnum.TEMP_CASH.name());
            accountCashParam.setAddTotal(Boolean.valueOf(false));
            accountCashParam.setCashFlowType(CashFlowTypeEnum.INVALID_BOUNTY.name());
            accountCashParam.setCash(new BigDecimal(-1).multiply(inviteRecord.getAward()));
            accountCashParam.setRelationId(inviteRecord.getId());
            this.userAccountService.addCash(accountCashParam);
            inviteRecord.setInviteState(InviteRecordStateEnum.OVERDUE_INVALID.name());
            inviteRecord.setAwardType(AwardTypeEnum.CASH.name());
            inviteRecord.setStatus(Byte.valueOf((byte)0));
            this.inviteRecordService.updateInviteRecord(inviteRecord);
        }
    }

    private void updateNicknameAndHeadImg(LoginInfo loginInfo, User user) {
        if (3 == loginInfo.getType() && (this.isTempNickName(loginInfo, user) || this.isTempHeadImg(loginInfo, user))) {
            User updateUser = new User();
            updateUser.setId(user.getId());
            if (this.isTempNickName(loginInfo, user)) {
                updateUser.setNickname(loginInfo.getNickname());
            }
            if (this.isTempHeadImg(loginInfo, user)) {
                updateUser.setHeadImg(loginInfo.getHeadImg());
            }
            this.userSyncService.sync(updateUser);
        }
    }

    private boolean isTempNickName(LoginInfo loginInfo, User user) {
        return user.getIsTempNickName() == 1 && null != loginInfo.getNickname();
    }

    private boolean isTempHeadImg(LoginInfo loginInfo, User user) {
        return user.getIsTempHeadImg() == 1 && null != loginInfo.getHeadImg();
    }

    private void updateWechat(LoginInfo loginInfo, User user, int platform) {
        this.logger.debug("\u7528\u6237\u767b\u9646\u4f20\u5165\u7684\u53c2\u6570\uff1a[{}]", (Object)JSON.toJSONString((Object)loginInfo));
        if (3 == loginInfo.getType()) {
            loginInfo.setUnionId(loginInfo.getLoginName());
        }
        if (null != loginInfo.getOpenId() && null != loginInfo.getUnionId()) {
            UserAuth userAuth = this.userAuthMapper.selectByUserId(Byte.valueOf((byte)3), user.getId());
            if (userAuth == null) {
                this.logger.debug("\u5f53\u524d\u7528\u6237\u521b\u5efaunionId\u9274\u6743\u4fe1\u606f:\u7528\u6237id\uff1a[{}], unionId:[{}]", (Object)user.getId(), (Object)loginInfo.getUnionId());
                Message isBindedMsg = this.checkBindExist((byte)3, loginInfo.getUnionId());
                if (isBindedMsg.isSuccess()) {
                    user.setWeixin(loginInfo.getUnionId());
                    this.userAuthService.addUserAuth((byte)3, user.getId(), loginInfo.getUnionId(), null);
                    if (null != loginInfo.getNickname()) {
                        user.setNickname(user.getNickname() == null ? loginInfo.getNickname() : user.getNickname());
                    }
                    if (null != loginInfo.getHeadImg()) {
                        user.setHeadImg(user.getHeadImg() == null ? loginInfo.getHeadImg() : user.getHeadImg());
                    }
                    this.userSyncService.sync(user);
                }
            }
            if ((userAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)6), loginInfo.getOpenId())) == null) {
                this.logger.debug("\u5f53\u524d\u7528\u6237\u521b\u5efaAPP\u5fae\u4fe1\u6388\u6743\u767b\u9646openId\u9274\u6743\u4fe1\u606f:\u7528\u6237id\uff1a[{}], openId:[{}]", (Object)user.getId(), (Object)loginInfo.getOpenId());
                this.userAuthService.addUserAuth((byte)6, user.getId(), loginInfo.getOpenId(), null);
            }
        }
    }

    private void callAsyncUpdateLocation(LoginInfo loginInfo, User user) {
        LoginService loginService = (LoginService)SpringContextHolder.getBean(LoginService.class);
        loginService.updateLocation(loginInfo, user);
    }

    @Override
    @Async
    public void updateLocation(LoginInfo loginInfo, User user) {
        User originalUser;
        if (null != loginInfo.getId() && null != (originalUser = this.userMapper.selectByPrimaryKey(loginInfo.getId())) && null != originalUser.getLocationCode() && null != originalUser.getLocationName()) {
            user.setLocationCode(originalUser.getLocationCode());
            user.setLocationName(originalUser.getLocationName());
        }
    }

    private void copyUserInfo(LoginInfo loginInfo, User user) {
        if (loginInfo.getId() == null || loginInfo.getId() == 0L) {
            this.logger.error(LogMarker.BIZ, "\u7528\u6237\u6ce8\u518c\uff0c\u4f46\u662f\u6ca1\u6709\u63d0\u4f9b\u9759\u9ed8\u6ce8\u518cID[H5\u7ad9\u5916\u6ce8\u518c\u4f8b\u5916]\uff0cloginInfo:[{}],user:[{}]", (Object)loginInfo, (Object)user);
            this.userNewsIntegrationService.initUserNewsImage(user.getId(), null);
        } else {
            this.logger.debug(LogMarker.BIZ, "\u7528\u6237\u6ce8\u518c,\u4ece\u8bbf\u5ba2\u8d26\u53f7\u62f7\u8d1d\u6807\u7b7e\u6743\u91cd\u4fe1\u606f\u548c\u9891\u9053\u5217\u8868\uff0cloginInfo:[{}],user:[{}]", (Object)loginInfo, (Object)user);
            this.userNewsIntegrationService.initUserNewsImage(user.getId(), loginInfo.getId());
        }
    }

    @Override
    public Json<LoginMeta> registerAndBindingPhone(LoginInfo loginInfo, int platform, Long userId, String chnl) {
        if (!this.bandingAndRegisterCheckParam(loginInfo)) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u9519\u8bef");
        }
        Message messageByCheckAuth = this.checkBindExist(loginInfo.getType(), loginInfo.getLoginName());
        if (!messageByCheckAuth.isSuccess()) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)messageByCheckAuth.getLashMessaage());
        }
        User user = this.getUserByType(loginInfo);
        Message messageByCheckUser = this.checkRepeatBind(user, loginInfo);
        if (!messageByCheckUser.isSuccess()) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)messageByCheckUser.getLashMessaage());
        }
        if (null != userId && null != (user = this.userMapper.selectByPrimaryKey(userId)) && 0 == user.getState()) {
            user = null;
        }
        if (1 == loginInfo.getType() && StringUtils.isNotBlank((CharSequence)loginInfo.getCode()) && !this.smsIntegrationService.verifySmsCodeByType(Byte.valueOf((byte)2), loginInfo.getPhone(), loginInfo.getCode()).booleanValue()) {
            return ResultUtil.genFailedResult((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u9a8c\u8bc1\u7801");
        }
        LoginMeta meta = this.registerAndBindingPhone(user, loginInfo, platform, chnl);
        return ResultUtil.genSuccessResult((Object)meta);
    }

    private User getUserByType(LoginInfo loginInfo) {
        User user = null;
        if (3 == loginInfo.getType()) {
            user = this.userMapper.findByWeixin(loginInfo.getLoginName());
        } else if (1 == loginInfo.getType()) {
            user = this.userMapper.findByPhone(loginInfo.getPhone());
        }
        return user;
    }

    private Message checkRepeatBind(User user, LoginInfo loginInfo) {
        if (null != user) {
            if (1 == loginInfo.getType() && StringUtils.isNotEmpty((CharSequence)user.getPhone())) {
                return Message.build((boolean)false, (String)"\u624b\u673a\u53f7\u5df2\u88ab\u7ed1\u5b9a");
            }
            if (3 == loginInfo.getType() && StringUtils.isNotEmpty((CharSequence)user.getWeixin())) {
                return Message.build((boolean)false, (String)"\u5fae\u4fe1\u53f7\u5df2\u88ab\u7ed1\u5b9a");
            }
            if (4 == loginInfo.getType() && StringUtils.isNotEmpty((CharSequence)user.getWeibo())) {
                return Message.build((boolean)false, (String)"\u5fae\u535a\u5df2\u88ab\u7ed1\u5b9a");
            }
            if (2 == loginInfo.getType() && StringUtils.isNotEmpty((CharSequence)user.getQq())) {
                return Message.build((boolean)false, (String)"QQ\u53f7\u5df2\u88ab\u7ed1\u5b9a");
            }
        }
        return Message.build((boolean)true);
    }

    private Message checkBindExist(Byte loginType, String loginName) {
        UserAuth auth = this.userAuthMapper.selectByUserAuth(loginType, loginName);
        if (null != auth) {
            if (1 == loginType) {
                return Message.build((boolean)false, (String)"\u624b\u673a\u53f7\u5df2\u88ab\u7ed1\u5b9a");
            }
            if (3 == loginType) {
                return Message.build((boolean)false, (String)"\u5fae\u4fe1\u53f7\u5df2\u88ab\u7ed1\u5b9a");
            }
            if (4 == loginType) {
                return Message.build((boolean)false, (String)"\u5fae\u535a\u5df2\u88ab\u7ed1\u5b9a");
            }
            if (2 == loginType) {
                return Message.build((boolean)false, (String)"QQ\u53f7\u5df2\u88ab\u7ed1\u5b9a");
            }
        }
        return Message.build((boolean)true);
    }

    private LoginMeta registerAndBindingPhone(User user, LoginInfo loginInfo, int platform, String chnl) {
        UserInfoDTO dto;
        boolean isFirstLogin = false;
        LoginMeta meta = new LoginMeta();
        if (null != user) {
            if (StringUtils.isBlank((CharSequence)user.getEquipment())) {
                isFirstLogin = true;
            }
            this.syncThirdPartyInfo(user, loginInfo);
            this.updateTokenAfterBinding(user, loginInfo, platform);
            this.addUserAuth(loginInfo, user.getId());
            dto = this.userService.getUserToDTO(user);
        } else {
            isFirstLogin = true;
            DefaultUserWarper warper = this.addDefaultUser(loginInfo, platform, chnl);
            user = warper.user;
            dto = warper.dto;
        }
        this.userLoginHistoryService.save(user, loginInfo);
        if (isFirstLogin && loginInfo.getType() == 3) {
            this.logger.info("\u7528\u6237\u7b2c\u4e00\u6b21\u5fae\u4fe1\u6388\u6743\u767b\u9646-----\u7ed1\u5b9aVIP\u9080\u8bf7\u5173\u7cfb");
            this.dealVipActivation(user.getId(), loginInfo.getLoginName());
        }
        this.redisHashMapAdapter.put(RedisConfig.USER_INFO, user.getId().toString(), (Object)JSON.toJSONString((Object)dto));
        meta.setUser(dto);
        meta.setFirstLogin(isFirstLogin);
        return meta;
    }

    private void updateTokenAfterBinding(User user, LoginInfo loginInfo, int platform) {
        user.setLastLoginTime(new Date());
        this.userMapper.updateByPrimaryKeySelective(user);
        if (StringUtils.isNotEmpty((CharSequence)user.getPhone()) && user.getPhone().startsWith("170") || user.getPhone().startsWith("171")) {
            this.userMapper.updateUserToRisk(user.getId());
        } else if (this.checkRisk(user, loginInfo, platform).booleanValue()) {
            this.userMapper.updateUserToRisk(user.getId());
        }
    }

    private Boolean checkRisk(User user, LoginInfo loginInfo, int platform) {
        String operateSource = "";
        if (platform == 1) {
            operateSource = "ANDROID";
        } else if (platform == 2) {
            operateSource = "IOS";
        }
        RiskParam riskParam = new RiskParam();
        riskParam.setDeviceToken(loginInfo.getDeviceToken());
        riskParam.setIp(loginInfo.getRegIp());
        riskParam.setOperateSource(operateSource);
        riskParam.setPhone(user.getPhone());
        riskParam.setEquiment(user.getEquipment());
        riskParam.setOperateSystem(loginInfo.getPhonemodel());
        return this.riskRecordService.checkRiskDevice(riskParam);
    }

    private DefaultUserWarper addDefaultUser(LoginInfo loginInfo, int platform, String chnl) {
        User user = this.userService.addUser(loginInfo, platform, chnl, (byte)1);
        UserInfoDTO dto = this.userService.getUserToDTO(user);
        dto.setCreateTime(new Date());
        this.copyUserInfo(loginInfo, user);
        if (null != loginInfo.getInviteCode()) {
            this.inviteRelationIntegrationService.addInviteRelation(user.getId(), loginInfo.getInviteCode());
        }
        return new DefaultUserWarper(user, dto);
    }

    private void dealVipActivation(Long userId, String wechat) {
        this.vipIntegrationService.saveVipViewRecord(userId, wechat);
    }

    private void addUserAuth(LoginInfo loginInfo, Long userId) {
        this.logger.info("\u6dfb\u52a0\u7528\u6237\u6743\u9650\u8ba4\u8bc1");
        UserAuth auth = new UserAuth();
        auth.setUserId(userId);
        auth.setType(loginInfo.getType());
        if (StringUtils.equals((CharSequence)loginInfo.getPhone(), (CharSequence)loginInfo.getLoginName())) {
            auth.setIdentifier(loginInfo.getPhone());
            if (StringUtils.isNotEmpty((CharSequence)loginInfo.getPassword())) {
                auth.setCredential(MD5Util.hgmd5((String)loginInfo.getPassword()));
            }
            this.userAuthMapper.insertSelective(auth);
        }
        if (StringUtils.notEquals((CharSequence)loginInfo.getPhone(), (CharSequence)loginInfo.getLoginName())) {
            auth.setIdentifier(loginInfo.getLoginName());
            this.userAuthMapper.insertSelective(auth);
        }
    }

    private boolean checkParam(LoginInfo loginInfo) {
        if (1 != loginInfo.getType() && 3 != loginInfo.getType() && 2 != loginInfo.getType() && 4 != loginInfo.getType()) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)loginInfo.getLoginName())) {
            return false;
        }
        return 1 != loginInfo.getType() || !StringUtils.isEmpty((CharSequence)loginInfo.getPassword()) || !StringUtils.isEmpty((CharSequence)loginInfo.getCode());
    }

    private boolean bandingAndRegisterCheckParam(LoginInfo loginInfo) {
        if (3 != loginInfo.getType() && 2 != loginInfo.getType() && 1 != loginInfo.getType() && 4 != loginInfo.getType()) {
            return false;
        }
        return !StringUtils.isBlank((CharSequence)loginInfo.getLoginName()) || !StringUtils.isBlank((CharSequence)loginInfo.getPhone()) || !StringUtils.isBlank((CharSequence)loginInfo.getCode()) || !StringUtils.isBlank((CharSequence)loginInfo.getPassword());
    }

    private void syncThirdPartyInfo(User user, LoginInfo loginInfo) {
        if (1 == loginInfo.getType()) {
            user.setPhone(loginInfo.getLoginName());
        } else if (2 == loginInfo.getType()) {
            user.setQq(loginInfo.getLoginName());
        } else if (4 == loginInfo.getType()) {
            user.setWeibo(loginInfo.getLoginName());
        } else if (3 == loginInfo.getType()) {
            user.setWeixin(loginInfo.getLoginName());
            if (null != loginInfo.getNickname()) {
                user.setNickname(user.getNickname() == null ? loginInfo.getNickname() : user.getNickname());
            }
            if (null != loginInfo.getHeadImg()) {
                user.setHeadImg(user.getHeadImg() == null ? loginInfo.getHeadImg() : user.getHeadImg());
            }
        }
    }

    private class DefaultUserWarper {
        User user;
        UserInfoDTO dto;

        DefaultUserWarper(User user, UserInfoDTO dto) {
            this.user = user;
            this.dto = dto;
        }
    }
}

