/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.service.impl;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.config.CommonProperties;
import com.bxm.localnews.user.dto.LocationDTO;
import com.bxm.localnews.user.dto.UserCashGoldDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.UserRedPacketDTO;
import com.bxm.localnews.user.enums.AwardTypeEnum;
import com.bxm.localnews.user.enums.CashEnum;
import com.bxm.localnews.user.enums.CashFlowTypeEnum;
import com.bxm.localnews.user.enums.InviteRecordStateEnum;
import com.bxm.localnews.user.integration.LocationIntegrationService;
import com.bxm.localnews.user.param.AccountCashParam;
import com.bxm.localnews.user.service.InviteRecordService;
import com.bxm.localnews.user.service.RedPacketService;
import com.bxm.localnews.user.service.UserAccountService;
import com.bxm.localnews.user.service.UserService;
import com.bxm.localnews.user.vo.InviteRecord;
import com.bxm.localnews.user.vo.User;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.service.BaseService;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service
@RefreshScope
public class RedPacketServiceImpl
extends BaseService
implements RedPacketService {
    private UserService userService;
    private UserAccountService userAccountService;
    private LocationIntegrationService locationIntegrationService;
    private InviteRecordService inviteRecordService;
    private CommonProperties commonProperties;
    private DistributedLock distributedLock;

    @Autowired
    public RedPacketServiceImpl(UserService userService, UserAccountService userAccountService, LocationIntegrationService locationIntegrationService, InviteRecordService inviteRecordService, CommonProperties commonProperties, DistributedLock distributedLock) {
        this.userService = userService;
        this.userAccountService = userAccountService;
        this.locationIntegrationService = locationIntegrationService;
        this.inviteRecordService = inviteRecordService;
        this.commonProperties = commonProperties;
        this.distributedLock = distributedLock;
    }

    @Override
    public Json<BigDecimal> userRecieveRedPacket(Long userId, BasicParam basicParam, String areaCode) {
        LocationDTO locationDTO = this.getLocationByAreaCode(areaCode);
        if (!this.userIsReceiveRedPacket(userId, locationDTO, basicParam.getDevcId()).booleanValue()) {
            this.logger.debug("\u5f53\u524d\u7528\u6237[{}]\u5df2\u9886\u53d6\u7ea2\u5305", (Object)userId);
            return ResultUtil.genFailedResult((String)"\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.logger.info("\u7528\u6237[{}]\u5728\u5730\u533a[{}]\u9886\u53d6\u7ea2\u5305\u91d1\u989d\u4e3a\uff1a[{}]", new Object[]{userId, areaCode, locationDTO.getNewRedPacket()});
        String requestId = this.nextSequence().toString();
        if (this.distributedLock.lock(userId.toString(), requestId)) {
            User user = this.userService.selectByPrimaryKey(userId);
            if (user.getInviteUserId() != null) {
                this.logger.info("\u7528\u6237[{}]\u7684\u9080\u8bf7\u4eba\u4e0d\u4e3a\u7a7a\uff0c\u9080\u8bf7\u4ebaid\uff1a[{}]", (Object)userId, (Object)user.getInviteUserId());
                InviteRecord inviteRecord = this.inviteRecordService.getInviteRecordByInvitedUser(user.getInviteUserId(), userId);
                if (inviteRecord != null) {
                    this.logger.info("\u9080\u8bf7\u4eba[{}]\u589e\u52a0\u6c38\u4e45\u8d4f\u91d1[{}]", (Object)user.getInviteUserId(), (Object)locationDTO.getPromoteBounty());
                    inviteRecord.setAward(inviteRecord.getAward().add(locationDTO.getPromoteBounty()));
                    inviteRecord.setInviteState(InviteRecordStateEnum.LOGIN_APP.getName());
                    inviteRecord.setAwardType(AwardTypeEnum.CASH.name());
                    this.updateInviteRecord(inviteRecord);
                    this.addUserAccountByPromote(inviteRecord.getUserId(), locationDTO.getPromoteBounty(), inviteRecord.getId());
                }
            }
        } else {
            return ResultUtil.genFailedResult((String)"\u4f60\u5df2\u9886\u53d6\u8fc7\u65b0\u4eba\u7ea2\u5305");
        }
        this.logger.debug("\u5f53\u524d\u7528\u6237[{}]\u589e\u52a0\u7ea2\u5305\u91d1\u989d[{}]", (Object)userId, (Object)locationDTO.getNewRedPacket());
        this.addUserAccountByRedPacket(userId, locationDTO.getNewRedPacket(), null);
        this.userService.updateUserRecieveRedPacket(userId);
        this.distributedLock.unlock(userId.toString(), requestId);
        return ResultUtil.genSuccessResult((Object)locationDTO.getNewRedPacket());
    }

    private void addUserAccountByRedPacket(Long userId, BigDecimal award, Long relationId) {
        AccountCashParam accountCashParam = new AccountCashParam(userId, CashEnum.DRAWABLEL_CASH.name(), Boolean.TRUE, award, relationId, CashFlowTypeEnum.RED_PACKET.name(), null);
        this.userAccountService.addCash(accountCashParam);
    }

    private void addUserAccountByPromote(Long userId, BigDecimal award, Long relationId) {
        AccountCashParam accountCashParam = new AccountCashParam(userId, CashEnum.STABILIZE_CASH.name(), Boolean.TRUE, award, relationId, CashFlowTypeEnum.PROMOTE_BOUNTY.name(), null);
        this.userAccountService.addCash(accountCashParam);
    }

    private void updateInviteRecord(InviteRecord inviteRecord) {
        this.inviteRecordService.updateInviteRecord(inviteRecord);
    }

    @Override
    public UserRedPacketDTO enableRedPacket(BasicParam basicParam, Long userId, String areaCode) {
        InviteRecord inviteRecord;
        UserRedPacketDTO userRedPacketDTO = new UserRedPacketDTO();
        LocationDTO locationDTO = this.getLocationByAreaCode(areaCode);
        if (!this.userIsReceiveRedPacket(userId, locationDTO, basicParam.getDevcId()).booleanValue()) {
            return userRedPacketDTO;
        }
        userRedPacketDTO.setEnableRedPacket(this.byteToBoolean(locationDTO.getEnablePaidPromote()));
        userRedPacketDTO.setAmount(locationDTO.getNewRedPacket());
        userRedPacketDTO.setInviteUserHeadImg(this.commonProperties.getAppIconUrl());
        userRedPacketDTO.setInviteUserNickname(this.commonProperties.getAppName());
        userRedPacketDTO.setLinkUrl(this.commonProperties.getLinkUrl());
        User user = this.userService.selectByPrimaryKey(userId);
        if (user != null && user.getInviteUserId() != null && (inviteRecord = this.inviteRecordService.getInviteRecordByInvitedUser(user.getInviteUserId(), userId)) != null) {
            UserInfoDTO userInfoDTO = this.userService.getUserFromRedisDB(user.getInviteUserId());
            userRedPacketDTO.setInviteUserNickname(userInfoDTO.getNickname());
            userRedPacketDTO.setInviteUserHeadImg(userInfoDTO.getHeadImg());
        }
        return userRedPacketDTO;
    }

    private Boolean userIsReceiveRedPacket(Long userId, LocationDTO locationDTO, String equipment) {
        if (locationDTO == null || !this.byteToBoolean(locationDTO.getEnablePaidPromote()).booleanValue()) {
            this.logger.debug("\u5f53\u524d\u5730\u533a[{}]\u672a\u5f00\u901a\u63a8\u5e7f\u8d5a\u94b1", (Object)locationDTO.getName());
            return Boolean.FALSE;
        }
        Long equipmentUser = this.userService.checkExistEquipment(equipment);
        if (equipmentUser != null && equipmentUser > 0L) {
            this.logger.debug("\u5f53\u524d\u8bbe\u5907[{}]\u5df2\u9886\u53d6\u7ea2\u5305", (Object)equipment);
            return Boolean.FALSE;
        }
        User user = this.userService.selectByPrimaryKey(userId);
        if (user != null && !this.byteToBoolean(user.getReceiveRedPacket()).booleanValue()) {
            this.logger.debug("\u5f53\u524d\u7528\u6237[{}]\u5df2\u9886\u53d6\u7ea2\u5305", (Object)userId);
            return Boolean.FALSE;
        }
        UserCashGoldDTO userCashGoldDTO = this.userAccountService.getUserCashGold(userId);
        if (userCashGoldDTO.getCash().compareTo(BigDecimal.ZERO) != 0) {
            this.logger.debug("\u7528\u6237[{}]\u7684\u4f59\u989d[{}]\u4e0d\u4e3a0", (Object)userId, (Object)userCashGoldDTO.getCash());
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private LocationDTO getLocationByAreaCode(String areaCode) {
        return this.locationIntegrationService.getLocationByGeocode(areaCode);
    }

    private Boolean byteToBoolean(byte byteNumber) {
        return byteNumber == 1 ? Boolean.TRUE : Boolean.FALSE;
    }
}

