/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.config.BizConfigProperties;
import com.bxm.localnews.user.config.UserProperties;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.UserAuthMapper;
import com.bxm.localnews.user.domain.UserLocationHistoryMapper;
import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.dto.LocationDTO;
import com.bxm.localnews.user.dto.LocationUserInfoDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.enums.AppConst;
import com.bxm.localnews.user.enums.InviteTypeEnum;
import com.bxm.localnews.user.enums.LevelEunm;
import com.bxm.localnews.user.enums.TaskEnum;
import com.bxm.localnews.user.integration.BizLogIntegrationService;
import com.bxm.localnews.user.integration.LocationIntegrationService;
import com.bxm.localnews.user.integration.MissionIntegrationService;
import com.bxm.localnews.user.integration.SmsIntegrationService;
import com.bxm.localnews.user.integration.UserNewsIntegrationService;
import com.bxm.localnews.user.param.PushParam;
import com.bxm.localnews.user.param.TempUserParam;
import com.bxm.localnews.user.param.UserParam;
import com.bxm.localnews.user.service.ChannelService;
import com.bxm.localnews.user.service.InviteRecordService;
import com.bxm.localnews.user.service.NoviceTaskRecordService;
import com.bxm.localnews.user.service.PayFlowService;
import com.bxm.localnews.user.service.UserAccountService;
import com.bxm.localnews.user.service.UserAuthService;
import com.bxm.localnews.user.service.UserInternalService;
import com.bxm.localnews.user.service.UserLoginHistoryService;
import com.bxm.localnews.user.service.UserService;
import com.bxm.localnews.user.service.UserSyncService;
import com.bxm.localnews.user.vo.LoginInfo;
import com.bxm.localnews.user.vo.LoginMeta;
import com.bxm.localnews.user.vo.PayFlow;
import com.bxm.localnews.user.vo.PushInfo;
import com.bxm.localnews.user.vo.RegSourceCounter;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserAuth;
import com.bxm.localnews.user.vo.UserLocationHistory;
import com.bxm.newidea.component.log.LogMarker;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.tools.UUIDUtils;
import com.bxm.newidea.component.vo.Message;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="userService")
@RefreshScope
public class UserServiceImpl
extends BaseService
implements UserService,
UserInternalService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    private static final long MAX_HEAD_IMAGE_SIZE = 0x500000L;
    private static final int AREA_CODE_LENGTH = 12;
    @Resource
    private SmsIntegrationService smsIntegrationService;
    @Resource
    private UserAuthService userAuthService;
    @Resource
    private NoviceTaskRecordService noviceTaskRecordService;
    @Resource
    private PayFlowService payFlowService;
    @Resource
    private UserAccountService userAccountService;
    @Resource
    private UserMapper userMapper;
    @Resource
    private UserAuthMapper userAuthMapper;
    @Resource
    private UserProperties userProperties;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private UserLocationHistoryMapper userLocationHistoryMapper;
    @Resource
    private LocationIntegrationService locationIntegrationService;
    @Resource
    private AliyunOSSService aliyunOSSService;
    @Resource
    private BizConfigProperties bizConfigProperties;
    @Resource
    private ChannelService channelService;
    @Resource
    private MissionIntegrationService missionIntegrationService;
    @Resource
    private BizLogIntegrationService bizLogIntegrationService;
    @Resource
    private UserLoginHistoryService userLoginHistoryService;
    @Resource
    private UserNewsIntegrationService userNewsIntegrationService;
    @Resource
    private UserSyncService userSyncService;
    @Resource
    private InviteRecordService inviteRecordService;
    @Autowired
    private DistributedLock distributedLock;

    @Override
    public UserInfoDTO getUserFromRedisDB(long userId) {
        UserInfoDTO dto = this.getUserRedis(userId);
        if (null == dto) {
            dto = this.loadUserToRedis(userId);
        }
        return dto;
    }

    private UserInfoDTO getUserRedis(long userId) {
        this.logger.debug("\u4eceredis\u83b7\u53d6\u7528\u6237[{}]\u6570\u636e", (Object)userId);
        String userStr = (String)this.redisHashMapAdapter.get(RedisConfig.USER_INFO, userId + "", String.class);
        return (UserInfoDTO)JSON.parseObject((String)userStr, UserInfoDTO.class);
    }

    private UserInfoDTO loadUserToRedis(Long userId) {
        User user = this.userMapper.selectByPrimaryKey(userId);
        if (user != null) {
            UserInfoDTO dto = this.getUserToDTO(user);
            this.redisHashMapAdapter.put(RedisConfig.USER_INFO, userId + "", (Object)JSON.toJSONString((Object)dto));
            return dto;
        }
        return null;
    }

    @Override
    public boolean checkUserExistByPhone(String phone, Integer flag) {
        User user = this.userMapper.findByPhone(phone);
        if (null == user) {
            return false;
        }
        UserAuth userAuth = this.userAuthMapper.selectByUserId(Byte.valueOf((byte)3), user.getId());
        if (flag == 1) {
            return userAuth != null;
        }
        return true;
    }

    @Override
    public UserInfoDTO getUserToDTO(User user) {
        UserInfoDTO dto = new UserInfoDTO();
        BeanUtils.copyProperties((Object)user, (Object)dto);
        if (StringUtils.isBlank((CharSequence)dto.getNickname())) {
            dto.setNickname(StringUtils.hideMobile((String)user.getPhone()));
        }
        if (StringUtils.isBlank((CharSequence)dto.getHeadImg())) {
            dto.setHeadImg(this.userProperties.getDefaultHeadImgUrl());
        }
        return dto;
    }

    @Override
    public String getToken() {
        long currentTime = System.currentTimeMillis();
        Random random = new Random();
        String appkey = this.userProperties.getAppKey();
        return MD5Util.hgmd5((String)(currentTime + appkey + random.nextInt(1000)));
    }

    @Override
    public Long getExpireTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 30);
        return calendar.getTime().getTime();
    }

    @Override
    public Json<UserInfoDTO> refreshToken(Long userId, String refreshToken) {
        User user = this.userMapper.getUserByRefreshToken(userId.longValue(), refreshToken);
        if (null == user) {
            return ResultUtil.genFailedResult((int)RespCode.UNAUTHORIZED, (String)"\u767b\u5f55\u5931\u6548");
        }
        user.setExpiretime(this.getExpireTime());
        user.setToken(this.getToken());
        this.userMapper.updateByPrimaryKeySelective(user);
        UserInfoDTO dto = this.getUserToDTO(user);
        this.redisHashMapAdapter.put(RedisConfig.USER_INFO, userId + "", (Object)JSON.toJSONString((Object)dto));
        return ResultUtil.genSuccessResult((Object)dto);
    }

    @Override
    public Json<LoginMeta> register(LoginInfo loginInfo, BasicParam basicParam, String firstOpenType) {
        if (StringUtils.isEmpty((CharSequence)loginInfo.getEquipment())) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u7f3a\u5c11\u53c2\u6570");
        }
        User user = this.userMapper.findByEquipment(loginInfo.getEquipment());
        if (null == user) {
            user = this.addUser(loginInfo, basicParam.getPlatform(), basicParam.getChnl(), (byte)0);
            this.logger.debug(LogMarker.BIZ, "\u7528\u6237\u9759\u9ed8\u6ce8\u518c\u751f\u6210\u9ed8\u8ba4\u9891\u9053\u5217\u8868\uff0cloginInfo:[{}]", (Object)loginInfo);
            this.userNewsIntegrationService.initUserNewsImage(user.getId(), null);
            this.userLoginHistoryService.save(user, loginInfo);
        }
        UserInfoDTO dto = this.getUserToDTO(user);
        this.redisHashMapAdapter.put(RedisConfig.USER_INFO, user.getId().toString(), (Object)JSON.toJSONString((Object)dto));
        return ResultUtil.genSuccessResult((Object)new LoginMeta(dto));
    }

    @Override
    public Json<User> doH5Register(LoginInfo loginInfo, Integer platform, String chnl) {
        if (!this.checkH5RegisterParam(loginInfo)) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u7f3a\u5c11\u53c2\u6570");
        }
        if (!this.checkSmsCode(loginInfo)) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u9a8c\u8bc1\u7801");
        }
        String messageByCheckAuth = this.checkBindExist(loginInfo);
        if (StringUtils.isNotBlank((CharSequence)messageByCheckAuth)) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)messageByCheckAuth);
        }
        User user = this.userMapper.findByPhone(loginInfo.getLoginName());
        if (null != user) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u624b\u673a\u53f7\u5df2\u6ce8\u518c");
        }
        user = this.addUser(loginInfo, platform, chnl, (byte)1);
        if (user.getId() > 0L) {
            this.logger.debug(LogMarker.BIZ, "\u7528\u6237H5\u6ce8\u518c\uff0cloginInfo:[{}]", (Object)loginInfo);
            this.userNewsIntegrationService.initUserNewsImage(user.getId(), null);
            return ResultUtil.genSuccessResult((Object)user);
        }
        return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u6ce8\u518c\u5931\u8d25");
    }

    private boolean checkSmsCode(LoginInfo loginInfo) {
        if (!this.smsIntegrationService.verifySmsCodeByType(Byte.valueOf((byte)3), loginInfo.getLoginName(), loginInfo.getCode()).booleanValue()) {
            this.logger.debug("checkVcode failed,loginInfo[{}]", (Object)loginInfo);
            return false;
        }
        return true;
    }

    private boolean checkH5RegisterParam(LoginInfo loginInfo) {
        return !StringUtils.isBlank((CharSequence)loginInfo.getLoginName()) && 1 == loginInfo.getType() && !StringUtils.isBlank((CharSequence)loginInfo.getCode());
    }

    @Override
    public User addUser(LoginInfo loginInfo, Integer platform, String chnl, Byte userType) {
        boolean notVisitor;
        User user = this.saveUser(loginInfo, platform, chnl, userType);
        boolean bl = notVisitor = 0 != userType;
        if (notVisitor) {
            this.saveAuths(user.getId(), loginInfo);
            this.noviceTaskRecordService.batchAdd(user.getId());
            this.userAccountService.createUserAccount(user.getId());
            this.saveRegSourceInfo(loginInfo, user, chnl);
            this.bizLogIntegrationService.newUser(user.getId(), chnl, loginInfo.getLoginName());
        }
        return user;
    }

    private User saveUser(LoginInfo loginInfo, Integer platform, String chnl, Byte userType) {
        User originalUser;
        Date date = new Date();
        User user = new User();
        user.setToken(this.getToken());
        user.setRefreshtoken(this.getToken());
        user.setRegisterClient(null == platform ? "0" : String.valueOf(platform));
        user.setAge(0);
        user.setSex(Byte.valueOf((byte)1));
        user.setPhone(loginInfo.getPhone());
        user.setEquipment(loginInfo.getEquipment());
        user.setRegisteredAddress(loginInfo.getRegisteredaddress());
        user.setPhoneModel(loginInfo.getPhonemodel());
        user.setState(userType);
        user.setLevel(LevelEunm.INITIAL_USER.getType());
        user.setIsNew(Byte.valueOf((byte)0));
        user.setExpiretime(this.getExpireTime());
        user.setLastLoginTime(date);
        user.setIsTempNickName(Byte.valueOf((byte)1));
        user.setIsTempHeadImg(Byte.valueOf((byte)1));
        if (null != loginInfo.getRegIp()) {
            user.setRegIp(loginInfo.getRegIp());
        }
        if (null != loginInfo.getLastLoginIp()) {
            user.setLastLoginIp(loginInfo.getLastLoginIp());
        }
        user.setLocationCode(this.bizConfigProperties.getLocationCode());
        user.setLocationName(this.bizConfigProperties.getLocationName());
        if (null != loginInfo.getId() && null != (originalUser = this.userMapper.selectByPrimaryKey(loginInfo.getId())) && null != originalUser.getLocationCode() && null != originalUser.getLocationName()) {
            user.setLocationCode(originalUser.getLocationCode());
            user.setLocationName(originalUser.getLocationName());
        }
        user.setChannelId(this.getChannelId(chnl));
        this.userMapper.insertSelective(user);
        if (0 != userType) {
            User loginUser = new User();
            loginUser.setId(user.getId());
            this.setLoginName(loginUser, loginInfo);
            this.userMapper.updateByPrimaryKeySelective(loginUser);
        }
        return user;
    }

    private void saveAuths(Long userId, LoginInfo loginInfo) {
        ArrayList<UserAuth> auths = new ArrayList<UserAuth>();
        UserAuth auth = new UserAuth();
        auth.setUserId(userId);
        auth.setType(loginInfo.getType());
        auth.setIdentifier(loginInfo.getLoginName());
        if (StringUtils.isNotBlank((CharSequence)loginInfo.getPassword())) {
            auth.setCredential(MD5Util.hgmd5((String)loginInfo.getPassword()));
        }
        auths.add(auth);
        this.logger.warn("\u6dfb\u52a0\u6743\u9650\u9a8c\u8bc1:{}", (Object)loginInfo.getLoginName());
        if (1 != loginInfo.getType()) {
            if (null != loginInfo.getPhone()) {
                UserAuth phoneAuth = new UserAuth();
                phoneAuth.setUserId(userId);
                phoneAuth.setType(Byte.valueOf((byte)1));
                phoneAuth.setIdentifier(loginInfo.getPhone());
                if (StringUtils.isNotBlank((CharSequence)loginInfo.getPassword())) {
                    phoneAuth.setCredential(MD5Util.hgmd5((String)loginInfo.getPassword()));
                }
                auths.add(phoneAuth);
            }
            if (loginInfo.getOpenId() != null) {
                UserAuth openIdAuth = new UserAuth();
                openIdAuth.setUserId(userId);
                openIdAuth.setType(Byte.valueOf((byte)6));
                openIdAuth.setIdentifier(loginInfo.getOpenId());
                if (StringUtils.isNotBlank((CharSequence)loginInfo.getPassword())) {
                    openIdAuth.setCredential(MD5Util.hgmd5((String)loginInfo.getPassword()));
                }
                auths.add(openIdAuth);
            }
        }
        this.userAuthMapper.batchAdd(auths);
    }

    private void saveRegSourceInfo(LoginInfo loginInfo, User user, String chnl) {
        Long inviteCode = loginInfo.getInviteCode();
        if (null == inviteCode) {
            return;
        }
        this.logger.debug(LogMarker.BIZ, "\u7528\u6237\u9080\u8bf7\u8bb0\u5f55,loginInfo:[{}],user:[{}],chnl:[{}]", new Object[]{loginInfo, user, chnl});
        this.saveRegSourceCount(loginInfo, user, chnl);
        this.bizLogIntegrationService.inviteSuccessed(inviteCode, user.getId());
        this.missionIntegrationService.completeTask(inviteCode, TaskEnum.TASK_INVITED_FRIEND, user.getId().toString());
    }

    private void statisticsGold(Long inviteCode) {
        KeyGenerator userRewardSumKey = RedisConfig.USER_MISSION_REWARD_SUM_PER_DAY.copy().setKey(inviteCode + ":" + DateUtils.formatDate((Date)new Date()));
        this.redisStringAdapter.incrementWithDefault(userRewardSumKey, AppConst.INVITE_NEW_USER_REWARD_GOLD_NUM.longValue(), AppConst.INVITE_NEW_USER_REWARD_GOLD_NUM.intValue());
        this.redisStringAdapter.expire(userRewardSumKey, (long)DateUtils.getCurSeconds());
    }

    private void generatorInvitationReward(Long userId, Long inviteCode) {
        PayFlow payFlow = PayFlow.initPayFlow((Long)inviteCode, (Byte)TaskEnum.TASK_INVITED_FRIEND.getType(), (Byte)10, (String)userId.toString());
        this.payFlowService.modifyAccountFlowAndStatByGold(payFlow, AppConst.INVITE_NEW_USER_REWARD_GOLD_NUM, false);
    }

    private void saveRegSourceCount(LoginInfo loginInfo, User user, String chnl) {
        RegSourceCounter counter = new RegSourceCounter();
        counter.setId(this.nextSequence().toString());
        counter.setRegTime(new Date());
        counter.setUserId(user.getId());
        counter.setChannel(this.getChannelId(chnl));
        counter.setInviteUserId(loginInfo.getInviteCode());
    }

    private Long getChannelId(String chnl) {
        return this.channelService.getChannelByCode(chnl).getId();
    }

    private void setLoginName(User user, LoginInfo loginInfo) {
        if (1 == loginInfo.getType()) {
            user.setPhone(loginInfo.getLoginName());
        } else if (2 == loginInfo.getType()) {
            user.setQq(loginInfo.getLoginName());
        } else if (4 == loginInfo.getType()) {
            user.setWeibo(loginInfo.getLoginName());
        } else if (3 == loginInfo.getType()) {
            user.setWeixin(loginInfo.getLoginName());
            user.setNickname(user.getNickname() == null ? loginInfo.getNickname() : user.getNickname());
            user.setHeadImg(user.getHeadImg() == null ? this.getImageFromUrl(loginInfo.getHeadImg(), user.getId()) : user.getHeadImg());
        } else {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
    }

    private String getImageFromUrl(String headImg, Long userId) {
        try {
            URL url = new URL(headImg);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(3000);
            InputStream inputStream = null;
            if (conn.getResponseCode() == 200) {
                inputStream = conn.getInputStream();
                this.logger.debug("\u6839\u636eurl\u83b7\u5f97\u56fe\u7247\u7684\u6d41\u72b6\u6001\uff1a{}", (Object)inputStream.available());
            }
            int hashCode = (int)(userId % 10L);
            String path = "avatar/" + hashCode + "/" + UUIDUtils.nextID() + ".jpeg";
            return this.aliyunOSSService.upload(inputStream, path) + "?x-oss-process=style/head";
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Json<UserInfoDTO> binding(LoginInfo loginInfo, Long userId) {
        if (!this.bindingCheckParam(loginInfo)) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
        }
        if (1 == loginInfo.getType() && !this.smsIntegrationService.verifySmsCodeByType(Byte.valueOf((byte)2), loginInfo.getLoginName(), loginInfo.getCode()).booleanValue()) {
            return ResultUtil.genFailedResult((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u9a8c\u8bc1\u7801");
        }
        String messageByCheckAuth = this.checkBindExist(loginInfo);
        if (StringUtils.isNotBlank((CharSequence)messageByCheckAuth)) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)messageByCheckAuth);
        }
        User user = this.userMapper.selectByPrimaryKey(userId);
        String messageByCheckUser = this.checkBindRepeat(loginInfo.getType(), user);
        if (StringUtils.isNotBlank((CharSequence)messageByCheckUser)) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)messageByCheckUser);
        }
        this.setLoginName(user, loginInfo);
        this.userMapper.updateByPrimaryKeySelective(user);
        this.userAuthService.addUserAuth(loginInfo.getType(), user.getId(), loginInfo.getLoginName(), null);
        UserInfoDTO dto = this.getUserToDTO(user);
        this.checkCompleteInfo(dto);
        this.logger.debug("\u628a\u7528\u6237[{}]\u6570\u636e[{}]\u5b58\u5165redis", (Object)userId, (Object)JSON.toJSONString((Object)dto));
        this.redisHashMapAdapter.put(RedisConfig.USER_INFO, user.getId() + "", (Object)JSON.toJSONString((Object)dto));
        return ResultUtil.genSuccessResult((Object)dto);
    }

    private String checkBindExist(LoginInfo loginInfo) {
        UserAuth auth = this.userAuthMapper.selectByUserAuth(loginInfo.getType(), loginInfo.getLoginName());
        String message = "";
        if (null != auth) {
            if (1 == loginInfo.getType()) {
                message = "\u624b\u673a\u53f7\u5df2\u88ab\u7ed1\u5b9a";
            } else if (3 == loginInfo.getType()) {
                message = "\u5fae\u4fe1\u53f7\u5df2\u88ab\u7ed1\u5b9a";
            } else if (4 == loginInfo.getType()) {
                message = "\u5fae\u535a\u5df2\u88ab\u7ed1\u5b9a";
            } else if (2 == loginInfo.getType()) {
                message = "QQ\u53f7\u5df2\u88ab\u7ed1\u5b9a";
            }
        }
        return message;
    }

    private String checkBindRepeat(Byte loginInfoType, User user) {
        String message = "";
        if (1 == loginInfoType && StringUtils.isNotBlank((CharSequence)user.getPhone())) {
            message = "\u8bf7\u52ff\u91cd\u590d\u7ed1\u5b9a\u624b\u673a\u53f7";
        } else if (3 == loginInfoType && StringUtils.isNotBlank((CharSequence)user.getWeixin())) {
            message = "\u8bf7\u52ff\u91cd\u590d\u7ed1\u5b9a\u5fae\u4fe1\u8d26\u53f7";
        } else if (4 == loginInfoType && StringUtils.isNotBlank((CharSequence)user.getWeibo())) {
            message = "\u8bf7\u52ff\u91cd\u590d\u7ed1\u5b9a\u5fae\u535a\u8d26\u53f7";
        } else if (2 == loginInfoType && StringUtils.isNotBlank((CharSequence)user.getQq())) {
            message = "\u8bf7\u52ff\u91cd\u590d\u7ed1\u5b9aQQ\u8d26\u53f7";
        }
        return message;
    }

    @Override
    public Message updateUserInfo(UserParam updateUser, Long userId, MultipartFile file) {
        int i;
        User user = this.userMapper.selectByPrimaryKey(userId);
        if (1 != user.getState()) {
            return Message.build((boolean)false, (String)"\u7528\u6237\u5c1a\u672a\u767b\u5f55");
        }
        if (null != updateUser.getNickname()) {
            if (null == user.getIsTempNickName() || user.getIsTempNickName() == 1) {
                user.setNickname(updateUser.getNickname());
                user.setIsTempNickName(Byte.valueOf((byte)0));
            } else {
                return Message.build((boolean)false, (String)"\u8be5\u7528\u6237\u4fee\u6539\u6635\u79f0\u5df2\u8fbe\u4e0a\u9650");
            }
        }
        if (null != updateUser.getSex()) {
            user.setSex(updateUser.getSex());
            this.bizLogIntegrationService.changeGender(user.getId(), (int)updateUser.getSex().byteValue());
        }
        if (null != updateUser.getAddress()) {
            user.setAddress(updateUser.getAddress());
        }
        if (null != updateUser.getBirthday()) {
            user.setBirthday(updateUser.getBirthday());
        }
        String headImg = null;
        if (null != file) {
            if (file.getSize() > 0x500000L) {
                return Message.build((boolean)false, (String)"\u5934\u50cf\u56fe\u7247\u8fc7\u5927,\u8bf7\u91cd\u65b0\u4e0a\u4f20");
            }
            headImg = this.upLoadHeadImage(userId, file);
            if (null != headImg) {
                user.setHeadImg(this.upLoadHeadImage(userId, file));
                user.setIsTempHeadImg(Byte.valueOf((byte)0));
            }
        }
        if ((i = this.userMapper.updateByPrimaryKeySelective(user)) > 0) {
            UserInfoDTO dto = this.getUserToDTO(user);
            this.userSyncService.sync(user);
            this.checkCompleteInfo(dto);
            this.logger.debug("\u5b8c\u5584\u4e2a\u4eba\u8d44\u6599:[{}]", (Object)JSON.toJSONString((Object)dto));
            this.redisHashMapAdapter.put(RedisConfig.USER_INFO, userId + "", (Object)JSON.toJSONString((Object)dto));
            return Message.build((boolean)true).addParam("user", (Object)dto);
        }
        return Message.build((boolean)false, (String)"\u66f4\u65b0\u5931\u8d25");
    }

    private void checkCompleteInfo(UserInfoDTO user) {
        if (null != user.getWeixin() && null != user.getBirthday() && StringUtils.isNotEmpty((CharSequence)user.getAddress()) && StringUtils.isNotEmpty((CharSequence)user.getHeadImg()) && StringUtils.isNotEmpty((CharSequence)user.getNickname())) {
            this.logger.debug("\u7528\u6237\u4fe1\u606f:[{}]", (Object)JSON.toJSONString((Object)user));
            this.missionIntegrationService.completeTask(user.getId(), TaskEnum.TASK_IMPROVE_INFO, null);
        }
    }

    @Override
    public LocationUserInfoDTO getLocationUserInfo(Long userId) {
        return this.userMapper.getLocationUserInfo(userId);
    }

    @Override
    public String getDefaultHeadImgUrl() {
        return this.userProperties.getDefaultHeadImgUrl();
    }

    @Override
    public User selectByPrimaryKey(Long userId) {
        return this.userMapper.selectByPrimaryKey(userId);
    }

    @Override
    public Boolean checkUnionIdIsUser(String unionId) {
        UserAuth userAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)3), unionId);
        if (userAuth == null) {
            return false;
        }
        User user = this.userMapper.selectByPrimaryKey(userAuth.getUserId());
        if (user != null && user.getState() == 2) {
            return false;
        }
        return true;
    }

    @Override
    public User selectUserByUnionId(String unionId) {
        return this.userMapper.findByWeixin(unionId);
    }

    @Override
    public User selectUserByEquipment(String equipment) {
        return this.userMapper.findByEquipment(equipment);
    }

    @Override
    public Long checkExistEquipment(String equipment) {
        return this.userMapper.checkExistEquipment(equipment);
    }

    @Override
    public Boolean updateUserRecieveRedPacket(Long userId) {
        this.userMapper.updateUserReceiveRedPacket(userId);
        return Boolean.TRUE;
    }

    @Override
    public Boolean isRiskUser(Long userId) {
        User user = this.userMapper.selectByPrimaryKey(userId);
        return user.getRisk() == 1;
    }

    @Override
    public Boolean isTempUser(Long userId) {
        User user = this.userMapper.selectByPrimaryKey(userId);
        return 2 == user.getState();
    }

    @Override
    public Message createUser(TempUserParam userParam) {
        Message message = Message.build();
        if (null == userParam.getUnionId()) {
            return message;
        }
        this.logger.debug("\u5f00\u59cb\u521b\u5efa\u4e34\u65f6\u7528\u6237\uff1a{}", (Object)JSON.toJSONString((Object)userParam));
        User user = this.convertUser(userParam);
        UserAuth unionUserAuth = null;
        Long userId = null;
        Boolean isInsertInviteRecord = false;
        unionUserAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)3), userParam.getUnionId());
        if (null == unionUserAuth || null == unionUserAuth.getUserId()) {
            if (this.distributedLock.lock(userParam.getUnionId(), userParam.getUnionId(), 1L, TimeUnit.SECONDS)) {
                this.userMapper.insertSelective(user);
                this.userAccountService.createUserAccount(user.getId());
                this.userAuthService.addUserAuth((byte)3, user.getId(), userParam.getUnionId(), null);
                userId = user.getId();
                isInsertInviteRecord = true;
            }
        } else {
            userId = unionUserAuth.getUserId();
            User existedUser = this.userMapper.selectByUserId(userId.longValue());
            if (null != existedUser && existedUser.getState() == 2 && null == existedUser.getInviteUserId() && user.getInviteUserId() != null) {
                isInsertInviteRecord = true;
                user.setId(userId);
                user.setState(existedUser.getState());
                this.userMapper.updateByPrimaryKeySelective(user);
            }
        }
        if (null != userParam.getOpenId()) {
            if (InviteTypeEnum.APPLETDRAW.name().equals(userParam.getInviteType())) {
                UserAuth appletUserAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)7), userParam.getOpenId());
                if (null == appletUserAuth || null == appletUserAuth.getUserId()) {
                    this.userAuthService.addUserAuth((byte)7, userId, userParam.getOpenId(), null);
                }
            } else {
                UserAuth weixinUserAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)5), userParam.getOpenId());
                if (null == weixinUserAuth || null == weixinUserAuth.getUserId()) {
                    this.userAuthService.addUserAuth((byte)5, userId, userParam.getOpenId(), null);
                }
            }
        }
        if (userParam.getInviteUserId() != null && !userParam.getInviteUserId().equals(userId) && isInsertInviteRecord.booleanValue()) {
            this.inviteRecordService.addInviteRecord(userParam.getInviteUserId(), userId, userParam.getInviteType());
        }
        return message.addParam("userId", (Object)userId);
    }

    private User convertUser(TempUserParam tempUserParam) {
        User user = new User();
        user.setWeixin(tempUserParam.getUnionId());
        user.setNickname(tempUserParam.getNickName());
        user.setHeadImg(tempUserParam.getHeadImg());
        user.setSex(tempUserParam.getSex());
        user.setRegIp(tempUserParam.getRegIp());
        user.setRegisterClient(tempUserParam.getPlatform());
        user.setRegisteredAddress(tempUserParam.getRegisteredAddress());
        user.setInviteUserId(tempUserParam.getInviteUserId());
        User inviteUser = this.userMapper.selectByPrimaryKey(tempUserParam.getInviteUserId());
        if (inviteUser == null) {
            this.logger.info("\u53d7\u9080\u7528\u6237[{}]\u7684\u9080\u8bf7\u4eba\u4e0d\u5b58\u5728", (Object)user.getId());
            user.setInviteLevel(Integer.valueOf(1));
        } else {
            this.logger.info("\u521b\u5efa\u9080\u8bf7\u7528\u6237[{}]\u7684\u53d7\u9080\u7528\u6237", (Object)inviteUser.getId());
            user.setInviteLevel(Integer.valueOf(inviteUser.getInviteLevel() + 1));
        }
        user.setRegisterChannel(tempUserParam.getInviteType());
        user.setState(Byte.valueOf((byte)2));
        user.setLevel(LevelEunm.INITIAL_USER.getType());
        user.setIsNew(Byte.valueOf((byte)0));
        user.setExpiretime(this.getExpireTime());
        Date now = new Date();
        user.setLastLoginTime(now);
        user.setIsTempNickName(Byte.valueOf((byte)1));
        user.setIsTempHeadImg(Byte.valueOf((byte)1));
        return user;
    }

    private String upLoadHeadImage(Long userId, MultipartFile file) {
        int hashCode = (int)(userId % 10L);
        String url = this.aliyunOSSService.upload(file, "avatar/" + hashCode + "/");
        if (!StringUtils.containsAny((CharSequence)url, (CharSequence)"?")) {
            url = url + "?x-oss-process=style/head";
        }
        return url;
    }

    private boolean bindingCheckParam(LoginInfo loginInfo) {
        if (1 != loginInfo.getType() && 3 != loginInfo.getType() && 2 != loginInfo.getType() && 4 != loginInfo.getType()) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)loginInfo.getLoginName())) {
            return false;
        }
        if (1 == loginInfo.getType() && StringUtils.isEmpty((CharSequence)loginInfo.getCode())) {
            return false;
        }
        return 3 != loginInfo.getType() || !StringUtils.isEmpty((CharSequence)loginInfo.getHeadImg()) || !StringUtils.isEmpty((CharSequence)loginInfo.getNickname());
    }

    @Override
    public LocationDTO doPostingLocation(String code, Long userId) {
        User user;
        if (StringUtils.isEmpty((CharSequence)code)) {
            this.logger.error("\u5b9a\u4f4d\u65f6\u65e0\u6cd5\u63d0\u4f9b\u5730\u533a\u7f16\u7801(\u5b9a\u4f4d\u5931\u8d25)!!!:code:{},userId:{}", (Object)code, (Object)userId);
        }
        if (StringUtils.isNotEmpty((CharSequence)code) && code.length() != 6 && code.length() != 12 || null == userId) {
            this.logger.error("\u53c2\u6570\u9519\u8bef(\u5730\u533a\u7f16\u7801\u4f4d\u6570\u95ee\u9898\u6216\u7528\u6237id\u4e3a\u7a7a):code:{},userId:{}", (Object)code, (Object)userId);
        }
        if (null == code) {
            code = this.bizConfigProperties.getLocationCode();
        }
        LocationDTO locationDTO = this.locationIntegrationService.getLocationByGeocode(code);
        if (null != userId && null != (user = this.userMapper.selectByPrimaryKey(userId))) {
            user.setLocationCode(locationDTO.getCode());
            user.setLocationName(locationDTO.getName());
            int i = this.userMapper.updateByPrimaryKeySelective(user);
            if (i > 0) {
                this.bizLogIntegrationService.changeArea(userId, code);
                UserInfoDTO dto = this.getUserToDTO(user);
                this.redisHashMapAdapter.put(RedisConfig.USER_INFO, userId + "", (Object)JSON.toJSONString((Object)dto));
                UserLocationHistory userLocationHistory = new UserLocationHistory();
                userLocationHistory.setAddTime(new Date());
                userLocationHistory.setId(this.nextSequence());
                userLocationHistory.setLocationCode(locationDTO.getCode());
                userLocationHistory.setUserId(userId);
                this.userLocationHistoryMapper.insert(userLocationHistory);
            }
        }
        return locationDTO;
    }

    @Override
    public void savePush(PushParam pushParam) {
        User user;
        User userForPush = this.userMapper.findByPushToken(pushParam.getPushToken());
        if (null != userForPush) {
            this.userMapper.clearPushInfo(userForPush.getId().longValue());
        }
        if (null != (user = this.userMapper.selectByUserId(pushParam.getUserId().longValue()))) {
            PushInfo pushInfo = new PushInfo();
            BeanUtils.copyProperties((Object)pushParam, (Object)pushInfo);
            this.userMapper.savePushInfo(pushInfo);
        }
    }
}

