/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.account.impl;

import com.bxm.localnews.user.account.UserAccountService;
import com.bxm.localnews.user.account.impl.callback.DefaultAccountActionCallback;
import com.bxm.localnews.user.account.impl.callback.IAccountActionCallback;
import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import com.bxm.localnews.user.account.impl.handler.DefaultAccountActionHandler;
import com.bxm.localnews.user.account.impl.handler.IAccountActionHandler;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.exception.UserAccountException;
import com.bxm.localnews.user.param.AccountActionParam;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.RetryException;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
@Transactional(rollbackFor={Exception.class})
public class AccountHandlerProxy {
    private static final Logger log = LoggerFactory.getLogger(AccountHandlerProxy.class);
    private UserAccountService userAccountService;
    private Map<AccountActionEnum, IAccountActionHandler> handlerMap;
    private IAccountActionHandler defaultHandler = new DefaultAccountActionHandler();

    public UserAccountService getUserAccountService() {
        if (this.userAccountService == null) {
            this.userAccountService = (UserAccountService)SpringContextHolder.getBean(UserAccountService.class);
        }
        return this.userAccountService;
    }

    @Autowired
    public AccountHandlerProxy(List<IAccountActionHandler> handlerList) {
        this.handlerMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(handlerList)) {
            handlerList.forEach(handler -> this.handlerMap.put(handler.support(), (IAccountActionHandler)handler));
        }
    }

    @Retryable(value={RetryException.class})
    public void handle(AccountActionParam param) {
        this.handler(param, null);
    }

    @Retryable(value={RetryException.class})
    public void handler(AccountActionParam param, IAccountActionCallback callback) {
        log.debug("\u8fdb\u884c\u8d26\u53f7\u64cd\u4f5c\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)param);
        AccountActionContext context = new AccountActionContext(param);
        if (null == callback) {
            callback = new DefaultAccountActionCallback();
        }
        context.setCallback(callback);
        context.setAccount(this.getUserAccountService().getUserAccountDetail(context.getUserId()));
        try {
            IAccountActionHandler handler = this.handlerMap.getOrDefault(context.getAction(), this.defaultHandler);
            log.debug("\u8d26\u53f7\u64cd\u4f5c\u7684Handler\uff1a{}", (Object)handler.getClass().getSimpleName());
            handler.handle(context);
        }
        catch (UserAccountException e) {
            log.warn("\u5904\u7406\u8d26\u53f7\u53d1\u751f\u4e1a\u52a1\u5f02\u5e38\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}:\u662f\u5426\u91cd\u8bd5\uff1a{}", new Object[]{context, e.getMessage(), e.isRetryable()});
            if (e.isRetryable()) {
                callback.preRetry(context);
                throw new RetryException(e.getMessage(), (Throwable)e);
            }
            callback.exception(context);
            throw e;
        }
        catch (Exception e) {
            callback.exception(context);
            log.error("\u8d26\u53f7\u5904\u7406\u53d1\u751f\u672a\u9884\u671f\u7684\u9519\u8bef,\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)context);
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        log.debug("\u8d26\u53f7\u64cd\u4f5c\u5904\u7406\u5b8c\u6210\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)param);
    }
}

