/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.account.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.user.account.AccountService;
import com.bxm.localnews.user.account.UserAccountService;
import com.bxm.localnews.user.domain.PointOrderMapper;
import com.bxm.localnews.user.domain.UserAccountMapper;
import com.bxm.localnews.user.enums.DeductPointStatusEnum;
import com.bxm.localnews.user.enums.GoldEnum;
import com.bxm.localnews.user.enums.GoldFlowTypeEnum;
import com.bxm.localnews.user.param.AccountGoldParam;
import com.bxm.localnews.user.param.DeductPointParam;
import com.bxm.localnews.user.param.StoreNeceParam;
import com.bxm.localnews.user.vo.PointOrder;
import com.bxm.localnews.user.vo.UserAccount;
import java.math.BigDecimal;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AccountServiceImpl
implements AccountService {
    private static final Logger log = LoggerFactory.getLogger(AccountServiceImpl.class);
    @Resource
    private UserAccountMapper userAccountMapper;
    @Resource
    private PointOrderMapper pointOrderMapper;
    @Resource
    private UserAccountService userAccountService;

    @Override
    public BigDecimal selectGoldByUserId(StoreNeceParam storeNeceParam) {
        return this.selectUsableGoldByUserId(Long.valueOf(storeNeceParam.getAppUid()));
    }

    @Override
    public Boolean deductUserGold(DeductPointParam deductPointParam) {
        BigDecimal deductPoint;
        PointOrder pointOrder = this.addPointOrder(deductPointParam);
        BigDecimal userBalance = this.selectUsableGoldByUserId(Long.valueOf(deductPointParam.getAppUid()));
        if (userBalance.compareTo(deductPoint = new BigDecimal(deductPointParam.getPoint().longValue())) < 0) {
            return Boolean.FALSE;
        }
        log.debug("\u6263\u9664\u91d1\u5e01\u4f20\u5165\u7684\u53c2\u6570:[{}]", (Object)JSON.toJSONString((Object)deductPointParam));
        AccountGoldParam param = new AccountGoldParam(Long.valueOf(deductPointParam.getAppUid()), GoldEnum.CONSUME_GOLD.name(), Boolean.valueOf(false), Integer.valueOf(Math.abs(deductPoint.intValue())), pointOrder.getId(), GoldFlowTypeEnum.EXCHANGE_GOODS.getName());
        this.userAccountService.addGold(param);
        return true;
    }

    @Override
    public void deductConfirmUserGold(DeductPointParam deductPointParam) {
        PointOrder pointOrder = this.pointOrderMapper.getPointOrder(Long.valueOf(deductPointParam.getAppUid()), deductPointParam.getOrderNum());
        if (pointOrder != null) {
            String status = DeductPointStatusEnum.getStatusByStatus((String)deductPointParam.getStatus());
            if (DeductPointStatusEnum.FAIL.getStatus().equals(status)) {
                log.info("\u7528\u6237[{}]\u79ef\u5206\u5546\u57ce\u91d1\u5e01\u9000\u56de.......", (Object)deductPointParam.getAppUid());
                BigDecimal returnGold = new BigDecimal("-" + pointOrder.getDeductBalance());
                AccountGoldParam param = new AccountGoldParam(Long.valueOf(deductPointParam.getAppUid()), GoldEnum.USABLE_GOLD.name(), Boolean.valueOf(false), Integer.valueOf(returnGold.intValue()), pointOrder.getId(), GoldFlowTypeEnum.STORE_ADD_BALANCE.getName());
                this.userAccountService.addGold(param);
            }
            pointOrder.setUpdateTime(new Date());
            pointOrder.setStatus(deductPointParam.getStatus());
            this.pointOrderMapper.updateByPrimaryKeySelective(pointOrder);
        }
    }

    @Override
    public void addUserGold(DeductPointParam deductPointParam) {
        PointOrder pointOrder = this.addPointOrder(deductPointParam);
        BigDecimal addPoint = new BigDecimal(deductPointParam.getPoint().longValue());
        AccountGoldParam param = new AccountGoldParam(Long.valueOf(deductPointParam.getAppUid()), GoldEnum.USABLE_GOLD.name(), Boolean.valueOf(true), Integer.valueOf(addPoint.intValue()), pointOrder.getId(), GoldFlowTypeEnum.STORE_ADD_BALANCE.getName());
        this.userAccountService.addGold(param);
    }

    @Override
    public BigDecimal selectUsableGoldByUserId(Long userId) {
        UserAccount userAccount = this.userAccountMapper.getUserAccount(userId);
        if (null != userAccount) {
            BigDecimal usableGold = BigDecimal.valueOf(userAccount.getUsableGold().intValue());
            if (usableGold != null && usableGold.compareTo(BigDecimal.ZERO) > 0) {
                return usableGold;
            }
            return BigDecimal.ZERO;
        }
        return BigDecimal.ZERO;
    }

    private PointOrder addPointOrder(DeductPointParam deductPointParam) {
        PointOrder pointOrder = new PointOrder();
        pointOrder.setBxmOrderNo(deductPointParam.getOrderNum());
        pointOrder.setOrderNo(deductPointParam.getAppOrderNum());
        pointOrder.setUserId(Long.valueOf(deductPointParam.getAppUid()));
        pointOrder.setDeductBalance(Long.valueOf(deductPointParam.getPoint().longValue()));
        pointOrder.setDescription(deductPointParam.getDescription());
        pointOrder.setStatus(deductPointParam.getStatus());
        pointOrder.setCreateTime(new Date());
        this.pointOrderMapper.insertSelective(pointOrder);
        return pointOrder;
    }
}

