/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.account.impl;

import com.bxm.localnews.user.account.CashFlowService;
import com.bxm.localnews.user.account.UserWithdrawService;
import com.bxm.localnews.user.constant.CashFlowClassifyEnum;
import com.bxm.localnews.user.domain.CashFlowMapper;
import com.bxm.localnews.user.dto.AccountCashFlowDTO;
import com.bxm.localnews.user.dto.AccountIncomeTypeDTO;
import com.bxm.localnews.user.dto.CashFlowDTO;
import com.bxm.localnews.user.dto.UserDayCashDTO;
import com.bxm.localnews.user.enums.CashFlowTypeEnum;
import com.bxm.localnews.user.enums.WithdrawEnum;
import com.bxm.localnews.user.param.AccountCashFlowPageParam;
import com.bxm.localnews.user.param.CashFlowParam;
import com.bxm.localnews.user.vo.CashFlow;
import com.bxm.localnews.user.vo.WithdrawFlow;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CashFlowServiceImpl
extends BaseService
implements CashFlowService {
    private static final Logger log = LoggerFactory.getLogger(CashFlowServiceImpl.class);
    @Resource
    private CashFlowMapper cashFlowMapper;
    @Resource
    private UserWithdrawService userWithdrawService;
    @Resource
    private SequenceCreater sequenceCreater;
    private List<AccountIncomeTypeDTO> typeCache;

    @Override
    public List<UserDayCashDTO> getRecentSevenDayCashFlowByUser(Long userId) {
        return this.cashFlowMapper.querySevenDayCashFlows(userId);
    }

    @Override
    public List<CashFlowDTO> getUserAllCashFlow(CashFlowParam cashFlowParam) {
        if (com.bxm.newidea.component.tools.StringUtils.isNotEmpty((CharSequence)cashFlowParam.getDate())) {
            Date date = DateUtils.parse((String)cashFlowParam.getDate());
            Date endDate = DateUtils.addField((Date)date, (int)5, (int)1);
            cashFlowParam.setEndDate(DateUtils.formatAtWill((Date)endDate, (String)"yyyy-MM-dd"));
            cashFlowParam.setType("income");
        } else {
            cashFlowParam.setType(null);
        }
        List cashFlowList = this.cashFlowMapper.queryCashFlows(cashFlowParam);
        return this.generateCashFlowDTO(cashFlowList);
    }

    private List<CashFlowDTO> generateCashFlowDTO(List<CashFlow> cashFlows) {
        if (CollectionUtils.isEmpty(cashFlows)) {
            return new ArrayList<CashFlowDTO>();
        }
        return cashFlows.stream().map(this::convertCashFlow).collect(Collectors.toList());
    }

    private CashFlowDTO convertCashFlow(CashFlow cashFlow) {
        String amount;
        CashFlowDTO cashFlowDTO = new CashFlowDTO();
        cashFlow.setAmount(cashFlow.getAmount().setScale(2, 4));
        if (cashFlow.getAmount().compareTo(BigDecimal.ZERO) > 0) {
            amount = "+" + cashFlow.getAmount();
            cashFlowDTO.setPlus(Boolean.TRUE);
        } else {
            amount = cashFlow.getAmount().toString();
            cashFlowDTO.setPlus(Boolean.FALSE);
        }
        cashFlowDTO.setAmount(amount);
        cashFlowDTO.setCreateTime(cashFlow.getCreateTime());
        CashFlowTypeEnum cashFlowTypeEnum = CashFlowTypeEnum.valueOf((String)cashFlow.getType());
        cashFlowDTO.setTypeDesc(cashFlowTypeEnum.getDesc());
        if ((Objects.equals(CashFlowTypeEnum.WECHAT_WITHDRAWAL, cashFlowTypeEnum) || Objects.equals(CashFlowTypeEnum.ALIPAY_WITHDRAWAL, cashFlowTypeEnum)) && cashFlow.getRelationId() != null) {
            WithdrawFlow withdrawFlow = this.userWithdrawService.getWithdrawFlowById(cashFlow.getRelationId());
            if (WithdrawEnum.SUCCESS_PAYMENT.getState().equals(withdrawFlow.getState())) {
                cashFlowDTO.setTypeDesc(StringUtils.join((Object[])new String[]{cashFlowTypeEnum.getDesc(), "--\u5df2\u6210\u529f"}));
            }
            if (WithdrawEnum.AUDIT.getState().equals(withdrawFlow.getState()) || WithdrawEnum.DELAY_AUDIT.getState().equals(withdrawFlow.getState())) {
                cashFlowDTO.setTypeDesc(StringUtils.join((Object[])new String[]{cashFlowTypeEnum.getDesc(), "--\u5ba1\u6838\u4e2d"}));
            }
            if (WithdrawEnum.FAIL_PAYMENT.getState().equals(withdrawFlow.getState())) {
                cashFlowDTO.setTypeDesc(StringUtils.join((Object[])new String[]{cashFlowTypeEnum.getDesc(), "-\u2013\u5931\u8d25\u5df2\u9000\u56de"}));
            }
        }
        return cashFlowDTO;
    }

    @Override
    public int addCashFlow(CashFlow cashFlow) {
        this.logger.debug("\u65b0\u589e\u6d41\u6c34\uff1a{}", (Object)cashFlow);
        if (null == cashFlow.getId()) {
            cashFlow.setId(this.sequenceCreater.nextLongId());
        }
        if (null == cashFlow.getCreateTime()) {
            cashFlow.setCreateTime(new Date());
        }
        return this.cashFlowMapper.addCashFlow(cashFlow);
    }

    @Override
    public BigDecimal getMySelfBounty(Long userId) {
        BigDecimal myBounty = this.cashFlowMapper.getMySelfBounty(userId);
        return myBounty == null ? BigDecimal.ZERO : myBounty;
    }

    @Override
    public BigDecimal getMyRedPacket(Long userId) {
        BigDecimal myRedPacket = this.cashFlowMapper.getMyRedPacket(userId);
        return myRedPacket == null ? BigDecimal.ZERO : myRedPacket;
    }

    @Override
    public boolean enableWithdraw(Long userId) {
        CashFlowParam cashFlowParam = new CashFlowParam();
        cashFlowParam.setUserId(userId);
        List cashFlowList = this.cashFlowMapper.queryCashFlows(cashFlowParam);
        if (CollectionUtils.isEmpty((Collection)cashFlowList)) {
            log.info("\u672a\u9886\u53d6\u8fc7\u65b0\u7528\u6237\u8d4f\u91d1\uff0c\u7528\u6237id\uff1a" + userId);
            return false;
        }
        return true;
    }

    @Override
    public PageWarper<AccountCashFlowDTO> queryCashByPage(AccountCashFlowPageParam param) {
        Preconditions.checkArgument((null != param ? 1 : 0) != 0);
        CashFlowClassifyEnum classify = CashFlowClassifyEnum.of(param.getCashFlowCode());
        if (classify == null) {
            classify = CashFlowClassifyEnum.ALL;
        }
        if (null != classify.getInclude()) {
            param.setIncludeTypeList(Stream.of(classify.getInclude()).map(Enum::name).collect(Collectors.toList()));
        }
        if (null != classify.getExclude()) {
            param.setExcludeTypeList(Stream.of(classify.getExclude()).map(Enum::name).collect(Collectors.toList()));
        }
        List cashFlows = this.cashFlowMapper.queryCashFlowByPage(param);
        List result = cashFlows.stream().map(this::convert).collect(Collectors.toList());
        PageWarper warper = new PageWarper(cashFlows);
        warper.setList(result);
        return warper;
    }

    private AccountCashFlowDTO convert(CashFlow cashFlow) {
        AccountCashFlowDTO cashFlowResult = AccountCashFlowDTO.builder().id(cashFlow.getId()).amount(cashFlow.getAmount()).createTime(cashFlow.getCreateTime()).remark(cashFlow.getRemark()).plus(Boolean.valueOf(cashFlow.getAmount().floatValue() > 0.0f)).build();
        if (com.bxm.newidea.component.tools.StringUtils.isBlank((CharSequence)cashFlowResult.getRemark()) && com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)cashFlow.getType())) {
            CashFlowTypeEnum type = CashFlowTypeEnum.get((String)cashFlow.getType());
            cashFlowResult.setRemark(type.getDesc());
        }
        return cashFlowResult;
    }
}

