/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.account.impl;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.user.account.GoldFlowService;
import com.bxm.localnews.user.domain.GoldFlowMapper;
import com.bxm.localnews.user.param.GoldFlowParam;
import com.bxm.localnews.user.vo.FlowDetail;
import com.bxm.localnews.user.vo.GoldFlow;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class GoldFlowServiceImpl
implements GoldFlowService {
    @Resource
    private GoldFlowMapper goldFlowMapper;
    @Resource
    private SequenceCreater sequenceCreater;

    @Override
    public int addGoldFlow(GoldFlow goldFlow) {
        if (goldFlow.getId() == null) {
            goldFlow.setId(this.sequenceCreater.nextLongId());
        }
        if (goldFlow.getCreateTime() == null) {
            goldFlow.setCreateTime(new Date());
        }
        return this.goldFlowMapper.addGoldFlow(goldFlow);
    }

    @Override
    public void addGoldFlow(List<GoldFlow> goldFlowList) {
        MybatisBatchBuilder.create(GoldFlowMapper.class, goldFlowList).run(GoldFlowMapper::addGoldFlow);
    }

    @Override
    public List<GoldFlow> getUserGoldFlow(GoldFlowParam goldFlowParam) {
        return this.goldFlowMapper.queryGoldFlows(goldFlowParam);
    }

    @Override
    public BigDecimal getYesterdayGold(Long userId) {
        return this.goldFlowMapper.getYesterdayGold(userId);
    }

    @Override
    public List<FlowDetail> listGoldFlow(Long userId) {
        return this.goldFlowMapper.listGoldFlow(userId);
    }

    @Override
    public Integer countGoldByPostId(Long postId, Long userId) {
        return this.goldFlowMapper.countGoldByPostId(postId, userId);
    }
}

