/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.account.impl.handler;

import com.bxm.localnews.user.account.UserAccountService;
import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import com.bxm.localnews.user.account.impl.handler.IAccountActionHandler;
import com.bxm.localnews.user.account.impl.rule.IRule;
import com.bxm.localnews.user.domain.UserAccountMapper;
import com.bxm.localnews.user.exception.UserAccountException;
import com.bxm.localnews.user.vo.UserAccount;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractAccountActionHandler
implements IAccountActionHandler {
    private Map<Class<? extends IRule>, IRule> ruleMap;
    @Autowired
    protected UserAccountMapper userAccountMapper;
    protected UserAccountService userAccountService;

    @Autowired
    public void setRules(List<IRule> rules) {
        if (CollectionUtils.isNotEmpty(rules)) {
            this.ruleMap = Maps.newHashMap();
            rules.forEach(rule -> this.ruleMap.put((Class<? extends IRule>)rule.getClass(), (IRule)rule));
        }
    }

    @Override
    public final void handle(AccountActionContext context) {
        if (null == this.userAccountService) {
            this.userAccountService = (UserAccountService)SpringContextHolder.getBean(UserAccountService.class);
        }
        this.preAction(context);
        this.postAction(context);
    }

    private void preAction(AccountActionContext context) {
        List<Class<? extends IRule>> bindRules = this.bindRules();
        if (bindRules != null) {
            for (Class<? extends IRule> ruleClass : bindRules) {
                IRule rule = this.ruleMap.get(ruleClass);
                if (rule.apply(context)) continue;
                throw new UserAccountException(ruleClass.getSimpleName() + "\u9a8c\u8bc1\u5931\u8d25", rule.retryOnFailed());
            }
        }
        context.getCallback().preAction(context);
    }

    private void postAction(AccountActionContext context) {
        this.execAction(context, context.getAccount(), context.getCloneAccount());
        this.saveFlow(context);
        this.syncAccount(context);
        context.getCallback().postAction(context);
        this.afterPost(context);
        this.userAccountService.cleanCache(context.getUserId());
    }

    protected void afterPost(AccountActionContext context) {
    }

    protected abstract void saveFlow(AccountActionContext var1);

    protected abstract void execAction(AccountActionContext var1, UserAccount var2, UserAccount var3);

    private void syncAccount(AccountActionContext context) {
        int result = this.userAccountMapper.updateUserAccountWithVersion(context.getCloneAccount());
        if (result <= 0) {
            throw new UserAccountException("version\u4e0e\u6570\u636e\u5e93\u4e2d\u7684\u4e0d\u4e00\u81f4\uff0c\u8fdb\u884c\u91cd\u8bd5", true);
        }
    }
}

