/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.account.impl.handler.cash;

import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import com.bxm.localnews.user.account.impl.handler.cash.AbstractCashAccountActionHandler;
import com.bxm.localnews.user.account.impl.rule.IRule;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.enums.CashFlowTypeEnum;
import com.bxm.localnews.user.vo.UserAccount;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class AddDrawableCashAccountActionHandler
extends AbstractCashAccountActionHandler {
    @Override
    protected void execAction(AccountActionContext context, UserAccount source, UserAccount storage) {
        storage.setDrawableCash(this.add(source.getDrawableCash(), context.getAmount()));
        storage.setTotalCash(this.add(source.getTotalCash(), context.getAmount()));
        storage.setSettledCash(this.add(source.getSettledCash(), context.getAmount()));
        if (CashFlowTypeEnum.INVITE_VIP.equals((Object)context.getOriginParam().getCashFlowType())) {
            storage.setInviteVipCash(this.add(source.getInviteVipCash(), context.getAmount()));
        } else {
            storage.setOtherCash(this.add(source.getOtherCash(), context.getAmount()));
        }
    }

    @Override
    public AccountActionEnum support() {
        return AccountActionEnum.ADD_DRAWABLE_CASH;
    }

    @Override
    public List<Class<? extends IRule>> bindRules() {
        return null;
    }
}

