/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.account.impl.handler.cash;

import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import com.bxm.localnews.user.account.impl.handler.cash.AbstractCashAccountActionHandler;
import com.bxm.localnews.user.account.impl.rule.IRule;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.support.UserRankService;
import com.bxm.localnews.user.vo.UserAccount;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class AddSaveCashAccountActionHandler
extends AbstractCashAccountActionHandler {
    @Resource
    private RedisSetAdapter redisSetAdapter;
    @Resource
    private UserRankService userRankService;

    @Override
    protected void execAction(AccountActionContext context, UserAccount source, UserAccount storage) {
        storage.setSaveCash(this.add(source.getSaveCash(), context.getAmount()));
    }

    @Override
    public AccountActionEnum support() {
        return AccountActionEnum.ADD_SAVE_CASH;
    }

    @Override
    public List<Class<? extends IRule>> bindRules() {
        return null;
    }

    @Override
    protected void afterPost(AccountActionContext context) {
        super.afterPost(context);
        this.redisSetAdapter.add(RedisConfig.HAS_NEW_SAVE_CASH_EVENT_CACHE, new Object[]{context.getUserId()});
        this.userRankService.reloadUserSaveCashRank(context.getUserId());
    }

    @Override
    public boolean isConvertHandler() {
        return true;
    }
}

