/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.account.impl.handler.gold;

import com.bxm.localnews.user.account.GoldFlowService;
import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import com.bxm.localnews.user.account.impl.handler.AbstractAccountActionHandler;
import com.bxm.localnews.user.vo.GoldFlow;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractGoldAccountActionHandler
extends AbstractAccountActionHandler {
    @Autowired
    protected GoldFlowService goldFlowService;

    @Override
    protected void saveFlow(AccountActionContext context) {
        GoldFlow goldFlow = this.buildGoldFlow(context);
        this.saveGoldFlow(context, goldFlow);
    }

    private GoldFlow buildGoldFlow(AccountActionContext context) {
        GoldFlow goldFlow = new GoldFlow();
        if (this.isConsume()) {
            goldFlow.setAmount(Integer.valueOf(Math.negateExact(context.getGoldNum())));
        } else {
            goldFlow.setAmount(context.getGoldNum());
        }
        goldFlow.setUserId(context.getUserId());
        goldFlow.setContent(context.getOriginParam().getContent());
        goldFlow.setRemark(context.getOriginParam().getRemark());
        goldFlow.setReason(context.getOriginParam().getReason());
        if (null != context.getOriginParam().getGoldFlowType()) {
            goldFlow.setType(context.getOriginParam().getGoldFlowType().getName());
            if (StringUtils.isBlank((CharSequence)goldFlow.getContent())) {
                goldFlow.setContent(context.getOriginParam().getGoldFlowType().getDesc());
            }
        }
        goldFlow.setRelationId(context.getOriginParam().getRelationId());
        return goldFlow;
    }

    private void saveGoldFlow(AccountActionContext context, GoldFlow goldFlow) {
        this.goldFlowService.addGoldFlow(goldFlow);
        context.putGoldFlow(goldFlow.getUserId(), goldFlow);
    }

    boolean isConsume() {
        return false;
    }
}

