/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.attribute.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.user.attribute.DeprecatedService;
import com.bxm.localnews.user.attribute.UserPersonalInfoService;
import com.bxm.localnews.user.attribute.UserTagService;
import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.integration.BizLogIntegrationService;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.param.UserParam;
import com.bxm.localnews.user.param.UserSyncParam;
import com.bxm.localnews.user.properties.HomePageConfigProperties;
import com.bxm.localnews.user.support.UserSyncService;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserInfoComplete;
import com.bxm.newidea.component.emoji.EmojiCodeParser;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.tools.Validater;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageParam;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DeprecatedServiceImpl
extends BaseService
implements DeprecatedService {
    @Resource
    private UserMapper userMapper;
    @Resource
    private BizLogIntegrationService bizLogIntegrationService;
    @Resource
    private UserSyncService userSyncService;
    @Resource
    private UserService userService;
    @Resource
    private HomePageConfigProperties homePageConfigProperties;
    @Resource
    private UserTagService userTagService;

    @Override
    public Message updateUserInfo(UserParam updateUser, Long userId, MultipartFile file) {
        int i;
        User user = this.userMapper.selectByPrimaryKey(userId);
        if (null == user) {
            this.logger.error("\u7528\u6237\u66f4\u65b0\u8d44\u6599\u65f6\u672a\u5f97\u5230\u7528\u6237:[{}]", (Object)JSONObject.toJSONString((Object)updateUser));
            return Message.build((boolean)false, (String)"\u66f4\u65b0\u5931\u8d25");
        }
        if (1 != user.getState()) {
            return Message.build((boolean)false, (String)"\u7528\u6237\u5c1a\u672a\u767b\u5f55");
        }
        if (null != updateUser.getNickname()) {
            user.setNickname(EmojiCodeParser.replaceSoftbankEmoji((String)updateUser.getNickname()));
        }
        if (null != updateUser.getPhone()) {
            if (!Validater.checkPhone((String)updateUser.getPhone())) {
                return Message.build((boolean)false, (String)"\u624b\u673a\u53f7\u683c\u5f0f\u6709\u8bef");
            }
            if (!updateUser.getPhone().equals(user.getPhone()) && this.userService.checkUserExistByPhone(updateUser.getPhone(), 0)) {
                return Message.build((boolean)false, (String)"\u8be5\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a");
            }
            user.setPhone(updateUser.getPhone());
        }
        if (null != updateUser.getSex()) {
            user.setSex(updateUser.getSex());
            this.bizLogIntegrationService.changeGender(user.getId(), (int)updateUser.getSex().byteValue(), null);
        }
        if (null != updateUser.getAddress()) {
            user.setAddress(updateUser.getAddress());
        }
        if (null != updateUser.getBirthday()) {
            user.setBirthday(updateUser.getBirthday());
        }
        if (StringUtils.isNotEmpty((CharSequence)updateUser.getHeadImg())) {
            user.setHeadImg(updateUser.getHeadImg());
        }
        if (StringUtils.isNotBlank((CharSequence)updateUser.getPersonalProfile())) {
            if (!this.homePageConfigProperties.getIsUpdatePersonalProfile().booleanValue()) {
                return Message.build((boolean)false, (String)"\u7cfb\u7edf\u7ef4\u62a4\u4e2d\uff0c\u6682\u65f6\u4e0d\u652f\u6301\u4fee\u6539");
            }
            user.setPersonalProfile(updateUser.getPersonalProfile());
        }
        if ((i = this.userMapper.updateByPrimaryKeySelective(user)) > 0) {
            UserInfoDTO dto = this.userService.convertUserToDTO(user);
            this.logger.info("\u7528\u6237\u66f4\u65b0\u540e\u7684\u4fe1\u606f\uff1a[{}]", (Object)JSON.toJSONString((Object)dto));
            if (null != updateUser.getNickname() || null != updateUser.getHeadImg() || null != updateUser.getSex()) {
                UserSyncParam userSyncParam = new UserSyncParam();
                BeanUtils.copyProperties((Object)dto, (Object)userSyncParam);
                this.userSyncService.sync(userSyncParam);
            }
            this.userService.checkCompleteInfo(user);
            this.userService.loadUserToRedis(user.getId());
            return Message.build((boolean)true).addParam("user", (Object)dto);
        }
        return Message.build((boolean)false, (String)"\u66f4\u65b0\u5931\u8d25");
    }

    @Override
    public void updateUserCompleteInfo() {
        double count = Math.ceil(this.userMapper.count() / 500.0);
        int i = 1;
        while ((double)i <= count) {
            PageParam pageParam = new PageParam();
            pageParam.setPageNum(Integer.valueOf(i));
            pageParam.setPageSize(Integer.valueOf(500));
            List userList = this.userMapper.queryPageByNormal(pageParam);
            ArrayList<UserInfoComplete> userInfoCompleteList = new ArrayList<UserInfoComplete>();
            for (User user : userList) {
                long infoCompleteStatus = ((UserPersonalInfoService)SpringContextHolder.getBean(UserPersonalInfoService.class)).initUserInfoCompleteStatus(user);
                userInfoCompleteList.add(new UserInfoComplete(user.getId(), Long.valueOf(infoCompleteStatus)));
            }
            MybatisBatchBuilder.create(UserMapper.class, userInfoCompleteList).run(UserMapper::updateUserInfoCompleteStatus);
            ++i;
        }
    }
}

