/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.attribute.impl;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.mq.common.constant.PlatformTypeEnum;
import com.bxm.localnews.mq.common.model.dto.UserTokenParam;
import com.bxm.localnews.msg.facade.UserTokenFacadeService;
import com.bxm.localnews.user.attribute.UserAttributeService;
import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.integration.UserNewsIntegrationService;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.param.PushParam;
import com.bxm.localnews.user.vo.UserLikeVo;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserAttributeServiceImpl
implements UserAttributeService {
    private static final Logger log = LoggerFactory.getLogger(UserAttributeServiceImpl.class);
    private final UserMapper userMapper;
    private final UserNewsIntegrationService userNewsIntegrationService;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final UserService userService;
    private final UserTokenFacadeService userTokenFacadeService;

    @Autowired
    public UserAttributeServiceImpl(UserMapper userMapper, UserNewsIntegrationService userNewsIntegrationService, RedisHashMapAdapter redisHashMapAdapter, UserService userService, UserTokenFacadeService userTokenFacadeService) {
        this.userMapper = userMapper;
        this.userNewsIntegrationService = userNewsIntegrationService;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.userService = userService;
        this.userTokenFacadeService = userTokenFacadeService;
    }

    @Override
    public Boolean updateUserLikeNumByUserId(Long userId) {
        int update = this.userMapper.updateLikeNumByUserId(userId);
        this.userService.loadUserToRedis(userId);
        return update > 0;
    }

    @Override
    public Boolean updateUserLikeNum(Long userId) {
        log.debug("\u5f00\u59cb\u540c\u6b65\u7528\u6237\u70b9\u8d5e\u6570:userId:{}", (Object)userId);
        List userids = this.userMapper.selectUserGreaterThanUserId(userId);
        if (!CollectionUtils.isEmpty((Collection)userids)) {
            List userLikeVos = this.userNewsIntegrationService.getLikeNumByUserIds(userids);
            this.updateUserLike(userLikeVos);
            Optional maxUserId = userids.stream().max(Long::compareTo);
            if (maxUserId.isPresent()) {
                return this.updateUserLikeNum((Long)maxUserId.get());
            }
        }
        this.userService.removeUserCache(userId);
        return true;
    }

    private void updateUserLike(List<UserLikeVo> userLikeVos) {
        if (!CollectionUtils.isEmpty(userLikeVos)) {
            MybatisBatchBuilder.create(UserMapper.class, userLikeVos).run(UserMapper::updateUserLikeNumByUserId);
        }
    }

    @Override
    public void addUserFollowCount(Long userId, Long targetUserId, boolean isAdd) {
        int addCount = isAdd ? 1 : -1;
        this.userMapper.addAttentionNum(userId, Integer.valueOf(addCount));
        this.userMapper.addFanNum(targetUserId, Integer.valueOf(addCount));
        this.userService.loadUserToRedis(userId);
        this.userService.loadUserToRedis(targetUserId);
    }

    @Override
    public Boolean updateUserReceiveRedPacket(Long userId) {
        this.userMapper.updateUserReceiveRedPacket(userId);
        return Boolean.TRUE;
    }

    @Override
    public Boolean addPostReplyNum(Long userId, Integer type) {
        if (1 == type) {
            this.userMapper.addPostNum(userId);
        } else if (2 == type) {
            this.userMapper.minusPostNum(userId);
        } else if (3 == type) {
            this.userMapper.addReplyNum(userId);
        } else if (4 == type) {
            this.userMapper.minusReplyNum(userId);
        }
        this.userService.loadUserToRedis(userId);
        return true;
    }

    @Override
    public void savePush(PushParam pushParam) {
        UserTokenParam param = new UserTokenParam();
        param.setToken(pushParam.getPushToken());
        for (PlatformTypeEnum platformTypeEnum : PlatformTypeEnum.values()) {
            if (!platformTypeEnum.name().equalsIgnoreCase(pushParam.getPushPlatform())) continue;
            param.setTokenType(platformTypeEnum);
        }
        for (PlatformTypeEnum platformTypeEnum : PlatformEnum.values()) {
            if (!Objects.equals(platformTypeEnum.getCode(), pushParam.getPlatform())) continue;
            param.setPlatform((PlatformEnum)platformTypeEnum);
        }
        param.setUserId(pushParam.getUserId());
        this.userTokenFacadeService.addToken(param);
    }

    @Override
    public void addInviteNum(Long userId) {
        this.userMapper.incrementInviteNum(userId);
        this.userService.loadUserToRedis(userId);
    }
}

