/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.attribute.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.user.attribute.UserChannelService;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.LocationChannelMapper;
import com.bxm.localnews.user.domain.LocationRelationChannelMapper;
import com.bxm.localnews.user.dto.LocationDTO;
import com.bxm.localnews.user.dto.UserAllChannelDTO;
import com.bxm.localnews.user.dto.UserChannelDTO;
import com.bxm.localnews.user.integration.LocationIntegrationService;
import com.bxm.localnews.user.param.UserChannelEditParam;
import com.bxm.localnews.user.param.UserChannelParam;
import com.bxm.localnews.user.vo.LocationRelationUser;
import com.bxm.localnews.user.vo.UserChannelVO;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.sf.json.regexp.RegexpMatcher;
import net.sf.json.regexp.RegexpUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserChannelServiceImpl
implements UserChannelService {
    @Autowired
    private LocationChannelMapper locationChannelMapper;
    @Autowired
    private LocationRelationChannelMapper locationRelationChannelMapper;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    private LocationIntegrationService locationIntegrationService;
    private static final RegexpMatcher MATCHER = RegexpUtils.getMatcher((String)"^\\{\\S+\\}\\S*$");

    @Override
    public UserAllChannelDTO getAllUserChannel(UserChannelParam userChannelParam) {
        UserAllChannelDTO userAllChannelDTO = new UserAllChannelDTO();
        Long newVersion = this.getNewVersion(userChannelParam.getLocationCode());
        String value = this.redisStringAdapter.getString(this.buildUserChannelKey(userChannelParam.getUserId(), userChannelParam.getLocationCode()));
        if (StringUtils.isNotEmpty((CharSequence)value) && newVersion.equals((userAllChannelDTO = (UserAllChannelDTO)JSON.parseObject((String)value, UserAllChannelDTO.class)).getVersion())) {
            return this.processPublishButton(userChannelParam, userAllChannelDTO);
        }
        userAllChannelDTO.setVersion(newVersion);
        List allChannelList = this.locationChannelMapper.getAllChannelList(userChannelParam.getLocationCode());
        List userChannelList = this.locationChannelMapper.getUserChannelList(userChannelParam.getLocationCode(), userChannelParam.getUserId());
        this.mergeUserChannelList(allChannelList, userChannelList, userChannelParam.getLocationCode());
        userAllChannelDTO.setAllChannelList(this.convertVoToDto(allChannelList, userChannelParam.getLocationCode()));
        userAllChannelDTO.setUserChannelList(this.convertVoToDto(userChannelList, userChannelParam.getLocationCode()));
        this.redisStringAdapter.set(this.buildUserChannelKey(userChannelParam.getUserId(), userChannelParam.getLocationCode()), (Object)JSON.toJSONString((Object)userAllChannelDTO));
        return this.processPublishButton(userChannelParam, userAllChannelDTO);
    }

    private UserAllChannelDTO processPublishButton(UserChannelParam param, UserAllChannelDTO userAllChannelDTO) {
        if (com.bxm.newidea.component.tools.StringUtils.compareVersion((String)param.getCurVer(), (String)"3.5.0") >= 0) {
            if (!CollectionUtils.isEmpty((Collection)userAllChannelDTO.getAllChannelList())) {
                userAllChannelDTO.getAllChannelList().forEach(p -> {
                    if (StringUtils.isNotBlank((CharSequence)p.getChannelUrl())) {
                        p.setChannelUrl(p.getChannelUrl().replace("&publishBtn=1", ""));
                    }
                });
            }
            if (!CollectionUtils.isEmpty((Collection)userAllChannelDTO.getUserChannelList())) {
                userAllChannelDTO.getUserChannelList().forEach(p -> {
                    if (StringUtils.isNotBlank((CharSequence)p.getChannelUrl())) {
                        p.setChannelUrl(p.getChannelUrl().replace("&publishBtn=1", ""));
                    }
                });
            }
        }
        return userAllChannelDTO;
    }

    @Override
    public List<UserChannelDTO> getUserChannel(UserChannelParam userChannelParam) {
        UserAllChannelDTO userAllChannelDTO = this.getAllUserChannel(userChannelParam);
        return userAllChannelDTO.getUserChannelList();
    }

    @Override
    public Boolean updateUserChannel(UserChannelParam userChannelParam) {
        this.locationRelationChannelMapper.deleteByUidCode(userChannelParam.getUserId(), userChannelParam.getLocationCode());
        ArrayList<LocationRelationUser> list = new ArrayList<LocationRelationUser>();
        for (UserChannelEditParam entity : userChannelParam.getUserChannelEditParams()) {
            LocationRelationUser relationUser = this.convertParamToLru(entity);
            relationUser.setCode(userChannelParam.getLocationCode());
            relationUser.setUserId(userChannelParam.getUserId());
            relationUser.setStatus(Integer.valueOf(1));
            list.add(relationUser);
        }
        this.locationRelationChannelMapper.batchInsert(list);
        this.redisStringAdapter.remove(this.buildUserChannelKey(userChannelParam.getUserId(), userChannelParam.getLocationCode()));
        return true;
    }

    private void mergeUserChannelList(List<UserChannelVO> allChannelList, List<UserChannelVO> userChannelList, String areaCode) {
        if (allChannelList.isEmpty()) {
            return;
        }
        if (null == userChannelList) {
            userChannelList = new ArrayList<UserChannelVO>();
        }
        ArrayList<UserChannelVO> needRemoveList = new ArrayList<UserChannelVO>();
        for (UserChannelVO entity : allChannelList) {
            if (null != entity.getAreaType() && entity.getAreaType().equals(1) && null != entity.getCode() && entity.getCode().indexOf(areaCode) != -1) {
                needRemoveList.add(entity);
                continue;
            }
            if (!userChannelList.contains(entity)) {
                if (!entity.getIsFixed().equals(1) && !entity.getFocusOn().equals(1)) continue;
                userChannelList.add(entity);
                continue;
            }
            if (userChannelList.size() <= 0) continue;
            userChannelList.forEach(userChannelVO -> {
                if (userChannelVO.getId().equals(entity.getId())) {
                    userChannelVO.setChannelUrl(entity.getChannelUrl());
                    userChannelVO.setFocusOn(entity.getFocusOn());
                    userChannelVO.setIsFixed(entity.getIsFixed());
                    if (entity.getIsFixed().equals(1)) {
                        userChannelVO.setSort(entity.getSort());
                    }
                    return;
                }
            });
        }
        allChannelList.removeAll(userChannelList);
        allChannelList.removeAll(needRemoveList);
        userChannelList.removeAll(needRemoveList);
        userChannelList.sort(UserChannelVO::compareTo);
    }

    private List<UserChannelDTO> convertVoToDto(List<UserChannelVO> listVO, String locationCode) {
        LocationDTO locationByGeocode = this.locationIntegrationService.getLocationByGeocode(locationCode);
        AtomicReference<String> cityName = new AtomicReference<String>("\u672c\u5730");
        if (Objects.nonNull(locationByGeocode) || StringUtils.isNotBlank((CharSequence)locationByGeocode.getName())) {
            cityName.set(locationByGeocode.getName());
        }
        return listVO.stream().map(p -> {
            UserChannelDTO userChannelDTO = new UserChannelDTO();
            BeanUtils.copyProperties((Object)p, (Object)userChannelDTO);
            userChannelDTO.setChannelId(p.getId());
            if (StringUtils.isNotBlank((CharSequence)userChannelDTO.getChannelName()) && MATCHER.matches(userChannelDTO.getChannelName())) {
                userChannelDTO.setChannelName(this.replace(userChannelDTO.getChannelName(), (String)cityName.get()));
            }
            return userChannelDTO;
        }).collect(Collectors.toList());
    }

    private String replace(String channelName, String replaceStr) {
        int start = channelName.indexOf("{");
        int end = channelName.indexOf("}");
        String startStr = channelName.substring(0, start);
        String endStr = channelName.substring(end + 1);
        return com.bxm.newidea.component.tools.StringUtils.join((Object[])new String[]{startStr, replaceStr, endStr});
    }

    private LocationRelationUser convertParamToLru(UserChannelEditParam param) {
        LocationRelationUser locationRelationUser = new LocationRelationUser();
        locationRelationUser.setLocationChannelId(param.getChannelId());
        locationRelationUser.setSort(param.getSort());
        return locationRelationUser;
    }

    private Long getNewVersion(String locationCode) {
        List list = this.redisHashMapAdapter.multiGet(RedisConfig.LOCATION_VERSION_CACHE, Arrays.asList(locationCode, "0"), Long.class);
        AtomicReference<Long> newVersion = new AtomicReference<Long>(0L);
        list.forEach(version -> {
            if (null != version) {
                newVersion.updateAndGet(v -> v + version);
            }
        });
        return newVersion.get();
    }

    private KeyGenerator buildUserChannelKey(Long userId, String locationCode) {
        KeyGenerator keyGenerator = RedisConfig.USER_LOCATION_LIST_CACHE.copy().appendKey((Object)userId).appendKey((Object)locationCode);
        return keyGenerator;
    }
}

