/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.attribute.impl;

import com.bxm.localnews.user.attribute.UserVisitService;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.UserVisitMapper;
import com.bxm.localnews.user.domain.VirtualUserMapper;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.UserVisitDTO;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.param.UserVisitParam;
import com.bxm.localnews.user.vip.UserVipService;
import com.bxm.localnews.user.vo.UserVisit;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.thread.NamedThreadFactory;
import com.bxm.newidea.component.tools.DateUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserVisitServiceImpl
extends BaseService
implements UserVisitService {
    private static final String USER_VISIT = "A_USER_VISIT_";
    private VirtualUserMapper userMapper;
    private final UserVisitMapper userVisitMapper;
    private final UserService userService;
    private final DistributedLock distributedLock;
    private final RedisStringAdapter redisStringAdapter;
    private final UserVipService userVipService;

    @Autowired(required=false)
    public UserVisitServiceImpl(VirtualUserMapper userMapper, UserVisitMapper userVisitMapper, UserService userService, DistributedLock distributedLock, RedisStringAdapter redisStringAdapter, UserVipService userVipService) {
        this.userMapper = userMapper;
        this.userVisitMapper = userVisitMapper;
        this.userService = userService;
        this.distributedLock = distributedLock;
        this.redisStringAdapter = redisStringAdapter;
        this.userVipService = userVipService;
    }

    @Override
    public List<UserVisitDTO> listUserVisit(UserVisitParam userVisitParam) {
        int start = 0;
        if (userVisitParam.getPageNum() > 0) {
            start = (userVisitParam.getPageNum() - 1) * userVisitParam.getPageSize();
        }
        List userVisitList = this.userVisitMapper.queryPageByVisitDate(Integer.valueOf(start), userVisitParam.getPageSize(), userVisitParam.getUserId());
        List<UserVisitDTO.VisitUserInfo> userVisitInfoList = userVisitList.parallelStream().map(this::convertUserVisit).collect(Collectors.toList());
        userVisitInfoList.forEach(item -> item.setIsVip(Integer.valueOf(this.userVipService.isVip(item.getVisitUserId()) != false ? 1 : 0)));
        TreeMap userVisitMap = userVisitInfoList.stream().sorted(Comparator.comparing(UserVisitDTO.VisitUserInfo::getVisitTime).reversed()).collect(Collectors.groupingBy(UserVisitDTO.VisitUserInfo::getVisitDate, () -> new TreeMap(Comparator.reverseOrder()), Collectors.toList()));
        ArrayList userVisitDtoList = new ArrayList();
        userVisitMap.forEach((k, v) -> {
            UserVisitDTO userVisitDTO = new UserVisitDTO();
            userVisitDTO.setVisitDate(k);
            userVisitDTO.setVisitUserInfoList(v);
            userVisitDtoList.add(userVisitDTO);
        });
        List<UserVisitDTO> result = userVisitDtoList.stream().sorted(Comparator.comparing(UserVisitDTO::getVisitDate).reversed()).collect(Collectors.toList());
        return result;
    }

    @Override
    @Async
    public void visit(Long userId, Long targetUserId) {
        if (null == userId || null == targetUserId || userId.equals(targetUserId)) {
            return;
        }
        UserInfoDTO userInfo = this.userService.getUserCache(userId);
        UserInfoDTO targetUserInfo = this.userService.getUserCache(targetUserId);
        if (null == userInfo || null == targetUserInfo) {
            return;
        }
        UserVisit userVisit = new UserVisit();
        userVisit.setUserId(targetUserId);
        userVisit.setUserNickname(targetUserInfo.getNickname());
        userVisit.setUserHeadImg(targetUserInfo.getHeadImg());
        userVisit.setUserSex(targetUserInfo.getSex());
        userVisit.setVisitUserId(userId);
        userVisit.setVisitUserNickname(userInfo.getNickname());
        userVisit.setVisitUserHeadImg(userInfo.getHeadImg());
        userVisit.setVisitUserSex(userInfo.getSex());
        userVisit.setVisitDate(LocalDate.now());
        userVisit.setVisitTime(LocalDateTime.now());
        userVisit.setIsVest(Byte.valueOf(userInfo.getState() == 3 ? (byte)1 : 0));
        String requestId = this.nextSequence().toString();
        String lockKey = USER_VISIT + userId + "_" + targetUserId;
        if (this.distributedLock.lock(lockKey, requestId)) {
            int update = this.userVisitMapper.update(userVisit);
            if (update == 0) {
                this.userVisitMapper.insert(userVisit);
                this.increaseTodayVisit(targetUserId);
            }
            this.distributedLock.unlock(lockKey, requestId);
        }
    }

    private void increaseTodayVisit(Long targetUserId) {
        this.redisStringAdapter.incrementWithDefault(RedisConfig.USER_VISIT_NUM.copy().appendKey((Object)"visit").appendKey((Object)targetUserId), 1L, 1, (long)DateUtils.getCurSeconds());
    }

    @Override
    public void virtualVisit(Long userId, Integer num) {
        List virtualUserIdList = this.userMapper.getRandomVirtualUserIdList(num);
        virtualUserIdList.forEach(e -> this.visit((Long)e, userId));
    }

    @Override
    public List<String> listRecentVisitorHeadImg(Long userId) {
        List userVisitList = this.userVisitMapper.selectLastVisitorHeadImg(userId, 3);
        if (!CollectionUtils.isEmpty((Collection)userVisitList)) {
            Collections.reverse(userVisitList);
        }
        return userVisitList.stream().map(UserVisit::getVisitUserHeadImg).collect(Collectors.toList());
    }

    @Override
    public Integer getTodayVisitorNum(Long userId) {
        return this.redisStringAdapter.getInt(RedisConfig.USER_VISIT_NUM.copy().appendKey((Object)"visit").appendKey((Object)userId));
    }

    @Override
    public void doTriggerUpdateInfo(Long userId, String nickname, String headImg, Byte sex) {
        int tableTotal = 10;
        CountDownLatch countDownLatch = new CountDownLatch(tableTotal);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, tableTotal, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("thread-trigger_update_user-"));
        int i = 0;
        while (i < tableTotal) {
            int finalI = i++;
            executor.execute(() -> {
                this.logger.debug("user update thread:{} begin work", (Object)Thread.currentThread().getId());
                try {
                    this.userVisitMapper.updateUserInfo(USER_VISIT + finalI, userId, nickname, headImg, sex);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    countDownLatch.countDown();
                }
                this.logger.debug("user update thread:" + Thread.currentThread().getId() + "end work");
            });
        }
        try {
            countDownLatch.await();
            this.logger.debug("\u7528\u6237\u5197\u4f59\u4fe1\u606f\u540c\u6b65\u6240\u6709\u7ebf\u7a0b\u6267\u884c\u7ed3\u675f");
        }
        catch (InterruptedException e) {
            this.logger.error("\u7528\u6237\u5197\u4f59\u4fe1\u606f\u540c\u6b65\u591a\u7ebf\u7a0b\u6267\u884c\u51fa\u73b0\u9519\u8bef:", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        executor.shutdown();
    }

    @Override
    public Integer getInterviewNumByUserId(Long userId) {
        return this.userVisitMapper.selectCountByUserId(userId);
    }

    @Override
    public Integer getInterviewNumByTime(Long userId, Date date) {
        return this.userVisitMapper.selectCountByTime(userId, date);
    }

    private UserVisitDTO.VisitUserInfo convertUserVisit(UserVisit userVisit) {
        UserVisitDTO.VisitUserInfo userVisitDTO = new UserVisitDTO.VisitUserInfo();
        BeanUtils.copyProperties((Object)userVisit, (Object)userVisitDTO);
        return userVisitDTO;
    }
}

