/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.invite.impl;

import com.bxm.localnews.user.dto.UserInviteBindDTO;
import com.bxm.localnews.user.enums.InviteBindMethodEnum;
import com.bxm.localnews.user.invite.InviteProcessService;
import com.bxm.localnews.user.invite.InviteProcessorContext;
import com.bxm.localnews.user.invite.InviteRecordService;
import com.bxm.localnews.user.invite.InviteTypeProcessorManager;
import com.bxm.localnews.user.invite.UserInviteService;
import com.bxm.localnews.user.invite.bind.BindInviteManager;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.param.InviteProcessParam;
import com.bxm.localnews.user.vo.InviteRecord;
import com.bxm.localnews.user.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.Message;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class InviteProcessServiceImpl
implements InviteProcessService {
    private static final Logger log = LoggerFactory.getLogger(InviteProcessServiceImpl.class);
    private final InviteTypeProcessorManager inviteTypeProcessorManager;
    private final InviteRecordService inviteRecordService;
    private UserInviteService userInviteService;
    private final BindInviteManager bindInviteManager;
    private final UserService userService;

    @Autowired
    public InviteProcessServiceImpl(InviteTypeProcessorManager inviteTypeProcessorManager, InviteRecordService inviteRecordService, BindInviteManager bindInviteManager, UserService userService) {
        this.inviteTypeProcessorManager = inviteTypeProcessorManager;
        this.inviteRecordService = inviteRecordService;
        this.bindInviteManager = bindInviteManager;
        this.userService = userService;
    }

    private UserInviteService getUserInviteService() {
        if (this.userInviteService == null) {
            this.userInviteService = (UserInviteService)SpringContextHolder.getBean(UserInviteService.class);
        }
        return this.userInviteService;
    }

    @Override
    @Async
    public void execAsyncActiveInvite(InviteProcessParam param) {
        log.debug("\u5904\u7406\u7528\u6237\u5efa\u7acb\u7684\u9080\u8bf7\u5173\u7cfb:{}", (Object)param);
        InviteRecord inviteRecord = this.inviteRecordService.getInviteRecordByInvitedUser(param.getInviteUserId(), param.getUserId());
        if (null != inviteRecord) {
            InviteProcessorContext context = new InviteProcessorContext();
            context.setRecord(inviteRecord);
            context.setBasicParam(param.getBasicParam());
            context.setInvitedEquipment(param.getEquipmentNum());
            Message message = this.inviteTypeProcessorManager.obtain(inviteRecord.getType()).afterInvited(context);
            if (!message.isSuccess()) {
                log.warn("\u5efa\u7acb\u9080\u8bf7\u5173\u7cfb\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)param, (Object)message);
                return;
            }
        }
        this.bindUserInvite(param.getUserId());
        log.debug("\u7528\u6237\u5efa\u7acb\u9080\u8bf7\u5173\u7cfb\u5b8c\u6210\uff1a{}", (Object)param);
    }

    private void bindUserInvite(Long userId) {
        UserInviteBindDTO userInviteBindDTO = new UserInviteBindDTO();
        userInviteBindDTO.setUserId(userId);
        userInviteBindDTO.setInviteBindMethodEnum(InviteBindMethodEnum.LOGIN_APP);
        this.bindInviteManager.bindInvite(userInviteBindDTO);
        this.getUserInviteService().changeHistoryStatus(userId, (byte)1);
    }

    @Override
    public String getFinalInviteTitle(UserInviteHistoryBean history) {
        return this.inviteTypeProcessorManager.obtain(history.getType()).decorateTitle(history);
    }

    @Override
    public String getLevelTwoFinalInviteTitle(Long userId, UserInviteHistoryBean history) {
        if (!Objects.equals(userId, history.getInviteUserId())) {
            return "\u6765\u81ea" + this.userService.getUserCache(history.getInviteUserId()).getNickname() + this.getFinalInviteTitle(history);
        }
        return "\u6765\u81ea\u4f60" + this.getFinalInviteTitle(history);
    }

    @Override
    public String getInviteTitle(UserInviteHistoryBean history) {
        InviteProcessorContext context = new InviteProcessorContext();
        context.setRelationId(history.getRelationId());
        return this.inviteTypeProcessorManager.obtain(history.getType()).obtainTitle(context);
    }
}

