/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.invite.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.user.account.CashFlowService;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.InviteRecordMapper;
import com.bxm.localnews.user.dto.BountyDTO;
import com.bxm.localnews.user.dto.InviteRecordDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.UserPayPromoteDTO;
import com.bxm.localnews.user.enums.AwardTypeEnum;
import com.bxm.localnews.user.enums.InviteRecordStateEnum;
import com.bxm.localnews.user.enums.InviteRecordStatusEnum;
import com.bxm.localnews.user.invite.InviteRecordService;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.param.InviteExpireTaskParam;
import com.bxm.localnews.user.param.InviteRecordParam;
import com.bxm.localnews.user.timer.InviteRelationshipTask;
import com.bxm.localnews.user.vo.InviteRecord;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.schedule.ScheduleService;
import com.bxm.newidea.component.schedule.builder.OnceTaskBuilder;
import com.bxm.newidea.component.schedule.task.ScheduleTask;
import com.bxm.newidea.component.schedule.task.TaskCallback;
import com.bxm.newidea.component.service.BaseService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class InviteRecordServiceImpl
extends BaseService
implements InviteRecordService {
    @Resource
    private InviteRecordMapper inviteRecordMapper;
    @Resource
    private UserService userService;
    @Resource
    private DistributedLock distributedLock;
    @Resource
    private CashFlowService cashFlowService;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private ScheduleService scheduleService;
    @Resource
    private InviteRelationshipTask inviteRelationshipTask;

    @Override
    public InviteRecord getInviteRecordByInvitedUser(Long inviteUserId, Long invitedUserId) {
        if (inviteUserId == null || invitedUserId == null) {
            return null;
        }
        InviteRecordParam inviteRecordParam = new InviteRecordParam();
        inviteRecordParam.setUserId(inviteUserId);
        inviteRecordParam.setInvitedUserId(invitedUserId);
        inviteRecordParam.setStatus(InviteRecordStatusEnum.VALID.getStatus());
        return this.inviteRecordMapper.getInviteRecordByUser(inviteRecordParam);
    }

    @Override
    public InviteRecord getInviteRecordById(Long inviteUserId, Long id) {
        InviteRecordParam inviteRecordParam = new InviteRecordParam();
        inviteRecordParam.setId(id);
        inviteRecordParam.setUserId(inviteUserId);
        return this.inviteRecordMapper.getInviteRecordByUser(inviteRecordParam);
    }

    @Override
    public Boolean updateInviteRecord(InviteRecord inviteRecord) {
        this.logger.info("\u66f4\u65b0\u9080\u8bf7\u5173\u7cfb[{}]", (Object)JSON.toJSONString((Object)inviteRecord));
        this.inviteRecordMapper.updateInviteRecord(inviteRecord);
        return Boolean.TRUE;
    }

    @Override
    public BountyDTO getUserBountyInfo(Long userId) {
        List<InviteRecord> inviteRecords = this.getUserAllInviteRecordByCash(userId);
        return this.generateBounty(inviteRecords);
    }

    @Override
    public UserPayPromoteDTO getUserPayPromote(Long userId) {
        List<InviteRecord> inviteRecords = this.getUserAllInviteRecordByCash(userId);
        return this.generatePayPromote(inviteRecords, userId);
    }

    @Override
    public Long addInviteRecord(Long inviteUserId, Long invitedUserId, String type) {
        if (null == inviteUserId || null == invitedUserId) {
            return 0L;
        }
        InviteRecordParam inviteRecordParam = new InviteRecordParam();
        inviteRecordParam.setUserId(inviteUserId);
        inviteRecordParam.setInvitedUserId(invitedUserId);
        inviteRecordParam.setStatus(InviteRecordStatusEnum.VALID.getStatus());
        List inviteRecordList = this.inviteRecordMapper.queryUserInviteRecord(inviteRecordParam);
        if (CollectionUtils.isEmpty((Collection)inviteRecordList)) {
            Long id = this.nextSequence();
            Date now = new Date();
            Date effectiveTime = DateUtils.addDays((Date)now, (int)1);
            UserInfoDTO userInfoDTO = this.userService.getUserCache(invitedUserId);
            if (this.distributedLock.lock(invitedUserId.toString(), id.toString(), 1L, TimeUnit.SECONDS)) {
                InviteRecord inviteRecord = new InviteRecord();
                inviteRecord.setId(id);
                inviteRecord.setUserId(inviteUserId);
                inviteRecord.setInvitedUserId(invitedUserId);
                inviteRecord.setType(type);
                inviteRecord.setInviteState(InviteRecordStateEnum.ACCEPT_INVITE.name());
                inviteRecord.setEffectTime(effectiveTime);
                inviteRecord.setInvitedUserName(userInfoDTO.getNickname());
                inviteRecord.setInvitedUserImg(userInfoDTO.getHeadImg());
                inviteRecord.setAwardType(AwardTypeEnum.CASH.name());
                inviteRecord.setCreateTime(now);
                inviteRecord.setModifyTime(now);
                this.inviteRecordMapper.addInviteRecord(inviteRecord);
                InviteExpireTaskParam param = new InviteExpireTaskParam();
                param.setInviteUserId(inviteRecord.getUserId());
                param.setInvitedUserId(inviteRecord.getInvitedUserId());
                this.scheduleService.push((ScheduleTask)OnceTaskBuilder.builder((String)InviteRelationshipTask.generateTaskName(inviteRecord.getUserId(), inviteRecord.getInvitedUserId()), (Date)effectiveTime, (TaskCallback)this.inviteRelationshipTask).callbackParam((Object)param).build());
                return id;
            }
        }
        return 0L;
    }

    @Override
    public Long updateInviteCash(Long inviteUserId, Long invitedUserId, BigDecimal cash) {
        if (null == inviteUserId || null == invitedUserId) {
            return 0L;
        }
        InviteRecordParam param = new InviteRecordParam();
        param.setUserId(inviteUserId);
        param.setInvitedUserId(invitedUserId);
        param.setStatus(InviteRecordStatusEnum.VALID.getStatus());
        param.setAwardType(AwardTypeEnum.CASH.name());
        List records = this.inviteRecordMapper.queryUserInviteRecord(param);
        if (!CollectionUtils.isEmpty((Collection)records)) {
            this.inviteRecordMapper.updateInviteCash(inviteUserId, invitedUserId, cash);
            return ((InviteRecord)records.get(0)).getId();
        }
        return 0L;
    }

    @Override
    public Boolean checkIsAssociation(Long userId) {
        return this.inviteRecordMapper.checkIsAssociation(userId) > 0;
    }

    @Override
    public Boolean insertNormal(Long inviteUserId, Long invitedUserId) {
        UserInfoDTO userInfoDTO = this.userService.getUserCache(invitedUserId);
        InviteRecord inviteRecord = new InviteRecord();
        inviteRecord.setId(this.nextSequence());
        inviteRecord.setUserId(inviteUserId);
        inviteRecord.setInvitedUserId(invitedUserId);
        inviteRecord.setType(userInfoDTO.getRegisterChannel());
        inviteRecord.setInviteState(InviteRecordStateEnum.ACCEPT_INVITE.name());
        inviteRecord.setEffectTime(DateUtils.addDays((Date)new Date(), (int)1));
        inviteRecord.setInvitedUserName(userInfoDTO.getNickname());
        inviteRecord.setInvitedUserImg(userInfoDTO.getHeadImg());
        inviteRecord.setAwardType(AwardTypeEnum.CASH.name());
        inviteRecord.setStatus(InviteRecordStatusEnum.VALID.getStatus());
        inviteRecord.setCreateTime(new Date());
        return this.inviteRecordMapper.addInviteRecord(inviteRecord) > 0;
    }

    private List<InviteRecord> getUserAllInviteRecordByCash(Long userId) {
        InviteRecordParam inviteRecordParam = new InviteRecordParam();
        inviteRecordParam.setUserId(userId);
        inviteRecordParam.setAwardType(AwardTypeEnum.CASH.toString());
        inviteRecordParam.setAward(BigDecimal.ZERO);
        return this.inviteRecordMapper.queryUserInviteRecord(inviteRecordParam);
    }

    private BountyDTO generateBounty(List<InviteRecord> inviteRecords) {
        List<InviteRecordDTO> invalidList;
        BountyDTO bountyDTO = new BountyDTO();
        if (CollectionUtils.isEmpty(inviteRecords)) {
            return bountyDTO;
        }
        List<InviteRecordDTO> validList = this.filterValid(inviteRecords);
        if (!CollectionUtils.isEmpty(validList)) {
            List availableCashList = bountyDTO.getAvailableCashList();
            BigDecimal availableCash = BigDecimal.ZERO;
            for (InviteRecordDTO inviteRecord : validList) {
                if (InviteRecordStateEnum.ACCEPT_INVITE.getName().equals(inviteRecord.getInviteState())) {
                    inviteRecord.setInviteState(InviteRecordStateEnum.ACCEPT_INVITE.getDesc());
                    availableCashList.add(inviteRecord);
                } else if (InviteRecordStateEnum.LOGIN_APP.getName().equals(inviteRecord.getInviteState())) {
                    inviteRecord.setInviteState(this.getInviteStateDesc(inviteRecord.getInviteState(), inviteRecord.getInvitedUserId()));
                    inviteRecord.setEffectTime(null);
                    availableCashList.add(inviteRecord);
                }
                availableCash = availableCash.add(inviteRecord.getAward());
            }
            bountyDTO.setAvailableCash(availableCash);
            bountyDTO.setAvailableCashList(availableCashList);
        }
        if (!CollectionUtils.isEmpty(invalidList = this.filterInValid(inviteRecords))) {
            List discardCashList = bountyDTO.getDiscardCashList();
            BigDecimal discardCash = BigDecimal.ZERO;
            for (InviteRecordDTO inviteRecord : invalidList) {
                if (InviteRecordStateEnum.OVERDUE_INVALID.getName().equals(inviteRecord.getInviteState())) {
                    inviteRecord.setInviteState(InviteRecordStateEnum.OVERDUE_INVALID.getDesc());
                } else if (InviteRecordStateEnum.NOT_NEW_USER.getName().equals(inviteRecord.getInviteState())) {
                    inviteRecord.setInviteState(InviteRecordStateEnum.NOT_NEW_USER.getDesc());
                }
                inviteRecord.setEffectTime(null);
                discardCashList.add(inviteRecord);
                discardCash = discardCash.add(inviteRecord.getAward());
            }
            bountyDTO.setDiscardCash(discardCash);
            bountyDTO.setDiscardCashList(discardCashList);
        }
        return bountyDTO;
    }

    private List<InviteRecordDTO> filterValid(List<InviteRecord> inviteRecords) {
        return inviteRecords.stream().map(this::convertInviteRecord).filter(inviteRecord -> InviteRecordStatusEnum.VALID.getStatus().equals(inviteRecord.getStatus()) && !InviteRecordStateEnum.SUCCESS_WITHDRAW.getName().equals(inviteRecord.getInviteState())).collect(Collectors.toList());
    }

    private List<InviteRecordDTO> filterInValid(List<InviteRecord> inviteRecords) {
        return inviteRecords.stream().map(this::convertInviteRecord).filter(inviteRecord -> InviteRecordStatusEnum.INVALID.getStatus().equals(inviteRecord.getStatus())).collect(Collectors.toList());
    }

    private List<InviteRecordDTO> filterObtain(List<InviteRecord> inviteRecords) {
        return inviteRecords.stream().map(this::convertInviteRecord).filter(inviteRecord -> InviteRecordStatusEnum.VALID.getStatus().equals(inviteRecord.getStatus()) && InviteRecordStateEnum.SUCCESS_WITHDRAW.getName().equals(inviteRecord.getInviteState())).collect(Collectors.toList());
    }

    private InviteRecordDTO convertInviteRecord(InviteRecord inviteRecord) {
        InviteRecordDTO inviteRecordDTO = new InviteRecordDTO();
        BeanUtils.copyProperties((Object)inviteRecord, (Object)inviteRecordDTO);
        return inviteRecordDTO;
    }

    private UserPayPromoteDTO generatePayPromote(List<InviteRecord> inviteRecords, Long userId) {
        BountyDTO bountyDTO = this.generateBounty(inviteRecords);
        UserPayPromoteDTO userPayPromoteDTO = new UserPayPromoteDTO();
        userPayPromoteDTO.setAvailableCash(bountyDTO.getAvailableCash());
        userPayPromoteDTO.setAvailableCashList(bountyDTO.getAvailableCashList());
        userPayPromoteDTO.setDiscardCash(bountyDTO.getDiscardCash());
        userPayPromoteDTO.setDiscardCashList(bountyDTO.getDiscardCashList());
        BigDecimal myRedPacket = this.cashFlowService.getMyRedPacket(userId);
        List<InviteRecordDTO> obtainList = this.filterObtain(inviteRecords);
        if (!CollectionUtils.isEmpty(obtainList)) {
            List havingCashList = userPayPromoteDTO.getHavingCashList();
            BigDecimal havingCash = BigDecimal.ZERO;
            for (InviteRecordDTO inviteRecord : obtainList) {
                inviteRecord.setInviteState(this.getInviteStateDesc(inviteRecord.getInviteState(), userId));
                havingCashList.add(inviteRecord);
                havingCash = havingCash.add(inviteRecord.getAward());
            }
            userPayPromoteDTO.setHavingCash(havingCash);
            userPayPromoteDTO.setHavingCashList(havingCashList);
        }
        BigDecimal havingCash = userPayPromoteDTO.getHavingCash();
        if (null != myRedPacket && myRedPacket.compareTo(BigDecimal.ZERO) > 0) {
            UserInfoDTO userInfo = this.userService.getUserCache(userId);
            InviteRecordDTO inviteRecord = new InviteRecordDTO();
            inviteRecord.setInvitedUserName(userInfo.getNickname());
            inviteRecord.setInvitedUserImg(userInfo.getHeadImg());
            inviteRecord.setAward(myRedPacket);
            inviteRecord.setInviteState("\u65b0\u7528\u6237\u7ea2\u5305");
            userPayPromoteDTO.getHavingCashList().add(inviteRecord);
            userPayPromoteDTO.setHavingCash(havingCash.add(inviteRecord.getAward()));
        }
        userPayPromoteDTO.setTotalGainCash(userPayPromoteDTO.getAvailableCash().add(userPayPromoteDTO.getHavingCash()));
        return userPayPromoteDTO;
    }

    private String getInviteStateDesc(String name, Long userId) {
        if (InviteRecordStateEnum.LOGIN_APP.getName().equals(name)) {
            Integer inviteState = (Integer)this.redisHashMapAdapter.get(RedisConfig.USER_WITHDRAW_LOGIN_TWICE.copy(), userId.toString(), Integer.class);
            if (null != inviteState && 1 == inviteState) {
                return "\u9700\u7b2c\u4e8c\u5929\u767b\u5f55";
            }
            return InviteRecordStateEnum.LOGIN_APP.getDesc();
        }
        return InviteRecordStateEnum.valueOf((String)name).getDesc();
    }
}

