/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.invite.processor;

import com.bxm.localnews.user.account.UserAccountService;
import com.bxm.localnews.user.attribute.UserAttributeService;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.UserInviteBindDTO;
import com.bxm.localnews.user.enums.AwardTypeEnum;
import com.bxm.localnews.user.enums.CashEnum;
import com.bxm.localnews.user.enums.CashFlowConvertTypeEnum;
import com.bxm.localnews.user.enums.CashFlowTypeEnum;
import com.bxm.localnews.user.enums.InviteBindMethodEnum;
import com.bxm.localnews.user.enums.InviteRecordStateEnum;
import com.bxm.localnews.user.enums.InviteRecordStatusEnum;
import com.bxm.localnews.user.integration.BizLogIntegrationService;
import com.bxm.localnews.user.invite.InviteProcessorContext;
import com.bxm.localnews.user.invite.InviteRecordService;
import com.bxm.localnews.user.invite.InviteTypeProcessor;
import com.bxm.localnews.user.invite.UserInviteService;
import com.bxm.localnews.user.invite.bind.BindInviteManager;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.param.AccountCashParam;
import com.bxm.localnews.user.vo.InviteRecord;
import com.bxm.localnews.user.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractInviteTypeProcessor
implements InviteTypeProcessor {
    private static final Logger log = LoggerFactory.getLogger(AbstractInviteTypeProcessor.class);
    int defaultColumnWidth = 80;
    String defaultInviteMsg = "\u7684\u5176\u4ed6\u5206\u4eab";
    @Resource
    UserService userService;
    @Resource
    UserAccountService userAccountService;
    @Resource
    InviteRecordService inviteRecordService;
    @Resource
    BizLogIntegrationService bizLogIntegrationService;
    @Resource
    UserInviteService userInviteService;
    @Resource
    UserAttributeService userAttributeService;
    @Autowired
    private BindInviteManager bindInviteManager;

    @Override
    public final Message afterInvited(InviteProcessorContext context) {
        log.info("\u9080\u8bf7\u6210\u529f\uff0c\u9080\u8bf7\u8bb0\u5f55\u4fe1\u606f\uff1a{}", (Object)context);
        this.fillContext(context);
        UserInviteBindDTO bean = this.convertInviteBind(context);
        Message message = Message.build((boolean)true);
        if (null == this.bindInviteManager.bindInvite(bean)) {
            message.setSuccess(false);
        }
        if (!message.isSuccess()) {
            return message;
        }
        message.append(this.callback(context));
        return message;
    }

    private void fillContext(InviteProcessorContext context) {
        if (context.getInvitedUser() == null) {
            UserInfoDTO inviteUser = this.userService.getUserCache(context.getRecord().getInvitedUserId());
            context.setInvitedUser(inviteUser);
        }
    }

    private void changeInviteAwardState(InviteProcessorContext context) {
        InviteRecord inviteRecord = context.getRecord();
        if (!InviteRecordStateEnum.ACCEPT_INVITE.name().equals(inviteRecord.getInviteState())) {
            log.info("\u5f53\u524d\u9080\u8bf7\u4eba[{}]\u4e0e\u53d7\u9080\u4eba[{}]\u7684\u72b6\u6001\u5904\u4e8e[{}]------\u4e0d\u4e88\u5904\u7406", new Object[]{inviteRecord.getUserId(), inviteRecord.getInvitedUserId(), inviteRecord.getInviteState()});
        }
        if (context.isEffective()) {
            AccountCashParam param = new AccountCashParam(inviteRecord.getUserId(), CashEnum.STABILIZE_CASH.name(), Boolean.valueOf(false), inviteRecord.getAward(), inviteRecord.getId(), CashFlowTypeEnum.PROMOTE_BOUNTY.name(), CashFlowConvertTypeEnum.TEMP_TO_STABILIZE.name());
            this.userAccountService.transferCash(param);
            inviteRecord.setInviteState(InviteRecordStateEnum.LOGIN_APP.getName());
            inviteRecord.setEffectTime(null);
            inviteRecord.setAwardType(AwardTypeEnum.CASH.name());
            Integer platform = context.getBasicParam() == null ? null : Integer.valueOf(context.getBasicParam().getPlatform());
            this.bizLogIntegrationService.inviteSuccessed(inviteRecord.getUserId(), inviteRecord.getInvitedUserId(), platform);
        } else {
            AccountCashParam accountCashParam = new AccountCashParam();
            accountCashParam.setUserId(inviteRecord.getUserId());
            accountCashParam.setCashType(CashEnum.TEMP_CASH.name());
            accountCashParam.setAddTotal(Boolean.valueOf(false));
            accountCashParam.setCashFlowType(CashFlowTypeEnum.INVALID_BOUNTY.name());
            accountCashParam.setCash(inviteRecord.getAward().negate());
            accountCashParam.setRelationId(inviteRecord.getId());
            this.userAccountService.addCash(accountCashParam);
            inviteRecord.setInviteState(InviteRecordStateEnum.OVERDUE_INVALID.name());
            inviteRecord.setAwardType(AwardTypeEnum.CASH.name());
            inviteRecord.setStatus(InviteRecordStatusEnum.INVALID.getStatus());
        }
        this.inviteRecordService.updateInviteRecord(inviteRecord);
    }

    private UserInviteBindDTO convertInviteBind(InviteProcessorContext context) {
        UserInviteBindDTO bean = new UserInviteBindDTO();
        bean.setUserId(context.getRecord().getInvitedUserId());
        if (context.getInvitedUser() != null) {
            bean.setInviteUserId(context.getInvitedUser().getInviteUserId());
        } else {
            bean.setInviteUserId(context.getRecord().getUserId());
        }
        bean.setInviteBindMethodEnum(InviteBindMethodEnum.LOGIN_APP);
        return bean;
    }

    private UserInviteHistoryBean convert(InviteProcessorContext context) {
        UserInviteHistoryBean history = new UserInviteHistoryBean();
        history.setUserId(context.getRecord().getInvitedUserId());
        history.setCreateTime(context.getRecord().getCreateTime());
        if (context.getInvitedUser() != null) {
            history.setInviteUserId(context.getInvitedUser().getInviteUserId());
            history.setInviteUserNickname(context.getRecord().getInvitedUserName());
            history.setInviteHeadImg(context.getRecord().getInvitedUserImg());
            history.setRelationId(context.getInvitedUser().getRelationId());
            if (null != context.getInvitedUser().getIsVip()) {
                history.setActiveVip(Byte.valueOf(context.getInvitedUser().getIsVip().byteValue()));
            }
            if (null != context.getRecord()) {
                history.setType(context.getRecord().getType());
            }
        } else {
            history.setInviteUserId(context.getRecord().getUserId());
            history.setInviteUserNickname(context.getRecord().getInvitedUserName());
            history.setInviteHeadImg(context.getRecord().getInvitedUserImg());
            history.setType(context.getRecord().getType());
        }
        String title = this.obtainTitle(context);
        history.setRelationTitle(StringUtils.substring((String)title, (int)0, (int)200));
        return history;
    }

    abstract Message callback(InviteProcessorContext var1);
}

