/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.invite.processor;

import com.bxm.localnews.auth.enums.AuthCodeEnum;
import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.user.auth.UserAuthCodeService;
import com.bxm.localnews.user.domain.UserEquipmentMapper;
import com.bxm.localnews.user.dto.LocationUserInfoDTO;
import com.bxm.localnews.user.dto.h5.ClientVersionDto;
import com.bxm.localnews.user.integration.BizLogIntegrationService;
import com.bxm.localnews.user.integration.IMIntegrationService;
import com.bxm.localnews.user.integration.PushMsgIntegrationService;
import com.bxm.localnews.user.invite.InviteProcessorContext;
import com.bxm.localnews.user.invite.processor.AbstractInviteTypeProcessor;
import com.bxm.localnews.user.vo.ImChatroom;
import com.bxm.localnews.user.vo.InviteRecord;
import com.bxm.localnews.user.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChatRoomInviteTypeProcessor
extends AbstractInviteTypeProcessor {
    private static final Logger log = LoggerFactory.getLogger(ChatRoomInviteTypeProcessor.class);
    private UserAuthCodeService userAuthCodeService;
    private UserEquipmentMapper userEquipmentMapper;
    private IMIntegrationService imIntegrationService;
    private PushMsgIntegrationService pushMsgIntegrationService;
    private BizLogIntegrationService bizLogIntegrationService;

    @Autowired
    public ChatRoomInviteTypeProcessor(UserAuthCodeService userAuthCodeService, UserEquipmentMapper userEquipmentMapper, IMIntegrationService imIntegrationService, PushMsgIntegrationService pushMsgIntegrationService, BizLogIntegrationService bizLogIntegrationService) {
        this.userAuthCodeService = userAuthCodeService;
        this.userEquipmentMapper = userEquipmentMapper;
        this.imIntegrationService = imIntegrationService;
        this.pushMsgIntegrationService = pushMsgIntegrationService;
        this.bizLogIntegrationService = bizLogIntegrationService;
    }

    @Override
    public String obtainTitle(InviteProcessorContext context) {
        return "\u804a\u5929\u5ba4";
    }

    @Override
    public InviteTypeEnum support() {
        return InviteTypeEnum.CHATROOM;
    }

    @Override
    public String decorateTitle(UserInviteHistoryBean inviteHistory) {
        return "\u804a\u5929\u5ba4\u9080\u8bf7";
    }

    @Override
    Message callback(InviteProcessorContext context) {
        InviteRecord inviteRecord = context.getRecord();
        Long inviteUserId = inviteRecord.getUserId();
        log.info("\u89e3\u9501\u7528\u6237\u62a2\u7ea2\u5305\u7684\u6743\u9650,userId:[{}]", (Object)inviteUserId);
        ClientVersionDto clientVersionDto = this.userEquipmentMapper.queryClientVersion(inviteUserId);
        if (null != clientVersionDto && StringUtils.compareVersion((String)clientVersionDto.getVersion(), (String)"3.0.0") >= 0 && !this.userAuthCodeService.hasAuth(inviteUserId, AuthCodeEnum.PICK_RED_PACKAGE).booleanValue()) {
            LocationUserInfoDTO location = this.userService.getLocationUserInfo(inviteUserId);
            this.userAuthCodeService.addAuthCode(inviteUserId, AuthCodeEnum.PICK_RED_PACKAGE);
            ImChatroom chatroom = this.imIntegrationService.getChatRoom(location.getLocationCode());
            if (chatroom.getEnableTimingRedPacket() == 1) {
                this.pushMsgIntegrationService.pushUnlockPickAuth(inviteUserId, context.getInvitedUser().getNickname(), location);
            }
            PointReportParam reportParam = PointReportParam.build((BasicParam)context.getBasicParam());
            reportParam.e("3034");
            reportParam.ev(StringUtils.join((Object[])new String[]{"109.", String.valueOf(inviteUserId)}));
            reportParam.put("uid", String.valueOf(context.getInvitedUser().getId()));
            this.bizLogIntegrationService.point(reportParam);
        }
        PointReportParam reportParam = PointReportParam.build((BasicParam)context.getBasicParam());
        reportParam.e("3034");
        reportParam.ev(StringUtils.join((Object[])new String[]{"110.", String.valueOf(inviteUserId)}));
        reportParam.put("uid", String.valueOf(context.getInvitedUser().getId()));
        this.bizLogIntegrationService.point(reportParam);
        return Message.build();
    }
}

