/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.invite.processor;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.user.dto.ForumPostBriefInfoDto;
import com.bxm.localnews.user.integration.NewsIntegrationService;
import com.bxm.localnews.user.invite.InviteProcessorContext;
import com.bxm.localnews.user.invite.processor.AbstractInviteTypeProcessor;
import com.bxm.localnews.user.utils.MaxLengthStringBuilder;
import com.bxm.localnews.user.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class ForumInviteTypeProcessor
extends AbstractInviteTypeProcessor {
    @Resource
    private NewsIntegrationService newsIntegrationService;

    @Override
    public InviteTypeEnum support() {
        return InviteTypeEnum.FORUM;
    }

    @Override
    public String decorateTitle(UserInviteHistoryBean inviteHistory) {
        if (StringUtils.isBlank((CharSequence)inviteHistory.getRelationTitle())) {
            return this.defaultInviteMsg;
        }
        return MaxLengthStringBuilder.builder(this.defaultColumnWidth).appendImmutable("\u5206\u4eab\u7684\u300a").appendDynamic(inviteHistory.getRelationTitle()).appendImmutable("\u300b\u5e16\u5b50").build();
    }

    @Override
    public String obtainTitle(InviteProcessorContext context) {
        if (context.getRelationId() == null) {
            return "";
        }
        ForumPostBriefInfoDto post = this.newsIntegrationService.getPostWithoutDetail(context.getRelationId());
        if (StringUtils.isBlank((CharSequence)post.getTitle())) {
            return "";
        }
        return post.getTitle();
    }

    @Override
    Message callback(InviteProcessorContext context) {
        return null;
    }
}

