/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.invite.processor;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.user.dto.CommodityGoodsDTO;
import com.bxm.localnews.user.integration.CommodityIntegrationService;
import com.bxm.localnews.user.invite.InviteProcessorContext;
import com.bxm.localnews.user.invite.processor.AbstractInviteTypeProcessor;
import com.bxm.localnews.user.utils.MaxLengthStringBuilder;
import com.bxm.localnews.user.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RebateInviteTypeProcessor
extends AbstractInviteTypeProcessor {
    private final CommodityIntegrationService commodityIntegrationService;

    @Autowired
    public RebateInviteTypeProcessor(CommodityIntegrationService commodityIntegrationService) {
        this.commodityIntegrationService = commodityIntegrationService;
    }

    @Override
    public String obtainTitle(InviteProcessorContext context) {
        if (context.getRelationId() == null) {
            return "";
        }
        CommodityGoodsDTO goods = this.commodityIntegrationService.getBriefGoodsById(context.getRelationId());
        if (null != goods && StringUtils.isNotBlank((CharSequence)goods.getCommodityTitle())) {
            return goods.getCommodityTitle();
        }
        return "";
    }

    @Override
    Message callback(InviteProcessorContext context) {
        return null;
    }

    @Override
    public InviteTypeEnum support() {
        return InviteTypeEnum.REBATE;
    }

    @Override
    public String decorateTitle(UserInviteHistoryBean inviteHistory) {
        if (StringUtils.isBlank((CharSequence)inviteHistory.getRelationTitle())) {
            return this.defaultInviteMsg;
        }
        return MaxLengthStringBuilder.builder(this.defaultColumnWidth).appendImmutable("\u5206\u4eab\u7684\u300a").appendDynamic(inviteHistory.getRelationTitle()).appendImmutable("\u300b\u5546\u54c1").build();
    }
}

