/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.login.adapter;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.user.param.RegisterParam;
import com.bxm.localnews.user.param.SilentRegisterParam;
import com.bxm.localnews.user.param.WechatBindParam;
import com.bxm.localnews.user.vo.H5RegisterParam;
import com.bxm.localnews.user.vo.LoginInfo;
import com.bxm.localnews.user.vo.LoginParam;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamAdapter {
    private static final Logger log = LoggerFactory.getLogger(ParamAdapter.class);

    public static LoginInfo transformSilentRegisterToLoginInfo(SilentRegisterParam silentRegisterParam) {
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setRegisteredaddress(silentRegisterParam.getRegisteredaddress());
        return loginInfo;
    }

    public static LoginInfo transformRegisterToLoginInfo(RegisterParam registerParam, BasicParam basicParam) {
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setRegisteredaddress(registerParam.getRegisteredaddress());
        loginInfo.setCode(registerParam.getCode());
        loginInfo.setHeadImg(registerParam.getHeadImg());
        loginInfo.setLoginName(registerParam.getLoginName());
        loginInfo.setNickname(registerParam.getNickname());
        loginInfo.setOpenId(registerParam.getOpenId());
        loginInfo.setPassword(registerParam.getPassword());
        loginInfo.setPhone(registerParam.getPhone());
        loginInfo.setInviteCode(registerParam.getInviteCode());
        loginInfo.setType(registerParam.getType());
        loginInfo.setId(registerParam.getId());
        loginInfo.setDeviceToken(registerParam.getDeviceToken());
        return loginInfo;
    }

    public static LoginInfo transformWechatBindToLoginInfo(WechatBindParam wechatBindParam) {
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setHeadImg(wechatBindParam.getHeadImg());
        loginInfo.setLoginName(wechatBindParam.getLoginName());
        loginInfo.setNickname(wechatBindParam.getNickname());
        loginInfo.setType(wechatBindParam.getType());
        loginInfo.setId(wechatBindParam.getId());
        return loginInfo;
    }

    public static LoginInfo transformLoginParamToLoginInfo(LoginParam loginParam, BasicParam basicParam) {
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setId(loginParam.getId());
        loginInfo.setCode(loginParam.getCode());
        loginInfo.setHeadImg(loginParam.getHeadImg());
        loginInfo.setLoginName(loginParam.getLoginName());
        loginInfo.setNickname(loginParam.getNickname());
        loginInfo.setPassword(loginParam.getPassword());
        loginInfo.setPhone(loginParam.getPhone());
        loginInfo.setInviteCode(loginParam.getInviteCode());
        loginInfo.setType(loginParam.getType());
        loginInfo.setResetPwd(loginParam.getResetPwd());
        loginInfo.setOpenId(loginParam.getOpenId());
        loginInfo.setUnionId(loginParam.getUnionId());
        loginInfo.setPhonemodel(loginParam.getPhonemodel());
        loginInfo.setCurVer(basicParam.getCurVer());
        loginInfo.setVersion(basicParam.getVersion());
        loginInfo.setOperatingSystem(loginParam.getOperatingSystem());
        loginInfo.setSex(ParamAdapter.changeSex(loginParam));
        return loginInfo;
    }

    private static Byte changeSex(LoginParam loginParam) {
        if (loginParam.getSex() == null) {
            return (byte)0;
        }
        if (NumberUtils.isDigits((String)loginParam.getSex())) {
            return Byte.valueOf(loginParam.getSex());
        }
        log.warn("\u8bf7\u6c42\u6027\u522b\u53c2\u6570\u5f02\u5e38\uff0c\u8fdb\u884c\u4fee\u6b63\u5904\u7406\uff1a{}", (Object)JSON.toJSONString((Object)loginParam));
        switch (loginParam.getSex()) {
            case "\u7537": {
                return (byte)1;
            }
            case "\u5973": {
                return (byte)2;
            }
        }
        return (byte)0;
    }

    public static LoginInfo transformH5Register(H5RegisterParam registerParam) {
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setCode(registerParam.getCode());
        loginInfo.setLoginName(registerParam.getLoginName());
        loginInfo.setPassword(registerParam.getPassword());
        loginInfo.setPhone(registerParam.getPhone());
        loginInfo.setInviteCode(registerParam.getInviteCode());
        loginInfo.setType(registerParam.getType());
        loginInfo.setId(registerParam.getId());
        return loginInfo;
    }
}

