/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.login.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.user.login.ChuanglanFlashService;
import com.bxm.localnews.user.param.ChuangLanLoginParam;
import com.bxm.localnews.user.properties.CommonProperties;
import com.bxm.localnews.user.utils.AESUtils;
import com.bxm.localnews.user.utils.MD5;
import com.bxm.localnews.user.utils.OkHttpUtil;
import com.bxm.localnews.user.utils.SignUtils;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ChuanglanFlashServiceImpl
implements ChuanglanFlashService {
    private static final Logger log = LoggerFactory.getLogger(ChuanglanFlashServiceImpl.class);
    private static final String SUCCESS_CODE = "200000";
    private static final String FLASH_LOGIN_URL = "https://api.253.com/open/flashsdk/mobile-query";
    @Resource
    private CommonProperties commonProperties;

    @Override
    public String getPhone(ChuangLanLoginParam param) {
        String appId = (String)this.commonProperties.getChuanglanAppId().get(param.getPlatform());
        String appKey = (String)this.commonProperties.getChuanglanAppIdDes().get(appId);
        log.debug("\u8bf7\u6c42\u95ea\u9a8c\u53c2\u6570\uff1a[{}],appId:[{}],appKey:[{}]", new Object[]{param, appId, appKey});
        if (StringUtils.isNotBlank((CharSequence)this.commonProperties.getChuanglanMockPhone())) {
            String phone = this.commonProperties.getChuanglanMockPhone();
            log.debug("\u7814\u53d1\u73af\u5883\uff0c\u8fd4\u56de\u6a21\u62df\u7684\u521b\u84dd\u95ea\u9a8c\u624b\u673a\u53f7\u7801:{}", (Object)phone);
            return phone;
        }
        JSONObject result = this.tokenExchangeMobileRequest(param, appKey, appId);
        if (null == result) {
            return null;
        }
        String code = result.getString("code");
        if (SUCCESS_CODE.equals(code)) {
            String dataStr = result.getString("data");
            JSONObject dataObj = JSONObject.parseObject((String)dataStr);
            String mobile = dataObj.getString("mobileName");
            try {
                String key = MD5.getMD5Code((String)appKey);
                mobile = AESUtils.decrypt((String)mobile, (String)key.substring(0, 16), (String)key.substring(16));
                log.debug("\u8bf7\u6c42\u5b8c\u6210\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a[{}],\u624b\u673a\u53f7\u7801\uff1a[{}],\u8fd4\u56de\u503c\uff1a[{}]", new Object[]{param, mobile, result});
            }
            catch (Exception e) {
                log.error("\u89e3\u6790\u95ea\u9a8c\u8fd4\u56de\u503c\u9519\u8bef\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a[{}]\uff0c\u8fd4\u56de\u503c\uff1a[{}]", (Object)param, (Object)result);
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
            return mobile;
        }
        log.error("\u95ea\u9a8c\u8fd4\u56de\u72b6\u6001\u9519\u8bef\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a[{}]\uff0c\u8fd4\u56de\u503c\uff1a[{}]", (Object)param, (Object)result);
        return null;
    }

    private JSONObject tokenExchangeMobileRequest(ChuangLanLoginParam param, String appKey, String appId) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("token", param.getFlashToken());
            params.put("appId", appId);
            params.put("encryptType", "0");
            params.put("sign", SignUtils.getSign(params, (String)appKey));
            JSONObject jsonObject = OkHttpUtil.postRequest(FLASH_LOGIN_URL, params);
            if (null != jsonObject) {
                return jsonObject;
            }
        }
        catch (Exception e) {
            log.error("\u5ba2\u6237\u7aef\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)param);
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

