/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.login.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.rediskey.UserRedisKey;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.msg.integration.SmsIntegrationService;
import com.bxm.localnews.user.account.CashFlowService;
import com.bxm.localnews.user.account.UserAccountService;
import com.bxm.localnews.user.attribute.UserPersonalInfoService;
import com.bxm.localnews.user.auth.UserAuthCodeService;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.UserAuthMapper;
import com.bxm.localnews.user.domain.UserEquipmentMapper;
import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.dto.EquipmentDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.enums.ActivationVipStatusEnum;
import com.bxm.localnews.user.enums.CashEnum;
import com.bxm.localnews.user.enums.CashFlowConvertTypeEnum;
import com.bxm.localnews.user.enums.CashFlowTypeEnum;
import com.bxm.localnews.user.exception.UserRepeatCreateException;
import com.bxm.localnews.user.integration.AppVersionIntegrationService;
import com.bxm.localnews.user.integration.BizIntegrationService;
import com.bxm.localnews.user.integration.BizLogIntegrationService;
import com.bxm.localnews.user.invite.InviteProcessService;
import com.bxm.localnews.user.login.LoginService;
import com.bxm.localnews.user.login.UserAuthService;
import com.bxm.localnews.user.login.UserLoginHistoryService;
import com.bxm.localnews.user.login.UserParamCheckService;
import com.bxm.localnews.user.login.UserRegistrationService;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.param.AccountCashParam;
import com.bxm.localnews.user.param.InviteProcessParam;
import com.bxm.localnews.user.support.ChannelService;
import com.bxm.localnews.user.support.UserEquipmentService;
import com.bxm.localnews.user.timer.InviteRelationshipTask;
import com.bxm.localnews.user.vip.UserVipService;
import com.bxm.localnews.user.vo.LoginInfo;
import com.bxm.localnews.user.vo.LoginMeta;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserAccount;
import com.bxm.localnews.user.vo.UserAuth;
import com.bxm.localnews.user.vo.UserEquipment;
import com.bxm.localnews.user.vo.UserVip;
import com.bxm.newidea.component.jwt.tools.JwtTokenUtil;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.schedule.ScheduleService;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.retry.RetryException;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="loginService")
@RefreshScope
public class LoginServiceImpl
extends BaseService
implements LoginService {
    private final SmsIntegrationService smsIntegrationService;
    private final UserAuthMapper userAuthMapper;
    private final UserMapper userMapper;
    private final UserService userService;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final RedisStringAdapter redisStringAdapter;
    private final AppVersionIntegrationService appVersionIntegrationService;
    private final UserAuthService userAuthService;
    private final BizLogIntegrationService bizLogIntegrationService;
    private final UserLoginHistoryService userLoginHistoryService;
    private final UserAccountService userAccountService;
    private final CashFlowService cashFlowService;
    private final UserEquipmentService userEquipmentService;
    private final ChannelService channelService;
    private final BizIntegrationService bizIntegrationService;
    private final UserParamCheckService userParamCheckService;
    private final UserEquipmentMapper userEquipmentMapper;
    private final UserRegistrationService userRegistrationService;
    private final UserAuthCodeService userAuthCodeService;
    private final ScheduleService scheduleService;
    private final InviteProcessService inviteProcessService;
    private final UserVipService userVipService;

    @Override
    @Retryable(value={RetryException.class}, backoff=@Backoff(value=300L))
    public Message doLogin(LoginInfo loginInfo, BasicParam basicParam) {
        Message message;
        UserAuth userAuth = this.userAuthMapper.selectByUserAuth(loginInfo.getType(), loginInfo.getLoginName());
        try {
            message = this.preJudgeBeforeLogin(loginInfo, basicParam, userAuth);
        }
        catch (UserRepeatCreateException e) {
            this.logger.warn("\u91cd\u590d\u521b\u5efa\u7528\u6237\uff0c\u8fdb\u884c\u91cd\u8bd5\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)loginInfo);
            throw new RetryException("\u7528\u6237\u5df2\u5b58\u5728\uff0c\u91cd\u65b0\u521b\u5efa");
        }
        if (!message.isSuccess()) {
            return message;
        }
        Boolean isReturn = (Boolean)message.getParam("return");
        if (null != isReturn && isReturn.booleanValue()) {
            return message;
        }
        LoginMeta meta = this.login(userAuth, loginInfo, basicParam);
        if (meta.getUser() != null) {
            this.bizLogIntegrationService.login(meta.getUser().getId(), Integer.valueOf(basicParam.getPlatform()));
        }
        return Message.build((boolean)true).addParam("meta", (Object)meta);
    }

    private Message preJudgeBeforeLogin(LoginInfo loginInfo, BasicParam basicParam, UserAuth userAuth) throws UserRepeatCreateException {
        boolean isPublishState = this.appVersionIntegrationService.getPublishState(basicParam);
        if (1 != loginInfo.getType()) {
            if (null == userAuth) {
                if (!isPublishState) {
                    Message meta = this.registerByWechat(loginInfo, basicParam);
                    return meta.addParam("return", (Object)true);
                }
                LoginMeta meta = new LoginMeta();
                meta.setCode(512);
                return Message.build((boolean)true).addParam("meta", (Object)meta).addParam("return", (Object)true);
            }
        } else if (1 == loginInfo.getType()) {
            Message message;
            if (isPublishState && this.appVersionIntegrationService.inWhiteList(loginInfo.getLoginName()).booleanValue()) {
                loginInfo.setCode("123456");
            }
            if (!this.userParamCheckService.checkParam(loginInfo)) {
                this.logger.info("doLogin failed:" + loginInfo);
                return Message.build((boolean)false, (String)"\u53c2\u6570\u9519\u8bef");
            }
            if (isPublishState && this.userParamCheckService.checkVerifyPwd(loginInfo) && !(message = this.userParamCheckService.verifyPwd(loginInfo.getPassword(), userAuth)).isSuccess()) {
                return message;
            }
        }
        return Message.build((boolean)true);
    }

    private Message registerByWechat(LoginInfo loginInfo, BasicParam basicParam) throws UserRepeatCreateException {
        User user = this.getUserByType(loginInfo);
        Message messageByCheckUser = this.userParamCheckService.checkRepeatBind(user, loginInfo);
        if (!messageByCheckUser.isSuccess()) {
            return messageByCheckUser;
        }
        LoginMeta meta = this.createAndBinding(user, loginInfo, basicParam);
        return Message.build((boolean)true).addParam("meta", (Object)meta);
    }

    private LoginMeta login(UserAuth userAuth, LoginInfo loginInfo, BasicParam basicParam) {
        Message deviceExistMessage = this.userLoginHistoryService.isDeviceExist(userAuth.getUserId(), basicParam.getDevcId());
        String equipment = deviceExistMessage.getParamMap().get("equipment") == null ? null : deviceExistMessage.getParamMap().get("equipment").toString();
        User user = this.userMapper.selectByPrimaryKey(userAuth.getUserId());
        this.addWechatLoginInfo(loginInfo, user);
        UserInfoDTO dto = this.activeAndLogin(loginInfo, user, basicParam, equipment);
        if (!deviceExistMessage.isSuccess()) {
            this.saveNewUserCache(userAuth.getUserId());
        }
        LoginMeta meta = new LoginMeta(dto, !deviceExistMessage.isSuccess());
        this.userLoginHistoryService.save(equipment, basicParam, user.getId(), loginInfo.getRegIp());
        return meta;
    }

    private String generateToken(Long userId, String token) {
        if (null == token) {
            token = JwtTokenUtil.generateToken((Long)userId);
        }
        this.redisHashMapAdapter.put(UserRedisKey.HASH_USER_TOKEN, String.valueOf(userId), (Object)token);
        return token;
    }

    private UserInfoDTO activeAndLogin(LoginInfo loginInfo, User user, BasicParam basicParam, String equipment) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u767b\u5f55->\u5f00\u59cb\u66f4\u65b0\u7528\u6237\u6570\u636e\uff0c\u53c2\u6570\uff1auser:[{}],\u8bbe\u5907\u53f7\uff1a[{}]", JSONObject.toJSON((Object)user), (Object)equipment);
        }
        user.setToken(this.generateToken(user.getId(), null));
        user.setRefreshtoken(JwtTokenUtil.generateToken((Long)user.getId()));
        user.setEquipment(equipment);
        user.setLastLoginIp(loginInfo.getLastLoginIp());
        user.setLastLoginTime(new Date());
        user.setChannelId(user.getChannelId() == 0L ? this.channelService.getChannelByCode(basicParam.getChnl()).getId() : user.getChannelId());
        user.setInfoCompleteState(((UserPersonalInfoService)SpringContextHolder.getBean(UserPersonalInfoService.class)).initUserInfoCompleteStatus(user));
        user.setRegisterClient(basicParam.getPlatform() + "");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u7528\u6237[{}]\u5bf9\u5e94\u7684\u72b6\u6001\uff1a[{}]", (Object)user.getId(), (Object)user.getState());
        }
        if (Objects.equals(user.getChannelId(), 0L)) {
            this.logger.debug("\u7528\u6237\u7684\u6ce8\u518c\u6e20\u9053\u672a\u5b9a\u4e49\uff0c\u7528\u6237ID:[{}],\u539f\u59cb\u6e20\u9053\uff1a[{}]", (Object)user.getId(), (Object)basicParam.getChnl());
        }
        this.updateUserActive(user, basicParam, equipment);
        this.userMapper.updateByPrimaryKeySelective(user);
        UserInfoDTO userInfoDetail = this.userService.loadUserToRedis(user.getId());
        this.addAuthInfo(userInfoDetail);
        this.replenishVipInfo(userInfoDetail);
        return userInfoDetail;
    }

    private void replenishVipInfo(UserInfoDTO userInfoDetail) {
        UserVip userVip = this.userVipService.getUserVipByUid(userInfoDetail.getId());
        userInfoDetail.setIsVip(Integer.valueOf(Objects.equals(userVip.getStatus(), ActivationVipStatusEnum.USEFUL.getStatus()) ? 1 : 0));
        if (Objects.equals(userVip.getStatus(), ActivationVipStatusEnum.USEFUL.getStatus())) {
            userInfoDetail.setLeftActiveNum(userVip.getLeftOpenNum());
        } else {
            userInfoDetail.setLeftActiveNum(Integer.valueOf(0));
        }
    }

    @Override
    public void updateUserActive(User user, BasicParam basicParam, String equipment) {
        if (2 == user.getState()) {
            UserAccount userAccount = this.userAccountService.getUserAccountDetail(user.getId());
            user.setState(Byte.valueOf((byte)1));
            boolean effective = false;
            if (StringUtils.isNotBlank((CharSequence)equipment)) {
                effective = this.userEquipmentMapper.countEquipment(equipment, "DRAW") == 0;
            }
            InviteProcessParam param = new InviteProcessParam();
            param.setInviteUserId(user.getInviteUserId());
            param.setUserId(user.getId());
            param.setBasicParam(basicParam);
            param.setEquipmentNum(equipment);
            param.setEffective(effective);
            this.inviteProcessService.execAsyncActiveInvite(param);
            this.updateUserCashState(userAccount.getUserId(), effective, equipment);
            this.scheduleService.remove(InviteRelationshipTask.generateTaskName(user.getInviteUserId(), user.getId()));
            this.bizLogIntegrationService.createUser(user, basicParam, userAccount);
        }
    }

    private void updateUserCashState(Long userId, boolean isEffective, String equipment) {
        this.logger.debug("\u65b0\u7528\u6237[{}]\u9996\u6b21\u767b\u9646\u4e34\u65f6\u8d4f\u91d1\u8f6c\u6362\u4e3a\u53ef\u63d0\u73b0\u8d4f\u91d1", (Object)userId);
        BigDecimal cash = this.cashFlowService.getMySelfBounty(userId);
        if (cash.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        if (isEffective) {
            AccountCashParam param = new AccountCashParam(userId, CashEnum.TEMP_CASH.name(), Boolean.valueOf(false), cash, null, null, CashFlowConvertTypeEnum.TEMP_TO_DRAWABLE.name());
            this.userAccountService.transferCash(param);
            UserEquipment userEquipment = new UserEquipment(Long.valueOf(this.nextId()), equipment, "DRAW");
            this.userEquipmentService.addUserEquipment(userEquipment);
        } else {
            AccountCashParam accountCashParam = new AccountCashParam();
            accountCashParam.setUserId(userId);
            accountCashParam.setCashType(CashEnum.TEMP_CASH.name());
            accountCashParam.setAddTotal(Boolean.valueOf(false));
            accountCashParam.setCashFlowType(CashFlowTypeEnum.INVALID_PACKET.name());
            accountCashParam.setCash(cash.negate());
            this.userAccountService.addCash(accountCashParam);
        }
    }

    private void addAuthInfo(UserInfoDTO userInfo) {
        userInfo.setCombineAuthCode(this.userAuthCodeService.getAuthCombineCode(userInfo.getId()));
        userInfo.setAuthResources(this.userAuthCodeService.getAuthResources(userInfo.getId()));
    }

    private void addWechatLoginInfo(LoginInfo loginInfo, User user) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u7528\u6237\u767b\u9646\u4f20\u5165\u7684\u53c2\u6570\uff1a[{}]", (Object)JSON.toJSONString((Object)loginInfo));
        }
        if (3 == loginInfo.getType()) {
            loginInfo.setUnionId(loginInfo.getLoginName());
        }
        if (null != loginInfo.getOpenId() && null != loginInfo.getUnionId()) {
            boolean isBindMsg;
            List userAuthList = this.userAuthMapper.listByUserId(user.getId());
            if (!CollectionUtils.isEmpty((Collection)userAuthList)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u5f53\u524d\u7528\u6237\u521b\u5efaunionId\u9274\u6743\u4fe1\u606f:\u7528\u6237id\uff1a[{}], unionId:[{}]", (Object)user.getId(), (Object)loginInfo.getUnionId());
                }
                if (!(isBindMsg = userAuthList.stream().anyMatch(e -> e.getIdentifier().equals(loginInfo.getUnionId())))) {
                    user.setWeixin(loginInfo.getUnionId());
                    this.userAuthService.addUserAuth((byte)3, user.getId(), loginInfo.getUnionId(), null);
                }
            }
            if (!(isBindMsg = userAuthList.stream().anyMatch(e -> e.getIdentifier().equals(loginInfo.getOpenId())))) {
                this.logger.debug("\u5f53\u524d\u7528\u6237\u521b\u5efaAPP\u5fae\u4fe1\u6388\u6743\u767b\u9646openId\u9274\u6743\u4fe1\u606f:\u7528\u6237id\uff1a[{}], openId:[{}]", (Object)user.getId(), (Object)loginInfo.getOpenId());
                this.userAuthService.addUserAuth((byte)6, user.getId(), loginInfo.getOpenId(), null);
            }
        }
    }

    private void updateUserInviteHistory() {
    }

    @Override
    @Retryable(value={RetryException.class}, backoff=@Backoff(value=300L))
    public Json<LoginMeta> registerAndBindingPhone(LoginInfo loginInfo, Long userId, BasicParam basicParam) {
        LoginMeta meta;
        if (!this.userParamCheckService.bindingAndRegisterCheckParam(loginInfo)) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u9519\u8bef");
        }
        Message messageByCheckAuth = this.userAuthService.checkBindExist(loginInfo.getType(), loginInfo.getLoginName());
        if (!messageByCheckAuth.isSuccess()) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)messageByCheckAuth.getLastMessage());
        }
        User user = this.getUserByType(loginInfo);
        Message messageByCheckUser = this.userParamCheckService.checkRepeatBind(user, loginInfo);
        if (!messageByCheckUser.isSuccess()) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)messageByCheckUser.getLastMessage());
        }
        if (null != userId && null != (user = this.userMapper.selectByPrimaryKey(userId)) && 0 == user.getState()) {
            user = null;
        }
        if (1 == loginInfo.getType() && StringUtils.isNotBlank((CharSequence)loginInfo.getCode()) && !this.smsIntegrationService.verifyByType(Byte.valueOf((byte)2), loginInfo.getPhone(), loginInfo.getCode()).booleanValue()) {
            return ResultUtil.genFailedResult((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u9a8c\u8bc1\u7801");
        }
        try {
            meta = this.createAndBinding(user, loginInfo, basicParam);
        }
        catch (UserRepeatCreateException e) {
            this.logger.warn("\u91cd\u590d\u521b\u5efa\u7528\u6237\uff0c\u8fdb\u884c\u91cd\u8bd5\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)loginInfo);
            throw new RetryException("\u7528\u6237\u5df2\u5b58\u5728\uff0c\u91cd\u65b0\u521b\u5efa");
        }
        return ResultUtil.genSuccessResult((Object)meta);
    }

    private User getUserByType(LoginInfo loginInfo) {
        User user = null;
        if (3 == loginInfo.getType()) {
            user = this.userMapper.findByWeixin(loginInfo.getLoginName());
        } else if (1 == loginInfo.getType()) {
            user = this.userMapper.findByPhone(loginInfo.getPhone());
        }
        return user;
    }

    private LoginMeta createAndBinding(User user, LoginInfo loginInfo, BasicParam basicParam) throws UserRepeatCreateException {
        Message deviceExistMessage;
        LoginMeta meta = new LoginMeta();
        if (null == user) {
            user = this.addDefaultUser(loginInfo, basicParam);
            this.generateToken(user.getId(), user.getToken());
        } else {
            this.syncThirdPartyInfo(user, loginInfo);
            this.changeToken(user, loginInfo, basicParam);
            this.addUserAuth(loginInfo, user.getId());
        }
        UserInfoDTO dto = this.userService.convertUserToDTO(user);
        boolean isFirstLogin = false;
        String equipment = basicParam.getDevcId();
        if (!NumberUtils.isDigits((String)basicParam.getDevcId())) {
            EquipmentDTO equipmentDTO = this.bizIntegrationService.getDevice(basicParam.getDevcId());
            String string = equipment = equipmentDTO == null ? null : equipmentDTO.getId();
        }
        if (!(deviceExistMessage = this.userLoginHistoryService.isDeviceExistByDeviceId(user.getId(), equipment)).isSuccess()) {
            isFirstLogin = true;
        }
        if (isFirstLogin) {
            this.saveNewUserCache(user.getId());
        }
        this.addAuthInfo(dto);
        meta.setUser(dto);
        meta.setFirstLogin(isFirstLogin);
        this.userLoginHistoryService.save(equipment, basicParam, user.getId(), loginInfo.getRegIp());
        this.userService.putUserToRedis(user);
        return meta;
    }

    private void saveNewUserCache(Long id) {
        KeyGenerator key = RedisConfig.NEW_USER_LOGIN.copy().appendKey((Object)id);
        this.redisStringAdapter.set(key, (Object)true);
        this.redisStringAdapter.expire(key, (long)DateUtils.getCurSeconds());
    }

    private void changeToken(User user, LoginInfo loginInfo, BasicParam basicParam) {
        user.setToken(this.generateToken(user.getId(), null));
        if (loginInfo.getSex() != null) {
            user.setSex(loginInfo.getSex());
        }
        user.setLastLoginTime(new Date());
        this.userMapper.updateByPrimaryKeySelective(user);
    }

    private User addDefaultUser(LoginInfo loginInfo, BasicParam basicParam) throws UserRepeatCreateException {
        return this.userRegistrationService.addUser(loginInfo, basicParam, (byte)1);
    }

    private void firstLogin(Long userId, String wechat, Integer platform) {
    }

    private void addUserAuth(LoginInfo loginInfo, Long userId) {
        this.logger.info("\u6dfb\u52a0\u7528\u6237\u6743\u9650\u8ba4\u8bc1");
        UserAuth auth = new UserAuth();
        auth.setUserId(userId);
        auth.setType(loginInfo.getType());
        if (StringUtils.equals((CharSequence)loginInfo.getPhone(), (CharSequence)loginInfo.getLoginName())) {
            auth.setIdentifier(loginInfo.getPhone());
            if (StringUtils.isNotEmpty((CharSequence)loginInfo.getPassword())) {
                auth.setCredential(MD5Util.hgmd5((String)loginInfo.getPassword()));
            }
            this.userAuthMapper.insertSelective(auth);
        }
        if (StringUtils.notEquals((CharSequence)loginInfo.getPhone(), (CharSequence)loginInfo.getLoginName())) {
            auth.setIdentifier(loginInfo.getLoginName());
            this.userAuthMapper.insertSelective(auth);
        }
    }

    private void syncThirdPartyInfo(User user, LoginInfo loginInfo) {
        if (1 == loginInfo.getType()) {
            user.setPhone(loginInfo.getLoginName());
        } else if (2 == loginInfo.getType()) {
            user.setQq(loginInfo.getLoginName());
        } else if (4 == loginInfo.getType()) {
            user.setWeibo(loginInfo.getLoginName());
        } else if (3 == loginInfo.getType()) {
            user.setWeixin(loginInfo.getLoginName());
            if (null != loginInfo.getNickname()) {
                user.setNickname(user.getNickname() == null ? loginInfo.getNickname() : user.getNickname());
            }
            if (null != loginInfo.getHeadImg()) {
                user.setHeadImg(user.getHeadImg() == null ? loginInfo.getHeadImg() : user.getHeadImg());
            }
        }
    }

    @Autowired
    public LoginServiceImpl(SmsIntegrationService smsIntegrationService, UserAuthMapper userAuthMapper, UserMapper userMapper, UserService userService, RedisHashMapAdapter redisHashMapAdapter, RedisStringAdapter redisStringAdapter, AppVersionIntegrationService appVersionIntegrationService, UserAuthService userAuthService, BizLogIntegrationService bizLogIntegrationService, UserLoginHistoryService userLoginHistoryService, UserAccountService userAccountService, CashFlowService cashFlowService, UserEquipmentService userEquipmentService, ChannelService channelService, BizIntegrationService bizIntegrationService, UserParamCheckService userParamCheckService, UserEquipmentMapper userEquipmentMapper, UserRegistrationService userRegistrationService, UserAuthCodeService userAuthCodeService, ScheduleService scheduleService, InviteProcessService inviteProcessService, UserVipService userVipService) {
        this.smsIntegrationService = smsIntegrationService;
        this.userAuthMapper = userAuthMapper;
        this.userMapper = userMapper;
        this.userService = userService;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.redisStringAdapter = redisStringAdapter;
        this.appVersionIntegrationService = appVersionIntegrationService;
        this.userAuthService = userAuthService;
        this.bizLogIntegrationService = bizLogIntegrationService;
        this.userLoginHistoryService = userLoginHistoryService;
        this.userAccountService = userAccountService;
        this.cashFlowService = cashFlowService;
        this.userEquipmentService = userEquipmentService;
        this.channelService = channelService;
        this.bizIntegrationService = bizIntegrationService;
        this.userParamCheckService = userParamCheckService;
        this.userEquipmentMapper = userEquipmentMapper;
        this.userRegistrationService = userRegistrationService;
        this.userAuthCodeService = userAuthCodeService;
        this.scheduleService = scheduleService;
        this.inviteProcessService = inviteProcessService;
        this.userVipService = userVipService;
    }
}

