/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.login.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.constant.InfoCombineStateEnum;
import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.account.UserAccountService;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.UserAuthMapper;
import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.dto.BaseUserInfo;
import com.bxm.localnews.user.dto.EquipmentDTO;
import com.bxm.localnews.user.dto.InteractRankInfo;
import com.bxm.localnews.user.dto.LocationDTO;
import com.bxm.localnews.user.dto.LocationUserInfoDTO;
import com.bxm.localnews.user.dto.UserBaseInfo;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.UserInviteBindDTO;
import com.bxm.localnews.user.dto.UserLocationInfoDTO;
import com.bxm.localnews.user.dto.UserPhoneDTO;
import com.bxm.localnews.user.dto.UserRegisterInfoDTO;
import com.bxm.localnews.user.dto.UserTbkInfo;
import com.bxm.localnews.user.dto.UserTbkInfoBean;
import com.bxm.localnews.user.dto.WxUserInfo;
import com.bxm.localnews.user.enums.GoldEnum;
import com.bxm.localnews.user.enums.GoldFlowTypeEnum;
import com.bxm.localnews.user.enums.InviteBindMethodEnum;
import com.bxm.localnews.user.enums.LevelEnum;
import com.bxm.localnews.user.enums.LocalNewsUserJudgeMarkerEnum;
import com.bxm.localnews.user.enums.TaskEnum;
import com.bxm.localnews.user.integration.BizIntegrationService;
import com.bxm.localnews.user.integration.LocationIntegrationService;
import com.bxm.localnews.user.integration.MissionIntegrationService;
import com.bxm.localnews.user.integration.PushMsgIntegrationService;
import com.bxm.localnews.user.invite.InviteRecordService;
import com.bxm.localnews.user.invite.UserInviteService;
import com.bxm.localnews.user.invite.bind.BindInviteManager;
import com.bxm.localnews.user.login.UserAuthService;
import com.bxm.localnews.user.login.UserLoginHistoryService;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.login.protocal.ProtocalProcesser;
import com.bxm.localnews.user.model.MerchantUserDTO;
import com.bxm.localnews.user.param.AccountGoldParam;
import com.bxm.localnews.user.param.RecordWechatParam;
import com.bxm.localnews.user.param.RiskParam;
import com.bxm.localnews.user.param.TempUserParam;
import com.bxm.localnews.user.param.UserBindPhoneParam;
import com.bxm.localnews.user.param.UserClipboardParam;
import com.bxm.localnews.user.properties.HomePageConfigProperties;
import com.bxm.localnews.user.properties.UserProperties;
import com.bxm.localnews.user.support.ExtendedService;
import com.bxm.localnews.user.support.impl.RiskRecordServiceImpl;
import com.bxm.localnews.user.vip.UserVipService;
import com.bxm.localnews.user.vip.relation.MerchantRelationService;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserAuth;
import com.bxm.localnews.user.vo.UserBindPhoneVO;
import com.bxm.localnews.user.vo.UserInviteHistoryBean;
import com.bxm.localnews.user.vo.UserLoginHistory;
import com.bxm.newidea.component.emoji.EmojiCodeParser;
import com.bxm.newidea.component.jwt.tools.JwtTokenUtil;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.BitOperatorUtil;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.Validater;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="userService")
@RefreshScope
public class UserServiceImpl
extends BaseService
implements UserService {
    @Resource
    private UserAuthService userAuthService;
    @Resource
    private UserAccountService userAccountService;
    @Resource
    private UserMapper userMapper;
    @Resource
    private UserVipService userVipService;
    @Resource
    private UserAuthMapper userAuthMapper;
    @Resource
    private UserProperties userProperties;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private LocationIntegrationService locationIntegrationService;
    @Resource
    private MissionIntegrationService missionIntegrationService;
    @Resource
    private InviteRecordService inviteRecordService;
    @Resource
    private DistributedLock distributedLock;
    @Resource
    private UserInviteService userInviteService;
    @Resource
    private PushMsgIntegrationService pushMsgIntegrationService;
    @Resource
    private HomePageConfigProperties homePageConfigProperties;
    @Resource
    private ExtendedService extendedService;
    @Resource
    private RiskRecordServiceImpl riskRecordService;
    @Resource
    private BizIntegrationService bizIntegrationService;
    @Autowired
    private ProtocalProcesser protocalProcesser;
    @Autowired
    private MerchantRelationService merchantRelationService;
    @Autowired
    private BindInviteManager bindInviteManager;
    @Autowired
    private UserLoginHistoryService userLoginHistoryService;

    private KeyGenerator buildUserCacheKey(Long userId) {
        return RedisConfig.USER_CACHE_INFO.copy().appendKey((Object)userId);
    }

    @Override
    public int createUser(User user, BasicParam basicParam) {
        if (Objects.isNull(user.getJudgeMarker())) {
            user.setJudgeMarker(Long.valueOf(0L));
        }
        user.setJudgeMarker(Long.valueOf(BitOperatorUtil.setBitToLong((Long)user.getJudgeMarker(), (int)LocalNewsUserJudgeMarkerEnum.VER_3_5_0.getIndex())));
        user.setJudgeMarker(Long.valueOf(BitOperatorUtil.setBitToLong((Long)user.getJudgeMarker(), (int)LocalNewsUserJudgeMarkerEnum.VER_3_6_0.getIndex())));
        return this.userMapper.insertSelective(user);
    }

    @Override
    public UserInfoDTO getUserCache(Long userId) {
        UserInfoDTO userDTO = (UserInfoDTO)this.redisStringAdapter.get(this.buildUserCacheKey(userId), UserInfoDTO.class);
        if (null == userDTO) {
            userDTO = this.loadUserToRedis(userId);
        } else if (3 > userDTO.getV()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u7f13\u5b58\u5bf9\u8c61\u662f\u5386\u53f2\u7248\u672c\uff0c\u52a0\u8f7d\u65b0\u7684\u7528\u6237\u7f13\u5b58\uff0c\u7528\u6237ID\uff1a{},\u7f13\u5b58\u4e2d\u7684\u7248\u672c:{},\u5f53\u524d\u7248\u672c:{}", new Object[]{userId, userDTO.getV(), 3});
            }
            userDTO = this.loadUserToRedis(userId);
        }
        return userDTO;
    }

    @Override
    public void removeUserCache(Long userId) {
        this.redisStringAdapter.remove(this.buildUserCacheKey(userId));
    }

    @Override
    public UserInfoDTO loadUserToRedis(Long userId) {
        User user = this.userMapper.selectByPrimaryKey(userId);
        if (null == user) {
            UserInfoDTO emptyUser = new UserInfoDTO();
            emptyUser.setId(userId);
            this.redisStringAdapter.set(this.buildUserCacheKey(userId), (Object)emptyUser, 3600L);
            return null;
        }
        return this.putUserToRedis(user);
    }

    @Override
    public UserInfoDTO putUserToRedis(User user) {
        LocationDTO locationByGeocode;
        this.logger.debug("\u66f4\u65b0\u7528\u6237\u7f13\u5b58\uff1a[{}]", JSONObject.toJSON((Object)user));
        UserInfoDTO dto = this.convertUserToDTO(user);
        dto.setIndustry(this.getIndustryInfo(user));
        if (StringUtils.isNotEmpty((CharSequence)user.getPersonalProfile())) {
            dto.setIsDefaultPersonalProfile(Boolean.FALSE);
        } else {
            dto.setIsDefaultPersonalProfile(Boolean.TRUE);
            dto.setPersonalProfile(this.homePageConfigProperties.getDefaultPersonalProfile());
        }
        if (null != user.getHometownCode() && null != (locationByGeocode = this.locationIntegrationService.getLocationByGeocode(user.getHometownCode()))) {
            dto.setHometownName(locationByGeocode.getFullName());
        }
        if (null != user.getLocationCode() && null != (locationByGeocode = this.locationIntegrationService.getLocationByGeocode(user.getLocationCode()))) {
            dto.setLocationName(locationByGeocode.getFullName());
        }
        dto.setIsVip(Integer.valueOf(this.userVipService.isVip(user.getId()) != false ? 1 : 0));
        this.redisStringAdapter.set(this.buildUserCacheKey(user.getId()), (Object)dto);
        return dto;
    }

    private String getIndustryInfo(User user) {
        StringBuilder industryBuilder = new StringBuilder();
        if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)user.getJobTitle()) && com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)user.getCompany())) {
            industryBuilder.append(user.getCompany()).append(user.getJobTitle());
        }
        if (StringUtils.isBlank((CharSequence)user.getJobTitle()) && StringUtils.isBlank((CharSequence)user.getCompany()) && com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)user.getJobCategoryName())) {
            industryBuilder.append(user.getJobCategoryName());
        }
        if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)user.getJobTitle()) && StringUtils.isBlank((CharSequence)user.getCompany()) && com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)user.getJobCategoryName())) {
            industryBuilder.append(user.getJobTitle());
        }
        if (StringUtils.isBlank((CharSequence)user.getJobTitle()) && com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)user.getCompany())) {
            industryBuilder.append(user.getCompany());
        }
        if (industryBuilder.length() > 0) {
            return industryBuilder.toString();
        }
        return null;
    }

    @Override
    public boolean checkUserExistByPhone(String phone, Integer flag) {
        User user = this.userMapper.findByPhone(phone);
        if (null == user) {
            return false;
        }
        if (com.bxm.newidea.component.tools.StringUtils.equals((CharSequence)user.getPhone(), (CharSequence)phone)) {
            this.logger.warn("\u7528\u6237\u5c1d\u8bd5\u7ed1\u5b9a\u76f8\u540c\u7684\u624b\u673a\u53f7\u7801\uff0c\u7528\u6237ID:{}\uff0c\u624b\u673a\u53f7\u7801\uff1a{}", (Object)user.getId(), (Object)phone);
            return false;
        }
        if (flag == 1) {
            UserAuth userAuth = this.userAuthMapper.selectByUserId(Byte.valueOf((byte)3), user.getId());
            return userAuth != null;
        }
        return true;
    }

    @Override
    public boolean checkUserExistByPhone(String phone) {
        return Objects.nonNull(this.userMapper.findByPhone(phone));
    }

    @Override
    public UserInfoDTO convertUserToDTO(User user) {
        UserInfoDTO dto = new UserInfoDTO();
        BeanUtils.copyProperties((Object)user, (Object)dto);
        if (StringUtils.isBlank((CharSequence)dto.getNickname())) {
            dto.setNickname(com.bxm.newidea.component.tools.StringUtils.hideMobile((String)user.getPhone()));
        }
        if (StringUtils.isNotBlank((CharSequence)user.getLocationName())) {
            dto.setLocationShortName(user.getLocationName());
        }
        if (StringUtils.isBlank((CharSequence)dto.getHeadImg())) {
            dto.setHeadImg(this.userProperties.getDefaultHeadImgUrl());
        }
        dto.setIsTempNickName(Byte.valueOf((byte)1));
        return dto;
    }

    @Override
    public Json<UserInfoDTO> refreshToken(Long userId, String refreshToken) {
        User user = this.userMapper.getUserByRefreshToken(userId.longValue(), refreshToken);
        if (null == user) {
            return ResultUtil.genFailedResult((int)RespCode.UNAUTHORIZED, (String)"\u767b\u5f55\u5931\u6548");
        }
        user.setExpiretime(Long.valueOf(JwtTokenUtil.generateExpirationDate().getTime()));
        user.setToken(JwtTokenUtil.generateToken((Long)userId));
        this.userMapper.updateByPrimaryKeySelective(user);
        UserInfoDTO dto = this.convertUserToDTO(user);
        return ResultUtil.genSuccessResult((Object)dto);
    }

    @Override
    public void checkCompleteInfo(User user) {
        long infoCompleteStatus = user.getInfoCompleteState();
        this.logger.debug("\u7528\u6237\u5b8c\u5584\u8d44\u6599\u7a0b\u5ea6\u4fe1\u606f:[{}]", (Object)infoCompleteStatus);
        if (InfoCombineStateEnum.values().length == InfoCombineStateEnum.getInfoCompleteStatus((Long)infoCompleteStatus)) {
            this.logger.debug("\u7528\u6237\u5df2\u5b8c\u5584\u8d44\u6599\uff0c\u8c03\u7528\u5b8c\u6210\u8d44\u6599\u63a5\u53e3:[{}]", (Object)infoCompleteStatus);
            this.missionIntegrationService.completeTask(user.getId(), TaskEnum.TASK_IMPROVE_INFO, null);
        }
    }

    @Override
    public Message getWxUserInfo(TempUserParam tempUserParam, HttpServletRequest request) {
        Message message = this.createTempUser(tempUserParam);
        if (message.isSuccess()) {
            WxUserInfo wxUserInfo = new WxUserInfo();
            wxUserInfo.setUserId(Long.valueOf((Long)message.getParamMap().get("userId")));
            wxUserInfo.setHeadImg(tempUserParam.getHeadImg());
            wxUserInfo.setUnionId(tempUserParam.getUnionId());
            wxUserInfo.setNickname(tempUserParam.getNickName());
            this.logger.debug("\u521b\u5efa\u4e34\u65f6\u7528\u6237\u6210\u529f:[{}]", JSONObject.toJSON((Object)wxUserInfo));
            return Message.build((boolean)true).addParam("wxUserInfo", (Object)wxUserInfo);
        }
        return message;
    }

    @Override
    public LocationUserInfoDTO getLocationUserInfo(Long userId) {
        return this.userMapper.getLocationUserInfo(userId);
    }

    @Override
    public User selectByPrimaryKey(Long userId) {
        return this.userMapper.selectByPrimaryKey(userId);
    }

    @Override
    public Boolean checkUnionIdIsUser(String unionId) {
        UserAuth userAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)3), unionId);
        if (userAuth == null) {
            return false;
        }
        User user = this.userMapper.selectByPrimaryKey(userAuth.getUserId());
        return user == null || user.getState() != 2;
    }

    @Override
    public Boolean isRiskUser(Long userId) {
        User user = this.userMapper.selectByPrimaryKey(userId);
        return user.getRisk() == 1;
    }

    @Override
    public Long addWSTAppletUser() {
        User user = this.saveWSTUser();
        return user.getId();
    }

    private User saveWSTUser() {
        User user = new User();
        user.setRegisterClient("5");
        user.setAge(0);
        user.setSex(Byte.valueOf((byte)0));
        user.setState(Byte.valueOf((byte)2));
        user.setLevel(LevelEnum.INITIAL_USER.getType());
        user.setIsNew(Byte.valueOf((byte)0));
        user.setIsTempNickName(Byte.valueOf((byte)1));
        user.setIsTempHeadImg(Byte.valueOf((byte)1));
        user.setNewbieGuideFlag(Byte.valueOf((byte)0));
        int count = this.createUser(user, null);
        if (count > 0) {
            User updateUser = new User();
            updateUser.setToken(JwtTokenUtil.generateToken((Long)user.getId()));
            updateUser.setRefreshtoken(JwtTokenUtil.generateToken((Long)user.getId()));
            updateUser.setExpiretime(Long.valueOf(JwtTokenUtil.generateExpirationDate().getTime()));
            this.userMapper.updateByPrimaryKeySelective(updateUser);
            this.loadUserToRedis(user.getId());
        }
        return user;
    }

    @Override
    public Boolean isTempUser(Long userId) {
        User user = this.userMapper.selectByPrimaryKey(userId);
        return 2 == user.getState();
    }

    @Override
    public Boolean isNormalUser(Long userId) {
        User user = this.userMapper.selectByPrimaryKey(userId);
        return null != user && 1 == user.getState();
    }

    @Override
    public Message createTempUser(TempUserParam userParam) {
        if (StringUtils.isBlank((CharSequence)userParam.getUnionId()) && null == userParam.getUserId()) {
            this.logger.error("\u521b\u5efa\u4e34\u65f6\u7528\u6237\u51fa\u73b0\u9519\u8bef\uff0c\u53c2\u6570\u975e\u6cd5:[{}]", JSONObject.toJSON((Object)userParam));
            return Message.build((boolean)false, (String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        this.logger.debug("\u5f00\u59cb\u521b\u5efa\u4e34\u65f6\u7528\u6237\uff0c\u53c2\u6570:[{}]", (Object)JSON.toJSONString((Object)userParam));
        User user = new User();
        this.convertTempUser(userParam, user);
        UserAuth unionUserAuth = null;
        if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)userParam.getUnionId())) {
            unionUserAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)3), userParam.getUnionId());
        }
        User existedUser = null;
        Long userId = null;
        if (null != userParam.getUserId()) {
            existedUser = this.userMapper.selectByPrimaryKey(userParam.getUserId());
        } else if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)userParam.getUnionId()) && null != unionUserAuth) {
            existedUser = this.userMapper.selectByPrimaryKey(unionUserAuth.getUserId());
        }
        if (null != existedUser) {
            userId = existedUser.getId();
        }
        if (null == existedUser && com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)userParam.getUnionId())) {
            this.logger.debug("\u6839\u636e\u7528\u6237id\u6216\u8005unionId\u65e0\u6cd5\u67e5\u8be2\u5230\u7528\u6237\uff0c\u521b\u5efa\u65b0\u7528\u6237");
            if (this.distributedLock.lock(userParam.getUnionId(), userParam.getUnionId(), 1L, TimeUnit.SECONDS)) {
                this.createUser(user, (BasicParam)userParam);
                userId = user.getId();
                this.userAuthService.addUserAuth((byte)3, userId, userParam.getUnionId(), null);
                this.userAccountService.createUserAccount(userId);
            }
        }
        this.loadUserToRedis(userId);
        this.afterProcessing(userParam, userId);
        UserInviteBindDTO inviteBindDTO = this.convertUserToInviteBind(user);
        if (null == inviteBindDTO.getUserId()) {
            inviteBindDTO.setUserId(userId);
        }
        this.bindInviteManager.bindInvite(inviteBindDTO);
        return Message.build((boolean)true).addParam("userId", (Object)userId);
    }

    private void afterProcessing(TempUserParam userParam, Long userId) {
        if (null != userParam.getOpenId()) {
            if (InviteTypeEnum.APPLETDRAW.getName().equals(userParam.getInviteType())) {
                UserAuth appletUserAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)7), userParam.getOpenId());
                if (null == appletUserAuth || null == appletUserAuth.getUserId()) {
                    this.userAuthService.addUserAuth((byte)7, userId, userParam.getOpenId(), null);
                }
            } else {
                UserAuth weixinUserAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)5), userParam.getOpenId());
                if (null == weixinUserAuth || null == weixinUserAuth.getUserId()) {
                    this.userAuthService.addUserAuth((byte)5, userId, userParam.getOpenId(), null);
                }
            }
        }
    }

    private UserInviteBindDTO convertUserToInviteBind(User user) {
        UserInviteBindDTO userInviteBindDTO = new UserInviteBindDTO();
        userInviteBindDTO.setUser(user);
        userInviteBindDTO.setUserId(user.getId());
        userInviteBindDTO.setInviteUserId(user.getInviteUserId());
        userInviteBindDTO.setRelationId(user.getRelationId());
        userInviteBindDTO.setInviteBindMethodEnum(InviteBindMethodEnum.CREATE_TEMP_USER);
        return userInviteBindDTO;
    }

    @Override
    public Message updateTempUser(TempUserParam userParam) {
        Message message = Message.build();
        if (StringUtils.isBlank((CharSequence)userParam.getUnionId())) {
            return message;
        }
        UserAuth openUserAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)8), userParam.getOpenId());
        if (null == openUserAuth) {
            this.logger.warn("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u8fdb\u884c\u9759\u9ed8\u767b\u9646\uff0c\u7981\u6b62\u521b\u5efa\u7528\u6237");
            return message;
        }
        this.logger.debug("\u5f00\u59cb\u66f4\u65b0\u3010\u4e07\u4e8b\u901a\u5c0f\u7a0b\u5e8f\u3011\u4e34\u65f6\u7528\u6237\uff1a{}", (Object)JSON.toJSONString((Object)userParam));
        User user = this.userMapper.selectByUserId(openUserAuth.getUserId().longValue());
        Long userId = null;
        boolean isInsertInviteRecord = false;
        UserAuth unionUserAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)3), userParam.getUnionId());
        if (null == unionUserAuth || null == unionUserAuth.getUserId()) {
            this.logger.info("\u5f53\u524d\u7528\u6237\u672a\u8fdb\u5165APP--------\u76f4\u63a5\u7ed1\u5b9a\u7528\u6237, unionId: " + userParam.getUnionId());
            if (this.distributedLock.lock(userParam.getUnionId(), userParam.getUnionId(), 1L, TimeUnit.SECONDS)) {
                this.convertTempUser(userParam, user);
                user.setState(Byte.valueOf((byte)1));
                this.userMapper.updateByPrimaryKeySelective(user);
                userId = user.getId();
                this.userAuthService.addUserAuth((byte)3, userId, userParam.getUnionId(), null);
                this.userAccountService.createUserAccount(userId);
                if (userParam.getInviteUserId() != null && userParam.getTaskInvited().booleanValue()) {
                    this.addInviteGoldAndPushMsg(userParam, 0);
                }
                this.missionIntegrationService.asyncCompleteTask(userId, TaskEnum.TASK_FIRST_LOGIN, String.valueOf(userId));
                isInsertInviteRecord = true;
            }
        } else {
            userId = unionUserAuth.getUserId();
            this.updateUserAuth(openUserAuth, userId);
            User existedUser = this.userMapper.selectByUserId(userId.longValue());
            if (userParam.getInviteUserId() != null && existedUser != null) {
                this.addInviteGoldAndPushMsg(userParam, 1);
            }
        }
        this.loadUserToRedis(userId);
        this.logger.debug("\u5c0f\u7a0b\u5e8f\u6388\u6743\u767b\u9646\u79fb\u9664\u7528\u6237[{}]\u5728redis\u7684\u7f13\u5b58", (Object)userId);
        this.addInviteRecord(userParam, userId, isInsertInviteRecord);
        return message.addParam("userId", (Object)userId);
    }

    private void addInviteGoldAndPushMsg(TempUserParam userParam, Integer userType) {
        Integer userGold;
        if (0 == userType) {
            userGold = this.userProperties.getNewUserGold();
        } else if (1 == userType) {
            userGold = this.userProperties.getOldUserGold();
        } else {
            return;
        }
        this.userAccountService.addGold(new AccountGoldParam(userParam.getInviteUserId(), GoldEnum.USABLE_GOLD.name(), Boolean.valueOf(true), userGold, null, GoldFlowTypeEnum.TASK_INVITE_FRIEND.name()));
        this.pushMsgIntegrationService.pushInviteMsg(userParam.getInviteUserId(), userParam.getHeadImg(), userParam.getNickName(), userGold, userType);
    }

    private void updateUserAuth(UserAuth openUserAuth, Long userId) {
        if (!userId.equals(openUserAuth.getUserId())) {
            this.userAuthMapper.removeAuth(Byte.valueOf((byte)8), userId);
            this.userAuthMapper.removeAuth(Byte.valueOf((byte)8), openUserAuth.getUserId());
            openUserAuth.setId(Long.valueOf(this.nextId()));
            openUserAuth.setUserId(userId);
            this.userAuthMapper.insertSelective(openUserAuth);
        }
    }

    private void addInviteRecord(TempUserParam userParam, Long userId, Boolean isInsertInviteRecord) {
        if (isInsertInviteRecord.booleanValue() && userParam.getInviteUserId() != null && !userParam.getInviteUserId().equals(userId)) {
            this.inviteRecordService.addInviteRecord(userParam.getInviteUserId(), userId, userParam.getInviteType());
            RecordWechatParam recordWechatParam = new RecordWechatParam();
            recordWechatParam.setUserId(userParam.getInviteUserId());
            recordWechatParam.setWechatUid(userParam.getUnionId());
            recordWechatParam.setWechatImg(userParam.getHeadImg());
            recordWechatParam.setWechatName(userParam.getNickName());
            this.logger.debug("\u6dfb\u52a0VIP\u9080\u8bf7\u8bb0\u5f55: \u9080\u8bf7\u4eba\uff1a[{}], \u53d7\u9080\u4eba\uff1a[{}]", (Object)userParam.getInviteUserId(), (Object)userParam.getUnionId());
        }
    }

    private void convertTempUser(TempUserParam tempUserParam, User user) {
        UserLocationInfoDTO infoDTO;
        user.setWeixin(tempUserParam.getUnionId());
        user.setNickname(EmojiCodeParser.replaceSoftbankEmoji((String)tempUserParam.getNickName()));
        user.setHeadImg(tempUserParam.getHeadImg());
        Long userId = user.getId() == null ? Long.valueOf(this.nextId()) : user.getId();
        String headImg = this.extendedService.uploadHeadImg(tempUserParam.getHeadImg(), userId);
        if (StringUtils.isNotEmpty((CharSequence)headImg)) {
            user.setHeadImg(headImg);
        }
        user.setSex(tempUserParam.getSex());
        user.setRegIp(tempUserParam.getRegIp());
        user.setRegisterClient(Objects.toString(tempUserParam.getPlatform()));
        user.setRegisteredAddress(tempUserParam.getRegisteredAddress());
        user.setLocationCode(tempUserParam.getLocationCode());
        user.setLocationName(tempUserParam.getLocationName());
        if (StringUtils.isBlank((CharSequence)tempUserParam.getLocationCode()) && Objects.nonNull(tempUserParam.getInviteUserId()) && Objects.nonNull(infoDTO = this.getUserLocationCodeById(tempUserParam.getInviteUserId()))) {
            user.setLocationCode(infoDTO.getLocationCode());
            user.setLocationName(infoDTO.getLocationShortName());
        }
        user.setRelationId(tempUserParam.getRelationId());
        user.setInviteUserId(tempUserParam.getInviteUserId());
        user.setRegisterChannel(tempUserParam.getInviteType());
        User inviteUser = this.userMapper.selectByPrimaryKey(tempUserParam.getInviteUserId());
        if (inviteUser == null) {
            this.logger.info("\u53d7\u9080\u7528\u6237[{}]\u7684\u9080\u8bf7\u4eba\u4e0d\u5b58\u5728\uff0c\u8bf7\u6c42\u53c2\u6570:[{}]", (Object)user.getId(), (Object)tempUserParam);
            user.setInviteLevel(Integer.valueOf(1));
        } else {
            this.logger.info("\u521b\u5efa\u9080\u8bf7\u7528\u6237[{}]\u7684\u53d7\u9080\u7528\u6237", (Object)inviteUser.getId());
            user.setInviteLevel(Integer.valueOf(inviteUser.getInviteLevel() + 1));
        }
        user.setState(Byte.valueOf((byte)2));
        user.setLevel(LevelEnum.INITIAL_USER.getType());
        user.setIsNew(Byte.valueOf((byte)0));
        user.setIsTempNickName(Byte.valueOf((byte)1));
        user.setIsTempHeadImg(Byte.valueOf((byte)1));
        user.setNewbieGuideFlag(Byte.valueOf((byte)0));
    }

    @Override
    public BaseUserInfo getNickNameAndHeadImg(Long userId) {
        BaseUserInfo baseUserInfo = new BaseUserInfo();
        UserInfoDTO user = this.getUserCache(userId);
        if (null != user) {
            BeanUtils.copyProperties((Object)user, (Object)baseUserInfo);
        }
        baseUserInfo.setMerchantStatus(Integer.valueOf(0));
        MerchantUserDTO merchantUserDTO = this.merchantRelationService.getRelationMerchant(userId);
        if (null != merchantUserDTO) {
            BeanUtils.copyProperties((Object)merchantUserDTO, (Object)baseUserInfo);
        }
        if (StringUtils.isBlank((CharSequence)baseUserInfo.getHeadImg())) {
            baseUserInfo.setHeadImg(this.userProperties.getDefaultHeadImgUrl());
        }
        return baseUserInfo;
    }

    @Override
    public List<UserInfoDTO> getBatchUserInfo(Collection<Long> userIds) {
        ArrayList userInfos = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(userIds)) {
            userIds.forEach(userId -> {
                UserInfoDTO userInfoDTO = this.getUserCache((Long)userId);
                if (null != userInfoDTO) {
                    userInfos.add(userInfoDTO);
                }
            });
        }
        return userInfos;
    }

    @Override
    @Async
    public void isRisk(Long userId, String phone, BasicParam basicParam, String deviceToken, String ip) {
        boolean isRiskNum;
        boolean bl = isRiskNum = StringUtils.isNotEmpty((CharSequence)phone) && phone.startsWith("170") || phone.startsWith("171");
        if (isRiskNum) {
            this.userMapper.updateUserToRisk(userId);
        } else if (this.checkRisk(phone, basicParam, deviceToken, ip).booleanValue()) {
            this.userMapper.updateUserToRisk(userId);
        }
    }

    @Override
    public String getGeneration(LocalDate birthday) {
        String generationStr = null;
        if (null != birthday) {
            int year = birthday.getYear();
            int decade = year / 10;
            String s = String.valueOf(decade);
            generationStr = s.substring(s.length() - 1) + "0\u540e";
        }
        return generationStr;
    }

    @Override
    public UserTbkInfo selectUserFromCacheByRelationId(String relationId) {
        return this.build(this.userMapper.selectUserByRelationId(relationId));
    }

    @Override
    public void updateTbkInfo(Long userId, String relationId, String specialId) {
        this.userMapper.updateTbkInfo(userId, relationId, specialId);
    }

    @Override
    public UserTbkInfo selectUserFromCacheByUserId(Long userId) {
        return this.build(this.userMapper.selectUserFromCacheByUserId(userId));
    }

    @Override
    public List<UserBaseInfo> selectUserByIdName(Long userId, String userName) {
        if (null != userId) {
            return this.userMapper.selectUserById(userId);
        }
        if (StringUtils.isNotEmpty((CharSequence)userName)) {
            return this.userMapper.selectUserByName(userName);
        }
        return new ArrayList<UserBaseInfo>();
    }

    private UserTbkInfo build(UserTbkInfoBean infoBean) {
        if (Objects.isNull(infoBean)) {
            return null;
        }
        UserTbkInfo info = new UserTbkInfo();
        info.setId(infoBean.getId());
        info.setNickname(infoBean.getNickname());
        info.setIsVip(this.userVipService.isVip(infoBean.getId()));
        info.setIsNovice(Boolean.valueOf(!BitOperatorUtil.getBitAsBoolean((Long)infoBean.getJudgeMarker(), (int)LocalNewsUserJudgeMarkerEnum.HAS_ORDERED.getIndex())));
        info.setJudgeMarker(infoBean.getJudgeMarker());
        info.setTbkSpecialId(infoBean.getTbkSpecialId());
        info.setTbkRelationId(infoBean.getTbkRelationId());
        UserInviteHistoryBean userInviteHistoryBean = this.userInviteService.selectByUserId(infoBean.getId());
        if (Objects.nonNull(userInviteHistoryBean)) {
            info.setSuperiorUserId(userInviteHistoryBean.getInviteUserId());
            info.setTopUserId(userInviteHistoryBean.getInviteSuperUserId());
            info.setContentSuperiorUserId(userInviteHistoryBean.getCreatedUserId());
            info.setContentTopUserId(userInviteHistoryBean.getInviteCreatedUserId());
        }
        return info;
    }

    private Boolean checkRisk(String phone, BasicParam basicParam, String deviceToken, String ip) {
        String operateSource = "";
        if (basicParam.getPlatform() == 1) {
            operateSource = "ANDROID";
        } else if (basicParam.getPlatform() == 2) {
            operateSource = "IOS";
        }
        RiskParam riskParam = new RiskParam();
        riskParam.setDeviceToken(deviceToken);
        riskParam.setIp(ip);
        riskParam.setOperateSource(operateSource);
        riskParam.setPhone(phone);
        EquipmentDTO equipmentDTO = this.bizIntegrationService.getDevice(basicParam.getDevcId());
        if (null != equipmentDTO && com.bxm.newidea.component.tools.StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{equipmentDTO.getId()})) {
            riskParam.setEquiment(equipmentDTO.getId());
            riskParam.setOperateSystem(equipmentDTO.getPhoneModel());
        }
        return this.riskRecordService.checkRiskDevice(riskParam);
    }

    @Override
    public UserBindPhoneVO checkUserAndPhoneExists(UserBindPhoneParam phoneParam) {
        UserBindPhoneVO result = new UserBindPhoneVO();
        User user = null;
        if (null == phoneParam.getUserId() && com.bxm.newidea.component.tools.StringUtils.isEmpty((CharSequence)phoneParam.getPhone())) {
            result.setStatus(0);
            result.setMsg("\u624b\u673a\u53f7\u548c\u7528\u6237id\u5fc5\u4f20\u4e00\u4e2a");
            return result;
        }
        if (null != phoneParam.getUserId()) {
            user = this.userMapper.selectByPrimaryKey(phoneParam.getUserId());
            if (null == user) {
                result.setStatus(6);
                result.setMsg("\u7528\u6237\u4e0d\u5b58\u5728");
                return result;
            }
            if (StringUtils.isNotEmpty((CharSequence)user.getPhone())) {
                result.setStatus(5);
                result.setMsg("\u7528\u6237\u5df2\u7ecf\u7ed1\u5b9a\u624b\u673a\u53f7");
                return result;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)phoneParam.getPhone())) {
            if (!Validater.checkPhone((String)phoneParam.getPhone())) {
                result.setStatus(4);
                result.setMsg("\u624b\u673a\u53f7\u7801\u683c\u5f0f\u9519\u8bef");
                return result;
            }
            user = this.userMapper.findByPhone(phoneParam.getPhone());
            if (null != user && StringUtils.isNotEmpty((CharSequence)user.getPhone())) {
                result.setStatus(3);
                result.setMsg("\u624b\u673a\u53f7\u5df2\u88ab\u4f7f\u7528");
                return result;
            }
        }
        return result;
    }

    @Override
    public UserBindPhoneVO bindUserPhone(UserBindPhoneParam phoneParam) {
        UserBindPhoneVO result = new UserBindPhoneVO();
        if (null == phoneParam.getUserId() || com.bxm.newidea.component.tools.StringUtils.isEmpty((CharSequence)phoneParam.getPhone())) {
            result.setStatus(0);
            result.setMsg("\u624b\u673a\u53f7\u548c\u7528\u6237id\u5fc5\u4f20");
            return result;
        }
        result = this.checkUserAndPhoneExists(phoneParam);
        if (result.getStatus() != 1) {
            return result;
        }
        User user = this.userMapper.selectByPrimaryKey(phoneParam.getUserId());
        if (StringUtils.isNotEmpty((CharSequence)user.getPhone())) {
            result.setStatus(5);
            result.setMsg("\u7528\u6237\u5df2\u7ed1\u5b9a\u624b\u673a\u53f7");
            return result;
        }
        this.userMapper.updateUserPhone(phoneParam.getUserId(), phoneParam.getPhone(), null);
        user.setPhone(phoneParam.getPhone());
        this.putUserToRedis(user);
        return result;
    }

    @Override
    public void updateUserJudgeMarker(Long userId, LocalNewsUserJudgeMarkerEnum judgeMarker, boolean add) {
        User user;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("userId: {} {} \u6807\u5fd7\u4f4djudgeMarker: {} ", new Object[]{userId, add ? "\u65b0\u589e" : "\u79fb\u9664", judgeMarker});
        }
        if (Objects.isNull(user = this.selectByPrimaryKey(userId))) {
            this.logger.warn("userId: {} \u67e5\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7528\u6237 \u65e0\u6cd5\u66f4\u65b0\u6807\u5fd7\u4f4djudgeMarker: {}", (Object)user, (Object)judgeMarker);
            return;
        }
        User update = new User();
        update.setId(userId);
        update.setUpdateTime(new Date());
        if (add) {
            update.setJudgeMarker(Long.valueOf(BitOperatorUtil.setBitToLong((Long)user.getJudgeMarker(), (int)judgeMarker.getIndex())));
        } else {
            update.setJudgeMarker(Long.valueOf(BitOperatorUtil.clearBit((Long)user.getJudgeMarker(), (int)judgeMarker.getIndex())));
        }
        this.userMapper.updateByPrimaryKeySelective(update);
        this.removeUserCache(userId);
    }

    @Override
    public List<InteractRankInfo> getInteractRankInfo(String areaCode, int limitNum, List<Long> userIds) {
        return this.userMapper.selectInteractRankInfo(areaCode, limitNum, userIds);
    }

    @Override
    public Integer replyNumForUser(Long userId) {
        Integer replyNum = this.userMapper.getReplyNumById(userId);
        return replyNum;
    }

    @Override
    public Boolean clipboardUpload(UserClipboardParam param) {
        this.protocalProcesser.execProtocal(param);
        return true;
    }

    @Override
    public List<UserPhoneDTO> getUserInfoBySensitivePhone(String sensitivePhone) {
        int phoneLength = 11;
        if (sensitivePhone == null || sensitivePhone.length() != phoneLength) {
            return Collections.emptyList();
        }
        String phonePrefix = StringUtils.substring((String)sensitivePhone, (int)0, (int)3);
        String phoneSuffix = StringUtils.substring((String)sensitivePhone, (int)7);
        return this.userMapper.selectUserBySensitivePhone(phonePrefix, phoneSuffix);
    }

    @Override
    public UserLocationInfoDTO getUserLocationCodeById(Long userId) {
        UserInfoDTO userCache = this.getUserCache(userId);
        return Objects.isNull(userCache) ? null : this.convert(userCache);
    }

    @Override
    public UserPhoneDTO getUserInfoByPhone(String phone) {
        return this.userMapper.selectUserByPhone(phone);
    }

    @Override
    public UserRegisterInfoDTO userRegisterInfo(Long userId) {
        UserInfoDTO userInfoDTO = this.loadUserToRedis(userId);
        if (Objects.isNull(userInfoDTO)) {
            return null;
        }
        UserRegisterInfoDTO registerInfoDTO = new UserRegisterInfoDTO();
        BeanUtils.copyProperties((Object)userInfoDTO, (Object)registerInfoDTO);
        registerInfoDTO.setUserId(userId);
        UserLoginHistory userLoginHistory = this.userLoginHistoryService.selectFirst(userId);
        if (Objects.nonNull(userLoginHistory)) {
            registerInfoDTO.setFirstLoginTime(userLoginHistory.getLastLoginTime());
            registerInfoDTO.setIntoAppDays(Integer.valueOf(DateUtils.getDiffDays((Date)userLoginHistory.getLastLoginTime(), (Date)new Date(), (boolean)true) + 1));
        }
        return registerInfoDTO;
    }

    @Override
    public Boolean delUserCacheBatch(List<Long> userIds) {
        if (Objects.equals(CollectionUtils.isEmpty(userIds), Boolean.FALSE)) {
            for (Long userId : userIds) {
                this.redisStringAdapter.remove(this.buildUserCacheKey(userId));
            }
        }
        return true;
    }

    private UserLocationInfoDTO convert(UserInfoDTO userInfoDTO) {
        UserLocationInfoDTO locationInfoDTO = new UserLocationInfoDTO();
        locationInfoDTO.setId(userInfoDTO.getId());
        locationInfoDTO.setLocationCode(userInfoDTO.getLocationCode());
        locationInfoDTO.setLocationName(userInfoDTO.getLocationName());
        locationInfoDTO.setLocationShortName(userInfoDTO.getLocationShortName());
        return locationInfoDTO;
    }
}

