/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.support.impl;

import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.base.model.dto.AvailableDomainInfo;
import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.user.attribute.UserFollowService;
import com.bxm.localnews.user.attribute.UserTagService;
import com.bxm.localnews.user.attribute.UserVisitService;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.UserLoginHistoryMapper;
import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.dto.BaseHomePage;
import com.bxm.localnews.user.dto.CustomerHomePageDTO;
import com.bxm.localnews.user.dto.LocationUserInfoDTO;
import com.bxm.localnews.user.dto.OnselfHomePageDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.integration.PushMsgIntegrationService;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.model.MerchantUserDTO;
import com.bxm.localnews.user.properties.BizConfigProperties;
import com.bxm.localnews.user.properties.HomePageConfigProperties;
import com.bxm.localnews.user.properties.NativeUserProperties;
import com.bxm.localnews.user.support.HomePageService;
import com.bxm.localnews.user.utils.ConstellationUtils;
import com.bxm.localnews.user.vip.UserVipService;
import com.bxm.localnews.user.vip.relation.MerchantRelationService;
import com.bxm.localnews.user.vo.UserTag;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HomePageServiceImpl
extends BaseService
implements HomePageService {
    private final String RESOURCE = "homepage:systemmessage:lock:";
    private final UserMapper userMapper;
    private final HomePageConfigProperties homePageConfigProperties;
    private final BizConfigProperties bizConfigProperties;
    private final RedisStringAdapter redisStringAdapter;
    private final UserLoginHistoryMapper userLoginHistoryMapper;
    private final PushMsgIntegrationService pushMsgIntegrationService;
    private final DistributedLock distributedLock;
    private final UserTagService userTagService;
    private final UserVisitService userVisitService;
    private final NativeUserProperties nativeUserProperties;
    private final UserService userService;
    private final MerchantRelationService merchantRelationService;
    private final UserVipService userVipService;
    private final DomainIntegrationService domainIntegrationService;

    @Override
    public OnselfHomePageDTO getOnselfHomePage(Long userId) {
        OnselfHomePageDTO result = new OnselfHomePageDTO();
        BaseHomePage baseHomePage = this.getBaseHomePage(userId);
        BeanUtils.copyProperties((Object)baseHomePage, (Object)result);
        result.setInterviewHeadImgs(this.userVisitService.listRecentVisitorHeadImg(userId));
        result.setTodayInterviewNum(this.userVisitService.getTodayVisitorNum(userId));
        result.setAllInterviewNum(this.userVisitService.getInterviewNumByUserId(userId));
        this.addRelateMerchant((BaseHomePage)result, userId, true);
        return result;
    }

    @Override
    public CustomerHomePageDTO getCustomerHomePage(Long targetUserId, Long userId) {
        CustomerHomePageDTO result = new CustomerHomePageDTO();
        BaseHomePage baseHomePage = this.getBaseHomePage(targetUserId);
        BeanUtils.copyProperties((Object)baseHomePage, (Object)result);
        result.setIsAttention(((UserFollowService)SpringContextHolder.getBean(UserFollowService.class)).isFollowed(userId, targetUserId));
        ((UserVisitService)SpringContextHolder.getBean(UserVisitService.class)).visit(userId, targetUserId);
        this.addRelateMerchant((BaseHomePage)result, targetUserId, false);
        return result;
    }

    private void addRelateMerchant(BaseHomePage result, Long userId, boolean isSelf) {
        result.setIsVip(Integer.valueOf(Objects.equals(this.userVipService.isVip(userId), Boolean.TRUE) ? 1 : 0));
        MerchantUserDTO merchantUserDTO = this.merchantRelationService.getRelationMerchant(userId);
        if (Objects.nonNull(merchantUserDTO)) {
            if (!Objects.equals(merchantUserDTO.getIsShelf(), 1)) {
                if (isSelf) {
                    BeanUtils.copyProperties((Object)merchantUserDTO, (Object)result);
                }
                return;
            }
            BeanUtils.copyProperties((Object)merchantUserDTO, (Object)result);
        }
    }

    private BaseHomePage getBaseHomePage(Long userId) {
        UserService userService = (UserService)SpringContextHolder.getBean(UserService.class);
        UserInfoDTO user = userService.getUserCache(userId);
        BaseHomePage baseHomePage = new BaseHomePage();
        if (Objects.nonNull(user)) {
            BeanUtils.copyProperties((Object)user, (Object)baseHomePage);
            if (Objects.equals(user.getIsDefaultPersonalProfile(), Boolean.TRUE)) {
                baseHomePage.setPersonalProfile(this.nativeUserProperties.getDefaultPersonalProfile());
            }
            if (null == user.getBirthday()) {
                baseHomePage.setAge(null);
            } else {
                LocalDate birthday = user.getBirthday().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                if (birthday.isAfter(LocalDate.now())) {
                    baseHomePage.setAge(null);
                } else {
                    baseHomePage.setConstellation(ConstellationUtils.calculateConstellation((LocalDate)birthday));
                    baseHomePage.setBirthday(birthday);
                    baseHomePage.setGeneration(userService.getGeneration(birthday));
                    baseHomePage.setAge(Integer.valueOf(LocalDate.now().getYear() - birthday.getYear() + 1));
                }
            }
            if (StringUtils.isBlank((CharSequence)baseHomePage.getBackgroundImgUrl())) {
                List urls = this.homePageConfigProperties.getDefaultBackgroundImgUrls();
                int index = ThreadLocalRandom.current().nextInt(this.homePageConfigProperties.getDefaultBackgroundImgUrls().size());
                String backgroundImgUrl = (String)urls.get(index);
                this.userMapper.updateBackgroundImgUrlById(userId, backgroundImgUrl);
                baseHomePage.setBackgroundImgUrl(backgroundImgUrl);
                userService.loadUserToRedis(userId);
            }
            if (Objects.equals(user.getIsDefaultPersonalProfile(), Boolean.TRUE)) {
                baseHomePage.setShareSubTitle(this.homePageConfigProperties.getShareSubTitle());
            } else {
                baseHomePage.setShareSubTitle(baseHomePage.getPersonalProfile());
            }
            if (StringUtils.isNotBlank((CharSequence)this.homePageConfigProperties.getShareTitle()) && StringUtils.isNotBlank((CharSequence)user.getNickname())) {
                baseHomePage.setShareTitle(this.homePageConfigProperties.getShareTitle().replace("{nickName}", user.getNickname()));
            }
            Optional domainInfo = this.domainIntegrationService.getBaseUrlInfoByScene(DomainScene.OUTSIDE_SHARE_VIEW, DomainScene.DomainViewScene.CONTENT_VIEW, null);
            baseHomePage.setShareUrl(StringUtils.join((Object[])new String[]{domainInfo.isPresent() ? ((AvailableDomainInfo)domainInfo.get()).getBaseUrl() : "", "/shareUserHome.html"}));
            List<UserTag> userTagList = this.userTagService.getUserTagFromRedisDb(userId);
            baseHomePage.setUserTagList(userTagList.stream().filter(e -> e.getDeleteFlag() == 0).map(UserTag::getLabel).collect(Collectors.toList()));
        }
        return baseHomePage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean sendSystemMessage(Long userId) {
        KeyGenerator keyGenerator = RedisConfig.USER_ACCESS_MESSAGE.copy().appendKey((Object)userId);
        String stringId = String.valueOf(this.nextId());
        String lockkey = "homepage:systemmessage:lock:" + userId;
        if (this.distributedLock.lock(lockkey, stringId)) {
            try {
                Date sendDate;
                int count;
                boolean flag;
                Long timestamp = (Long)this.redisStringAdapter.get(keyGenerator, Long.class);
                boolean bl = flag = Objects.isNull(timestamp) || !new Date(timestamp).toInstant().atZone(ZoneId.systemDefault()).toLocalDate().equals(LocalDate.now());
                if (flag && (count = this.userVisitService.getInterviewNumByTime(userId, sendDate = Objects.isNull(timestamp) ? this.userLoginHistoryMapper.selectMinLoginTime(userId) : new Date(timestamp)).intValue()) > 0) {
                    this.logger.debug("homepage systemmessage ,userId={},sendTime={}", (Object)userId, (Object)DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                    LocationUserInfoDTO location = this.userService.getLocationUserInfo(userId);
                    this.pushMsgIntegrationService.sendSystemMessage(userId, count, location);
                    this.redisStringAdapter.set(keyGenerator, System.currentTimeMillis());
                }
            }
            finally {
                this.distributedLock.unlock(lockkey, stringId);
            }
        }
        return Boolean.TRUE;
    }

    @Autowired
    public HomePageServiceImpl(UserMapper userMapper, HomePageConfigProperties homePageConfigProperties, BizConfigProperties bizConfigProperties, RedisStringAdapter redisStringAdapter, UserLoginHistoryMapper userLoginHistoryMapper, PushMsgIntegrationService pushMsgIntegrationService, DistributedLock distributedLock, UserTagService userTagService, UserVisitService userVisitService, NativeUserProperties nativeUserProperties, UserService userService, MerchantRelationService merchantRelationService, UserVipService userVipService, DomainIntegrationService domainIntegrationService) {
        this.userMapper = userMapper;
        this.homePageConfigProperties = homePageConfigProperties;
        this.bizConfigProperties = bizConfigProperties;
        this.redisStringAdapter = redisStringAdapter;
        this.userLoginHistoryMapper = userLoginHistoryMapper;
        this.pushMsgIntegrationService = pushMsgIntegrationService;
        this.distributedLock = distributedLock;
        this.userTagService = userTagService;
        this.userVisitService = userVisitService;
        this.nativeUserProperties = nativeUserProperties;
        this.userService = userService;
        this.merchantRelationService = merchantRelationService;
        this.userVipService = userVipService;
        this.domainIntegrationService = domainIntegrationService;
    }
}

