/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.support.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.constant.InfoCombineStateEnum;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.user.attribute.UserTagService;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.dto.DynamicDTO;
import com.bxm.localnews.user.dto.GuideDTO;
import com.bxm.localnews.user.dto.ImgDTO;
import com.bxm.localnews.user.dto.LocationDTO;
import com.bxm.localnews.user.dto.NativeDTO;
import com.bxm.localnews.user.dto.NativeInfoDTO;
import com.bxm.localnews.user.dto.NoteDTO;
import com.bxm.localnews.user.dto.PostDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.integration.LocationIntegrationService;
import com.bxm.localnews.user.integration.UserNewsIntegrationService;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.param.NativeParam;
import com.bxm.localnews.user.param.NativeRecommendContext;
import com.bxm.localnews.user.properties.NativeUserProperties;
import com.bxm.localnews.user.properties.UserProperties;
import com.bxm.localnews.user.service.NativeRecommendService;
import com.bxm.localnews.user.support.NativeUserService;
import com.bxm.localnews.user.vo.RecommendNative;
import com.bxm.localnews.user.vo.UserTag;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class NativeUserServiceImpl
extends BaseService
implements NativeUserService {
    private final NativeRecommendService nativeRecommendService;
    private final NativeUserProperties nativeUserProperties;
    private final UserService userService;
    private final UserTagService userTagService;
    private final LocationIntegrationService locationIntegrationService;
    private final UserNewsIntegrationService userNewsIntegrationService;
    private final RedisSetAdapter redisSetAdapter;
    private final UserProperties userProperties;

    @Override
    public NativeDTO listNative(Long userId, NativeParam nativeParam, BasicParam basicParam) {
        this.logger.debug("\u7528\u6237\u8fdb\u884c\u672c\u5730\u4eba\u63a8\u8350\uff0c\u7528\u6237id:[{}],\u53c2\u6570:[{}]", (Object)userId, JSON.toJSON((Object)nativeParam));
        ArrayList nativeDtoList = new ArrayList();
        NativeRecommendContext nativeRecommendContext = NativeRecommendContext.builder().userId(userId).industryId(StringUtils.isEmpty((Object)nativeParam.getIndustryId()) ? null : Long.valueOf(Long.parseLong(nativeParam.getIndustryId()))).build();
        BeanUtils.copyProperties((Object)nativeParam, (Object)nativeRecommendContext);
        if (1 == nativeParam.getActionType()) {
            LocationDTO locationDTO = this.locationIntegrationService.getLocationByGeocode(nativeParam.getCurrentAreaCode());
            if (null != locationDTO) {
                nativeRecommendContext.setCurrentAreaCode(locationDTO.getCode());
            }
            UserInfoDTO user = this.userService.getUserCache(userId);
            nativeRecommendContext.addParam("user", (Object)user);
        }
        NativeRecommendContext recommendNativeWarper = this.nativeRecommendService.listRecommendUser(nativeRecommendContext);
        List recommendNativeList = recommendNativeWarper.getResult();
        this.logger.debug("\u5f97\u5230\u7528\u6237\u63a8\u8350\u5217\u8868:[{}]", JSON.toJSON((Object)recommendNativeList));
        if (!CollectionUtils.isEmpty((Collection)recommendNativeList)) {
            List<Long> userIdList = recommendNativeList.stream().map(RecommendNative::getUserId).collect(Collectors.toList());
            Map<Long, UserInfoDTO> userMap = this.getUserMap(userIdList);
            Map<Long, List<UserTag>> userTagMap = this.userTagService.getBatchUserTag(userIdList);
            Map imgMap = this.userNewsIntegrationService.batchGetUserImg(userIdList);
            recommendNativeList.forEach(e -> {
                UserInfoDTO user = (UserInfoDTO)userMap.get(e.getUserId());
                if (user == null) {
                    return;
                }
                List<Object> tagNameList = new ArrayList();
                List userTagList = (List)userTagMap.get(e.getUserId());
                if (!CollectionUtils.isEmpty((Collection)userTagList)) {
                    tagNameList = userTagList.stream().filter(t -> t.getDeleteFlag() == 0).map(UserTag::getLabel).collect(Collectors.toList());
                }
                List imgDtoList = new ArrayList();
                List imgList = (List)imgMap.get(e.getUserId());
                if (!CollectionUtils.isEmpty((Collection)imgList)) {
                    imgDtoList = imgList;
                }
                String distance = "";
                if (null != e.getDistance() && 0 != e.getDistance()) {
                    distance = this.getDistance(e.getDistance()) + "km\u5185";
                }
                String generationStr = this.getGeneration(user);
                String personalProfile = user.getPersonalProfile();
                if (user.getIsDefaultPersonalProfile().booleanValue()) {
                    personalProfile = this.nativeUserProperties.getDefaultPersonalProfile();
                }
                nativeDtoList.add(((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)NativeInfoDTO.builder().distance(distance)).generation(generationStr)).headImg(user.getHeadImg())).hobbyList(tagNameList)).imgList(imgDtoList)).industry(user.getIndustry())).nickName(user.getNickname())).personalProfile(personalProfile)).recommendType(e.getRecommendType())).sex(user.getSex())).userId(e.getUserId())).build());
            });
        }
        return NativeDTO.builder().recommendCategory(recommendNativeWarper.getRecommendCategory()).nativeInfoList(nativeDtoList).build();
    }

    @Override
    public NativeDTO listNativeForV2(Long userId, NativeParam nativeParam, BasicParam basicParam) {
        this.logger.debug("\u7528\u6237\u8fdb\u884c\u672c\u5730\u4eba\u63a8\u8350\uff0c\u7528\u6237id:[{}],\u53c2\u6570:[{}]", (Object)userId, JSON.toJSON((Object)nativeParam));
        List<Object> nativeDtoList = new ArrayList();
        NativeRecommendContext nativeRecommendContext = NativeRecommendContext.builder().userId(userId).industryId(StringUtils.isEmpty((Object)nativeParam.getIndustryId()) ? null : Long.valueOf(Long.parseLong(nativeParam.getIndustryId()))).build();
        BeanUtils.copyProperties((Object)nativeParam, (Object)nativeRecommendContext);
        UserInfoDTO currentUser = this.userService.getUserCache(userId);
        if (1 == nativeParam.getActionType()) {
            LocationDTO locationDTO = this.locationIntegrationService.getLocationByGeocode(nativeParam.getCurrentAreaCode());
            if (null != locationDTO) {
                nativeRecommendContext.setCurrentAreaCode(locationDTO.getCode());
            }
            nativeRecommendContext.addParam("user", (Object)currentUser);
        }
        NativeRecommendContext recommendNativeWarper = this.nativeRecommendService.listRecommendUser(nativeRecommendContext);
        List recommendNativeList = recommendNativeWarper.getResult();
        this.logger.debug("\u5f97\u5230\u7528\u6237\u63a8\u8350\u5217\u8868:[{}]", JSON.toJSON((Object)recommendNativeList));
        if (!CollectionUtils.isEmpty((Collection)recommendNativeList)) {
            List<Long> userIdList = recommendNativeList.stream().map(RecommendNative::getUserId).collect(Collectors.toList());
            Long currentUserId = null;
            if (userIdList.contains(userId)) {
                currentUserId = userId;
            }
            Map<Long, UserInfoDTO> userMap = this.getUserMap(userIdList);
            Map<Long, List<UserTag>> userTagMap = this.userTagService.getBatchUserTag(userIdList);
            Map imgMap = this.userNewsIntegrationService.batchGetAllUserImg(userIdList, currentUserId);
            Map noteMap = this.userNewsIntegrationService.batchGetUserNote(userIdList, currentUserId);
            nativeDtoList = recommendNativeList.parallelStream().map(e -> this.generateRecommendNativeInfo(userId, currentUser, userMap, userTagMap, imgMap, noteMap, (RecommendNative)e)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        NativeDTO nativeDTO = NativeDTO.builder().recommendCategory(recommendNativeWarper.getRecommendCategory()).nativeInfoList(nativeDtoList).build();
        this.logger.debug("\u672c\u5730\u4eba\u63a8\u8350\u6700\u7ec8\u7ed3\u679c:[{}]", (Object)JSON.toJSONString((Object)nativeDTO));
        return nativeDTO;
    }

    @Override
    public NativeDTO listNativeForV3(Long userId, NativeParam nativeParam, BasicParam basicParam) {
        this.logger.debug("\u7528\u6237\u8fdb\u884c\u672c\u5730\u4eba\u63a8\u8350\uff0c\u7528\u6237id:[{}],\u53c2\u6570:[{}]", (Object)userId, JSON.toJSON((Object)nativeParam));
        ArrayList<NativeInfoDTO> nativeDtoList = new ArrayList();
        UserInfoDTO currentUser = this.userService.getUserCache(userId);
        NativeRecommendContext nativeRecommendContext = this.assemblyParam(userId, nativeParam, currentUser);
        NativeRecommendContext recommendNativeWarper = this.nativeRecommendService.listRecommendUser(nativeRecommendContext);
        List recommendNativeList = recommendNativeWarper.getResult();
        this.logger.debug("\u5f97\u5230\u7528\u6237\u63a8\u8350\u5217\u8868:[{}]", JSON.toJSON((Object)recommendNativeList));
        if (!CollectionUtils.isEmpty((Collection)recommendNativeList)) {
            List<Long> userIdList = recommendNativeList.stream().map(RecommendNative::getUserId).collect(Collectors.toList());
            Long currentUserId = null;
            if (userIdList.contains(userId)) {
                currentUserId = userId;
            }
            AtomicReference<Map<Long, UserInfoDTO>> userMap = new AtomicReference<Map<Long, UserInfoDTO>>(Maps.newHashMap());
            AtomicReference<Map<Long, List<UserTag>>> userTagMap = new AtomicReference<Map<Long, List<UserTag>>>(Maps.newHashMap());
            AtomicReference<Map<Long, List<ImgDTO>>> imgMap = new AtomicReference<Map<Long, List<ImgDTO>>>(Maps.newHashMap());
            AtomicReference<Map<Long, NoteDTO>> noteMap = new AtomicReference<Map<Long, NoteDTO>>(Maps.newHashMap());
            this.preProcessData(userIdList, currentUserId, userMap, userTagMap, imgMap, noteMap);
            nativeDtoList = recommendNativeList.parallelStream().map(e -> this.generateRecommendNativeInfo(userId, currentUser, (Map)userMap.get(), (Map)userTagMap.get(), (Map)imgMap.get(), (Map)noteMap.get(), (RecommendNative)e)).filter(Objects::nonNull).collect(Collectors.toList());
            this.interspersedNewbieGuide(userId, nativeDtoList, currentUser, null != currentUserId);
        }
        NativeDTO nativeDTO = NativeDTO.builder().recommendCategory(recommendNativeWarper.getRecommendCategory()).nativeInfoList(nativeDtoList).build();
        this.logger.debug("\u672c\u5730\u4eba\u63a8\u8350\u6700\u7ec8\u7ed3\u679c:[{}]", (Object)JSON.toJSONString((Object)nativeDTO));
        return nativeDTO;
    }

    private void preProcessData(List<Long> userIdList, Long currentUserId, AtomicReference<Map<Long, UserInfoDTO>> userMap, AtomicReference<Map<Long, List<UserTag>>> userTagMap, AtomicReference<Map<Long, List<ImgDTO>>> imgMap, AtomicReference<Map<Long, NoteDTO>> noteMap) {
        CompletableFuture<Void> future1 = CompletableFuture.runAsync(() -> userMap.set(this.getUserMap(userIdList)));
        CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> userTagMap.set(this.userTagService.getBatchUserTag(userIdList)));
        CompletableFuture<Void> future3 = CompletableFuture.runAsync(() -> imgMap.set(this.userNewsIntegrationService.batchGetAllUserImg(userIdList, currentUserId)));
        CompletableFuture<Void> future4 = CompletableFuture.runAsync(() -> noteMap.set(this.userNewsIntegrationService.batchGetUserNote(userIdList, currentUserId)));
        CompletableFuture<Void> all = CompletableFuture.allOf(future1, future2, future3, future4);
        try {
            all.get();
            this.logger.info("\u3010\u5e16\u5b50\u3011\u3001\u3010\u7eb8\u6761\u3011\u3001\u3010\u6807\u7b7e\u3011\u51c6\u5907\u6570\u636e\u5c31\u7eea");
        }
        catch (InterruptedException | ExecutionException e) {
            this.logger.error("\u3010\u5e16\u5b50\u3011\u3001\u3010\u7eb8\u6761\u3011\u3001\u3010\u6807\u7b7e\u3011\u51c6\u5907\u6570\u636e\u83b7\u53d6\u51fa\u9519[{}]", (Object)e.getMessage());
            this.logger.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private NativeRecommendContext assemblyParam(Long userId, NativeParam nativeParam, UserInfoDTO currentUser) {
        NativeRecommendContext nativeRecommendContext = NativeRecommendContext.builder().userId(userId).industryId(StringUtils.isEmpty((Object)nativeParam.getIndustryId()) ? null : Long.valueOf(Long.parseLong(nativeParam.getIndustryId()))).build();
        BeanUtils.copyProperties((Object)nativeParam, (Object)nativeRecommendContext);
        if (1 == nativeParam.getActionType()) {
            LocationDTO locationDTO = this.locationIntegrationService.getLocationByGeocode(nativeParam.getCurrentAreaCode());
            if (null != locationDTO) {
                nativeRecommendContext.setCurrentAreaCode(locationDTO.getCode());
            }
            nativeRecommendContext.addParam("user", (Object)currentUser);
        }
        return nativeRecommendContext;
    }

    private NativeInfoDTO generateRecommendNativeInfo(Long userId, UserInfoDTO currentUser, Map<Long, UserInfoDTO> userMap, Map<Long, List<UserTag>> userTagMap, Map<Long, List<ImgDTO>> imgMap, Map<Long, NoteDTO> noteMap, RecommendNative e) {
        UserInfoDTO user = userMap.get(e.getUserId());
        if (user == null) {
            return null;
        }
        List<Object> tagNameList = new ArrayList();
        List<UserTag> userTagList = userTagMap.get(e.getUserId());
        if (!CollectionUtils.isEmpty(userTagList)) {
            tagNameList = userTagList.stream().filter(t -> t.getDeleteFlag() == 0).map(UserTag::getLabel).collect(Collectors.toList());
        }
        ArrayList<ImgDTO> imgDtoList = new ArrayList<ImgDTO>();
        DynamicDTO dynamicDTO = this.getDynamic(noteMap, imgMap, imgDtoList, e.getUserId());
        String distance = "";
        if (null != e.getDistance() && 0 != e.getDistance() && !userId.equals(e.getUserId())) {
            distance = this.getDistance(e.getDistance()) + "km\u5185";
        }
        String generationStr = this.getGeneration(user);
        String personalProfile = this.getPersonalProfile(user, currentUser);
        return ((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)NativeInfoDTO.builder().distance(distance)).generation(generationStr)).headImg(user.getHeadImg())).hobbyList(tagNameList)).imgList(imgDtoList)).dynamic(dynamicDTO).industry(user.getIndustry())).nickName(user.getNickname())).personalProfile(personalProfile)).recommendType(e.getRecommendType())).sex(user.getSex())).userId(e.getUserId())).build();
    }

    private void interspersedNewbieGuide(Long userId, List<NativeInfoDTO> nativeDtoList, UserInfoDTO currentUser, boolean hasCurrentUser) {
        KeyGenerator keyGenerator = RedisConfig.USER_RECOMMEND.copy().appendKey((Object)"newbie-guide").appendKey((Object)DateUtils.formatDate((Date)new Date()));
        this.logger.debug("\u7a7f\u63d2\u5f15\u5bfc\u5b8c\u5584\u8d44\u6599\u5361\u7247-\u5224\u65ad\u4eca\u65e5\u662f\u5426\u5df2\u5f15\u5bfc");
        if (!this.redisSetAdapter.exists(keyGenerator, (Object)userId).booleanValue()) {
            this.logger.debug("\u5f00\u59cb\u7a7f\u63d2\u5f15\u5bfc\u5b8c\u5584\u8d44\u6599\u5361\u7247-\u5224\u65ad\u662f\u5426\u8fbe\u5230\u5f15\u5bfc\u9608\u503c");
            if (InfoCombineStateEnum.getInfoCompletePercent((Long)currentUser.getInfoCompleteState()) >= this.userProperties.getNativeNewbieGuideThreshold()) {
                return;
            }
            this.logger.debug("\u5f00\u59cb\u7a7f\u63d2\u5f15\u5bfc\u5b8c\u5584\u8d44\u6599\u5361\u7247-\u5f00\u59cb");
            if (hasCurrentUser) {
                nativeDtoList.removeIf(e -> e.getUserId().equals(currentUser.getId()));
            }
            List tagNameList = this.userTagService.getUserTagFromRedisDb(userId).stream().filter(t -> t.getDeleteFlag() == 0).map(UserTag::getLabel).collect(Collectors.toList());
            String generationStr = this.getGeneration(currentUser);
            NativeInfoDTO nativeInfoDTO = ((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)((NativeInfoDTO.NativeInfoDTOBuilder)NativeInfoDTO.builder().distance("")).generation(generationStr)).headImg(currentUser.getHeadImg())).hobbyList(tagNameList)).imgList(new ArrayList())).dynamic(DynamicDTO.buildGuideDynamic((GuideDTO)GuideDTO.builder().text(this.userProperties.getNativeNewbieGuideText()).build())).industry(currentUser.getIndustry())).nickName(currentUser.getNickname())).recommendType(Byte.valueOf((byte)2))).sex(currentUser.getSex())).userId(userId)).build();
            if (currentUser.getIsDefaultPersonalProfile().booleanValue()) {
                nativeInfoDTO.setPersonalProfile(this.userProperties.getNativeNewbieGuidePersonalProfile());
            }
            int position = this.userProperties.getNativeNewbieGuidePosition();
            if (nativeDtoList.size() >= position) {
                nativeDtoList.add(position - 1, nativeInfoDTO);
            } else {
                nativeDtoList.add(nativeInfoDTO);
            }
            this.redisSetAdapter.add(keyGenerator, new Object[]{currentUser.getId()});
            this.redisSetAdapter.expire(keyGenerator, (long)DateUtils.getCurSeconds());
            this.logger.debug("\u5f00\u59cb\u7a7f\u63d2\u5f15\u5bfc\u5b8c\u5584\u8d44\u6599\u5361\u7247-\u7ed3\u675f");
        }
    }

    private DynamicDTO getDynamic(Map<Long, NoteDTO> noteMap, Map<Long, List<ImgDTO>> imgMap, List<ImgDTO> imgDtoList, Long userId) {
        List<ImgDTO> imgList;
        DynamicDTO dynamicDTO = DynamicDTO.buildEmptyDynamic();
        NoteDTO note = noteMap.get(userId);
        if (null == note && !CollectionUtils.isEmpty(imgList = imgMap.get(userId))) {
            imgDtoList = imgList;
        }
        if (null != note) {
            dynamicDTO = DynamicDTO.buildNoteDynamic((NoteDTO)note);
        } else if (!CollectionUtils.isEmpty(imgDtoList)) {
            dynamicDTO = DynamicDTO.buildPostDynamic((PostDTO)PostDTO.builder().imgList(imgDtoList).build());
        }
        return dynamicDTO;
    }

    private Map<Long, UserInfoDTO> getUserMap(List<Long> userIdList) {
        List<UserInfoDTO> userList = this.userService.getBatchUserInfo(userIdList);
        Map<Long, Object> userMap = new HashMap<Long, UserInfoDTO>();
        if (!CollectionUtils.isEmpty(userList)) {
            userMap = userList.stream().collect(Collectors.toMap(UserInfoDTO::getId, Function.identity(), (key1, key2) -> key1));
        }
        return userMap;
    }

    private String getPersonalProfile(UserInfoDTO user, UserInfoDTO currentUser) {
        String he = "TA";
        if (1 == user.getSex()) {
            he = "\u4ed6";
        } else if (2 == user.getSex()) {
            he = "\u5979";
        }
        String personalProfile = user.getPersonalProfile();
        boolean defaultFlag = false;
        if (user.getIsDefaultPersonalProfile().booleanValue()) {
            defaultFlag = true;
            if (null != user.getJobCategory() && null != currentUser.getJobCategory() && user.getJobCategory().equals(currentUser.getJobCategory())) {
                personalProfile = "TA\u662f\u4f60\u7684\u540c\u884c\u5462\uff0c\u4e00\u8d77\u4ea4\u6d41\u4ea4\u6d41";
                defaultFlag = false;
            } else if (null != user.getRelationshipStatus() && 1 == user.getRelationshipStatus()) {
                personalProfile = "TA\u73b0\u5728\u662f\u5355\u8eab\uff0c\u8981\u4e0d\u8981\u6253\u4e2a\u62db\u547c\uff1f";
                defaultFlag = false;
            } else if (null != user.getHometownCode() && null != currentUser.getHometownCode() && (user.getHometownCode().equals(currentUser.getHometownCode()) && !user.getHometownCode().equals(user.getLocationCode()) || null == user.getLocationCode())) {
                personalProfile = "TA\u548c\u4f60\u662f\u8001\u4e61\u54e6\uff01\u5feb\u53bb\u6253\u4e2a\u62db\u547c~";
                defaultFlag = false;
            }
        }
        if (defaultFlag) {
            int randomIndex = RandomUtils.nextInt((int)0, (int)this.nativeUserProperties.getDefaultPersonalProfiles().size());
            personalProfile = (String)this.nativeUserProperties.getDefaultPersonalProfiles().get(randomIndex);
        }
        personalProfile = personalProfile.replace("TA", he);
        return personalProfile;
    }

    private String getGeneration(UserInfoDTO user) {
        LocalDate birthday;
        String gen;
        String generationStr = "";
        if (null != user.getBirthday() && !StringUtils.isEmpty((Object)(gen = this.userService.getGeneration(birthday = user.getBirthday().toInstant().atZone(ZoneId.systemDefault()).toLocalDate())))) {
            generationStr = gen;
        }
        return generationStr;
    }

    private Integer getDistance(Integer originalDistance) {
        if (originalDistance == 0) {
            return 0;
        }
        if (originalDistance <= 1) {
            return 1;
        }
        if (originalDistance <= 2) {
            return 2;
        }
        if (originalDistance <= 3) {
            return 3;
        }
        if (originalDistance <= 4) {
            return 4;
        }
        if (originalDistance <= 5) {
            return 5;
        }
        if (originalDistance <= 10) {
            return 10;
        }
        if (originalDistance <= 20) {
            return 20;
        }
        if (originalDistance <= 30) {
            return 30;
        }
        if (originalDistance <= 40) {
            return 40;
        }
        if (originalDistance <= 50) {
            return 50;
        }
        return originalDistance;
    }

    @Autowired
    public NativeUserServiceImpl(NativeRecommendService nativeRecommendService, NativeUserProperties nativeUserProperties, UserService userService, UserTagService userTagService, LocationIntegrationService locationIntegrationService, UserNewsIntegrationService userNewsIntegrationService, RedisSetAdapter redisSetAdapter, UserProperties userProperties) {
        this.nativeRecommendService = nativeRecommendService;
        this.nativeUserProperties = nativeUserProperties;
        this.userService = userService;
        this.userTagService = userTagService;
        this.locationIntegrationService = locationIntegrationService;
        this.userNewsIntegrationService = userNewsIntegrationService;
        this.redisSetAdapter = redisSetAdapter;
        this.userProperties = userProperties;
    }
}

