/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.support.impl;

import com.bxm.localnews.user.domain.VirtualUserMapper;
import com.bxm.localnews.user.dto.UserEntertranningDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.support.VirtualUserService;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VirtualUserServiceImpl
implements VirtualUserService {
    private static final Logger log = LogManager.getLogger(VirtualUserServiceImpl.class);
    private final VirtualUserMapper userMapper;

    @Autowired
    public VirtualUserServiceImpl(VirtualUserMapper userMapper) {
        this.userMapper = userMapper;
    }

    @Override
    public List<UserInfoDTO> listVirtualUser(Integer num) {
        return this.userMapper.getVirtualUserList(num);
    }

    @Override
    public List<UserInfoDTO> listVirtualUserNew(Integer num, List<Integer> types, String areaCode) {
        if (StringUtils.isBlank((CharSequence)areaCode)) {
            areaCode = "";
        }
        return this.userMapper.getVirtualUserListNew(num, types, areaCode);
    }

    @Override
    public Byte getVirtualUserType(Long userId) {
        Byte type = this.userMapper.getVirtualUserType(userId);
        if (null != type) {
            return type;
        }
        return (byte)0;
    }

    @Override
    public List<UserEntertranningDTO> listEntertaining(Integer num) {
        if (num > 10) {
            num = 10;
        }
        List<UserInfoDTO> list = this.listVirtualUser(num);
        ArrayList<UserEntertranningDTO> listResult = new ArrayList<UserEntertranningDTO>();
        for (UserInfoDTO uid : list) {
            UserEntertranningDTO entity = new UserEntertranningDTO();
            entity.setHeadImg(uid.getHeadImg());
            entity.setNickname(uid.getNickname());
            listResult.add(entity);
        }
        return listResult;
    }
}

