/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.timer;

import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.mq.common.param.DingtalkMessage;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.localnews.user.domain.UserStatisticsMapper;
import com.bxm.localnews.user.model.vo.UserStatisticsBean;
import com.bxm.localnews.user.properties.UserProperties;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.inner.IntervalMap;
import com.xxl.job.core.biz.model.ReturnT;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RegStatisticsTask
extends AbstractCronTask<String> {
    private static final Logger log = LoggerFactory.getLogger(RegStatisticsTask.class);
    @Resource
    private UserProperties userProperties;
    @Resource
    private HttpClientService httpClientService;
    @Resource
    private UserStatisticsMapper userStatisticsMapper;
    @Resource
    private MessageSender messageSender;

    protected ReturnT<String> service(String param) {
        IntervalMap intervalMap = DateUtils.getInterval((DateUtils.Interval)DateUtils.Interval.YESTERDAY);
        List regUserList = this.userStatisticsMapper.regUser(intervalMap.getStartTime(), intervalMap.getEndTime());
        List vipUserList = this.userStatisticsMapper.vipUser(intervalMap.getStartTime(), intervalMap.getEndTime());
        String statisticsDate = DateUtils.formatDate((Date)intervalMap.getStartTime());
        StringBuilder content = new StringBuilder();
        content.append(statisticsDate).append(" \u5185\u5bb9\u8fd0\u8425\u533a\u57df\u65b0\u6ce8\u518c\u7528\u6237\uff1a\n");
        int sum = 0;
        for (UserStatisticsBean areaGroup : regUserList) {
            if (!Objects.equals(areaGroup.getEnable(), 1)) continue;
            sum += areaGroup.getTotal().intValue();
            content.append(areaGroup.getLocationName()).append(" : ").append(areaGroup.getTotal()).append("\n");
        }
        content.append("\u5171\uff1a[ ").append(sum).append(" ]\u4eba\n");
        DingtalkMessage message = new DingtalkMessage();
        message.setScene("reg");
        message.setContent(content.toString());
        this.messageSender.sendDingtalk(message);
        content = new StringBuilder();
        content.append(statisticsDate).append(" \u5176\u4ed6\u533a\u57df\u65b0\u6ce8\u518c\u7528\u6237\uff1a\n");
        sum = 0;
        for (UserStatisticsBean areaGroup : regUserList) {
            if (!Objects.equals(areaGroup.getEnable(), 0)) continue;
            sum += areaGroup.getTotal().intValue();
            content.append(areaGroup.getLocationName()).append(" : ").append(areaGroup.getTotal()).append("\n");
        }
        content.append("\u5171\uff1a[ ").append(sum).append(" ]\u4eba\n");
        message = new DingtalkMessage();
        message.setScene("reg");
        message.setContent(content.toString());
        this.messageSender.sendDingtalk(message);
        content = new StringBuilder();
        content.append(statisticsDate).append(" VIP\u6fc0\u6d3b\u6570\u636e\uff1a\n");
        sum = 0;
        for (UserStatisticsBean areaGroup : vipUserList) {
            sum += areaGroup.getTotal().intValue();
            content.append(areaGroup.getLocationName()).append(" : ").append(areaGroup.getTotal()).append("\n");
        }
        content.append("\u5171\uff1a[ ").append(sum).append(" ]\u4eba\n");
        message = new DingtalkMessage();
        message.setScene("reg");
        message.setContent(content.toString());
        this.messageSender.sendDingtalk(message);
        return ReturnT.SUCCESS;
    }

    public String taskName() {
        return "regStaticsTask";
    }

    public String cron() {
        return "0 0 9 * * ?";
    }

    public String description() {
        return "\u6bcf\u65e5\u65e9\u4e0a9\u70b9\u7edf\u8ba1\u5e7f\u5fb7\u548c\u5bcc\u9633\u7684\u6ce8\u518c\u4eba\u6570\u548cVIP\u4eba\u6570";
    }
}

