/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang.StringUtils;

public class OkHttpUtil {
    private OkHttpUtil() {
    }

    public static OkHttpClient getInstance() {
        return Singleton.INSTANCE.getInstance();
    }

    public static JSONObject postRequest(String url, Map<String, String> params) {
        try {
            FormBody.Builder builder = new FormBody.Builder();
            for (Map.Entry<String, String> m : params.entrySet()) {
                builder.add(m.getKey(), m.getValue());
            }
            FormBody body = builder.build();
            Request request = new Request.Builder().post((RequestBody)body).url(url).build();
            Response response = OkHttpUtil.getInstance().newCall(request).execute();
            if (response.isSuccessful()) {
                assert (response.body() != null);
                String content = response.body().string();
                if (StringUtils.isNotBlank((String)content)) {
                    return JSONObject.parseObject((String)content);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static enum Singleton {
        INSTANCE;

        private OkHttpClient singleton;

        private Singleton() {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            builder.connectTimeout(6L, TimeUnit.SECONDS);
            builder.readTimeout(6L, TimeUnit.SECONDS);
            builder.writeTimeout(6L, TimeUnit.SECONDS);
            ConnectionPool connectionPool = new ConnectionPool(50, 60L, TimeUnit.SECONDS);
            builder.connectionPool(connectionPool);
            this.singleton = builder.build();
        }

        public OkHttpClient getInstance() {
            return this.singleton;
        }
    }
}

