/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.vip.activation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.common.rediskey.UserRedisKey;
import com.bxm.localnews.user.domain.UserInviteHistoryMapper;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.UserInviteBindDTO;
import com.bxm.localnews.user.enums.ActivationVipEnum;
import com.bxm.localnews.user.enums.ActivationVipStatusEnum;
import com.bxm.localnews.user.enums.InviteBindMethodEnum;
import com.bxm.localnews.user.invite.UserInviteService;
import com.bxm.localnews.user.invite.bind.BindInviteManager;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.param.ActivationUserVipParam;
import com.bxm.localnews.user.vip.UserVipService;
import com.bxm.localnews.user.vo.UserInviteHistoryBean;
import com.bxm.localnews.user.vo.UserVip;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractActivationVipStrategy {
    private static final Logger log = LoggerFactory.getLogger(AbstractActivationVipStrategy.class);
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    private UserService userService;
    @Autowired
    private UserInviteService userInviteService;
    @Autowired
    private BindInviteManager bindInviteManager;
    private UserVipService userVipService;
    @Autowired
    private UserInviteHistoryMapper userInviteHistoryMapper;
    @Autowired
    private DistributedLock distributedLock;
    @Autowired
    private SequenceCreater sequenceCreater;
    private KeyGenerator activeVip = DefaultKeyGenerator.build((String)"user", (String)"lock", (String)"activeVip");

    public UserVipService getUserVipService() {
        if (this.userVipService == null) {
            this.userVipService = (UserVipService)SpringContextHolder.getBean(UserVipService.class);
        }
        return this.userVipService;
    }

    protected abstract Message preCheck(ActivationUserVipParam var1);

    protected abstract void afterSuccess(ActivationUserVipParam var1);

    protected void afterFailed(ActivationUserVipParam param) {
    }

    public final Message execActivationVip(ActivationUserVipParam param) {
        log.debug("\u6267\u884cVIP\u6fc0\u6d3b\u6d41\u7a0b\uff0c\u5f53\u524d\u6fc0\u6d3b\u7c7b\u578b\uff1a{},\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)this.getType().name(), (Object)param);
        String requestId = this.sequenceCreater.nextStringId();
        String resource = this.activeVip.copy().appendKey((Object)param.getUserId()).gen();
        if (!this.distributedLock.lock(resource, requestId)) {
            log.info("\u91cd\u590d\u70b9\u51fb\u6fc0\u6d3bVIP\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)param));
            return Message.build((boolean)false, (String)"\u8bf7\u52ff\u91cd\u590d\u70b9\u51fb");
        }
        Message message = this.preCheck(param);
        if (message.isSuccess()) {
            try {
                message.append(this.upgradeVip(param));
                if (message.isSuccess()) {
                    this.afterSuccess(param);
                }
            }
            catch (Exception e) {
                log.error("VIP\u6fc0\u6d3b\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)param);
                log.error(e.getMessage(), (Throwable)e);
                message = Message.build((boolean)false, (String)"VIP\u6fc0\u6d3b\u5931\u8d25");
            }
            if (!message.isSuccess()) {
                this.afterFailed(param);
            }
        }
        log.debug("VIP\u6fc0\u6d3b\u5b8c\u6210\uff0c\u6fc0\u6d3b\u7c7b\u578b\uff1a{},\u8bf7\u6c42\u53c2\u6570\uff1a{},\u5904\u7406\u7ed3\u679c\uff1a{}", new Object[]{this.getType().name(), param, message});
        if (message.getParam("ak") == null) {
            message.addParam("ak", (Object)1);
        }
        this.distributedLock.unlock(resource, requestId);
        return message;
    }

    protected Message upgradeVip(ActivationUserVipParam param) {
        Message message;
        UserVip userVip = this.getUserVipService().getUserVipByUid(param.getUserId());
        param.setDuration(Integer.valueOf(this.getDuration(param)));
        if (Objects.equals(userVip.getStatus(), ActivationVipStatusEnum.WAIT_USE.getStatus())) {
            message = this.userVipService.createVip(param);
            if (message.isSuccess()) {
                this.initMasterInfo(param);
            }
        } else {
            message = this.userVipService.execRenew(param);
        }
        if (param.getPlatformEnum().intValue() != PlatformEnum.ANDROID.getCode() && param.getPlatformEnum().intValue() != PlatformEnum.IOS.getCode()) {
            if (StringUtils.isEmpty((CharSequence)((CharSequence)this.redisHashMapAdapter.get(UserRedisKey.HASH_USER_ACTIVE_VIP_FIRST, String.valueOf(param.getUserId()), String.class)))) {
                this.redisHashMapAdapter.put(UserRedisKey.HASH_USER_ACTIVE_VIP_FIRST, String.valueOf(param.getUserId()), (Object)"1");
            }
        } else if (StringUtils.isEmpty((CharSequence)((CharSequence)this.redisHashMapAdapter.get(UserRedisKey.HASH_USER_ACTIVE_VIP_FIRST, String.valueOf(param.getUserId()), String.class)))) {
            this.redisHashMapAdapter.put(UserRedisKey.HASH_USER_ACTIVE_VIP_FIRST, String.valueOf(param.getUserId()), (Object)"2");
        }
        return message;
    }

    public void initMasterInfo(ActivationUserVipParam param) {
        log.debug("\u5efa\u7acb\u5e08\u5f92\u5173\u7cfb\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)param);
        UserInfoDTO userInfoDTO = this.userService.getUserCache(param.getUserId());
        param.setUserName(userInfoDTO.getNickname());
        if (ActivationVipEnum.ACTIVATION_CODE.equals((Object)this.getType())) {
            UserInviteBindDTO userInviteBindDTO = new UserInviteBindDTO();
            userInviteBindDTO.setInviteBindMethodEnum(InviteBindMethodEnum.ACTIVE_CODE);
            userInviteBindDTO.setUserId(param.getUserId());
            userInviteBindDTO.setInviteUserId(param.getCodeUserId());
            userInviteBindDTO.setActiveCodeHasTime(Boolean.valueOf(true));
            UserInviteHistoryBean userInviteHistoryBean = this.bindInviteManager.bindInvite(userInviteBindDTO);
            if (null != userInviteHistoryBean) {
                param.setMasterId(userInviteHistoryBean.getInviteUserId());
            }
        } else if (ActivationVipEnum.PAY.equals((Object)this.getType())) {
            UserInviteBindDTO userInviteBindDTO = new UserInviteBindDTO();
            userInviteBindDTO.setInviteBindMethodEnum(InviteBindMethodEnum.WELFARE_VIP);
            userInviteBindDTO.setUserId(param.getUserId());
            userInviteBindDTO.setIsCallback(Boolean.valueOf(true));
            UserInviteHistoryBean userInviteHistoryBean = this.bindInviteManager.bindInvite(userInviteBindDTO);
            log.info(">>>>>>>>>>2---preCheckCommon \u3010{}\u3011", (Object)JSONObject.toJSONString((Object)userInviteHistoryBean));
            if (null != userInviteHistoryBean) {
                param.setMasterId(userInviteHistoryBean.getInviteUserId());
            }
        }
    }

    abstract InviteTypeEnum getInviteType();

    abstract ActivationVipEnum getType();

    abstract int getDuration(ActivationUserVipParam var1);
}

