/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.vip.activation;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.common.constant.VipCardTypeEnum;
import com.bxm.localnews.user.account.impl.AccountHandlerProxy;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.enums.ActivationVipEnum;
import com.bxm.localnews.user.enums.CashFlowTypeEnum;
import com.bxm.localnews.user.integration.PushMsgIntegrationService;
import com.bxm.localnews.user.model.VipCardInfoDTO;
import com.bxm.localnews.user.param.AccountActionParam;
import com.bxm.localnews.user.param.ActivationUserVipParam;
import com.bxm.localnews.user.properties.UserVipProperties;
import com.bxm.localnews.user.vip.activation.AbstractActivationVipStrategy;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import java.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PayActivationStrategy
extends AbstractActivationVipStrategy {
    private static final Logger log = LoggerFactory.getLogger(PayActivationStrategy.class);
    @Autowired
    UserVipProperties userVipProperties;
    @Autowired
    private PushMsgIntegrationService pushMsgIntegrationService;
    @Autowired
    private AccountHandlerProxy accountHandlerProxy;

    @Override
    protected Message preCheck(ActivationUserVipParam param) {
        VipCardInfoDTO vipCardInfoDTO;
        if (null == param.getUserId()) {
            throw new RuntimeException("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == param.getOrderId()) {
            throw new RuntimeException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == param.getPlatformEnum()) {
            param.setPlatformEnum(Integer.valueOf(PlatformEnum.ANDROID.getCode()));
        }
        if (null == (vipCardInfoDTO = this.getUserVipService().getVipCardInfo(param.getVipCardId()))) {
            log.error("\u8d2d\u4e70\u7684VIP\u5361\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)param);
            return Message.build((boolean)false, (String)"VIP\u5361\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isBlank((CharSequence)param.getChannel())) {
            param.setChannel("PAYMENT");
        }
        return Message.build();
    }

    @Override
    protected void afterSuccess(ActivationUserVipParam param) {
        if (null != param.getMasterId()) {
            log.info("\u7528\u6237\u3010{}\u3011\u4ed8\u8d39\u8d2d\u4e70vip\u6210\u529f\uff0c\u7ed9\u5e08\u5085\u3010{}\u3011\u53d1\u9001\u63a8\u9001\u548c\u91d1\u989d\u5956\u52b1", (Object)param.getUserId(), (Object)param.getMasterId());
            AccountActionParam accountActionParam = AccountActionParam.cashBuilder().amount(this.userVipProperties.getMasterReward()).userId(param.getMasterId()).remark("\u9080\u8bf7\u597d\u53cb\u5f00\u901a\u4e07\u4e8b\u901aVIP\u5956\u52b1").action(AccountActionEnum.ADD_DRAWABLE_CASH).cashFlowType(CashFlowTypeEnum.INVITE_VIP).build();
            this.accountHandlerProxy.handle(accountActionParam);
            this.pushMsgIntegrationService.pushMasterReceiveAward(param.getMasterId(), param.getUserName(), this.userVipProperties.getMasterReward());
        }
    }

    @Override
    InviteTypeEnum getInviteType() {
        return InviteTypeEnum.WELFARE_VIP;
    }

    @Override
    public ActivationVipEnum getType() {
        return ActivationVipEnum.PAY;
    }

    @Override
    int getDuration(ActivationUserVipParam param) {
        LocalDate nextLocalData;
        VipCardInfoDTO vipCardInfo = this.getUserVipService().getVipCardInfo(param.getVipCardId());
        VipCardTypeEnum cardType = VipCardTypeEnum.valueOf((String)vipCardInfo.getType());
        LocalDate current = LocalDate.now();
        switch (cardType) {
            case DAY: {
                nextLocalData = LocalDate.now().plusDays(1L);
                break;
            }
            case WEEK: {
                nextLocalData = LocalDate.now().plusWeeks(1L);
                break;
            }
            case MONTH: {
                nextLocalData = LocalDate.now().plusMonths(1L);
                break;
            }
            default: {
                nextLocalData = LocalDate.now().plusYears(1L);
            }
        }
        return (int)(nextLocalData.toEpochDay() - current.toEpochDay());
    }
}

