/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.vip.code.impl;

import com.bxm.localnews.user.domain.vip.UserActiveCodeMapper;
import com.bxm.localnews.user.domain.vip.UserActiveRelationMapper;
import com.bxm.localnews.user.enums.ActiveCodeTypeEnum;
import com.bxm.localnews.user.enums.AppConst;
import com.bxm.localnews.user.properties.UserVipProperties;
import com.bxm.localnews.user.vip.ActiveCodeService;
import com.bxm.localnews.user.vip.VipCardService;
import com.bxm.localnews.user.vip.code.ActiveCodeProcessContext;
import com.bxm.localnews.user.vip.code.IActiveCodeProcessStrategy;
import com.bxm.localnews.user.vo.vip.UserActiveCodeBean;
import com.bxm.localnews.user.vo.vip.UserActiveRelationBean;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractCodeProcessStrategy
implements IActiveCodeProcessStrategy {
    @Autowired
    UserActiveCodeMapper userActiveCodeMapper;
    @Autowired
    UserActiveRelationMapper userActiveRelationMapper;
    @Autowired
    VipCardService vipCardService;
    @Autowired
    SequenceCreater sequenceCreater;
    @Autowired
    UserVipProperties userVipProperties;
    ActiveCodeService activeCodeService;

    ActiveCodeService getActiveCodeService() {
        if (this.activeCodeService == null) {
            this.activeCodeService = (ActiveCodeService)SpringContextHolder.getBean(ActiveCodeService.class);
        }
        return this.activeCodeService;
    }

    void saveActiveCodeRecord(ActiveCodeProcessContext context, ActiveCodeTypeEnum activeCodeType) {
        this.saveActiveCodeRecord(context, activeCodeType, this.userVipProperties.getDefaultCodeNum());
    }

    void saveActiveCodeRecord(ActiveCodeProcessContext context, ActiveCodeTypeEnum activeCodeType, Integer maxTimes) {
        UserActiveCodeBean record = new UserActiveCodeBean();
        record.setId(this.sequenceCreater.nextLongId());
        record.setMaxTimes(maxTimes);
        record.setActiveTimes(Integer.valueOf(0));
        record.setStatus(AppConst.ENABLE);
        record.setAreaCode(context.getUserAreaCode());
        record.setCardNo(context.getNewCardNo());
        record.setActiveCode(context.getNewActiveCode());
        record.setCreateTime(new Date());
        record.setUserId(context.getUserId());
        record.setCardType(activeCodeType.getCode());
        this.userActiveCodeMapper.insert(record);
    }

    void saveActiveRelation(ActiveCodeProcessContext context) {
        UserActiveRelationBean record = new UserActiveRelationBean();
        record.setId(this.sequenceCreater.nextLongId());
        record.setActiveCode(context.getCode());
        record.setActiveUserId(context.getUserId());
        record.setActivieTime(new Date());
        record.setSourceUserId(context.getSourceCodeInfo().getUserId());
        this.userActiveRelationMapper.insert(record);
    }
}

