/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.vip.code.impl;

import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.vip.ActiveCodeDTO;
import com.bxm.localnews.user.enums.ActiveCodeTypeEnum;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.properties.UserVipProperties;
import com.bxm.localnews.user.vip.code.ActiveCodeProcessContext;
import com.bxm.localnews.user.vip.code.impl.AbstractCodeProcessStrategy;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ManualCodeProcessStrategy
extends AbstractCodeProcessStrategy {
    @Autowired
    private UserService userService;
    @Autowired
    private UserVipProperties userVipProperties;

    @Override
    public ActiveCodeDTO process(ActiveCodeProcessContext context) {
        String cardNo = null;
        String activeCode = this.getActiveCodeService().nextCode();
        UserInfoDTO user = this.userService.getUserCache(context.getUserId());
        if (StringUtils.isNotBlank((CharSequence)user.getLocationCode())) {
            cardNo = this.vipCardService.nextCard(user.getLocationCode());
            context.setUserAreaCode(user.getLocationCode());
        }
        context.setNewCardNo(cardNo);
        context.setNewActiveCode(activeCode);
        this.saveActiveCodeRecord(context, ActiveCodeTypeEnum.SUB, this.userVipProperties.getDefaultManualCodeNum());
        return ActiveCodeDTO.builder().activeCode(activeCode).cardNo(cardNo).build();
    }

    @Override
    public ActiveCodeTypeEnum match() {
        return ActiveCodeTypeEnum.MANUAL;
    }
}

