/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.vip.relation.impl;

import com.bxm.localnews.user.integration.MerchantIntegrationService;
import com.bxm.localnews.user.model.MerchantUserDTO;
import com.bxm.localnews.user.properties.UserProperties;
import com.bxm.localnews.user.vip.relation.MerchantRelationService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MerchantRelationServiceImpl
implements MerchantRelationService {
    private static final Logger log = LogManager.getLogger(MerchantRelationServiceImpl.class);
    private final MerchantIntegrationService merchantIntegrationService;
    private LoadingCache<Long, MerchantUserDTO> merchantCache;
    private final UserProperties userProperties;

    @Autowired
    public MerchantRelationServiceImpl(MerchantIntegrationService merchantIntegrationService, UserProperties userProperties) {
        this.merchantIntegrationService = merchantIntegrationService;
        this.userProperties = userProperties;
        this.initCache();
    }

    @Override
    public MerchantUserDTO getRelationMerchant(Long userId) {
        if (log.isDebugEnabled()) {
            log.debug("relation merchant userId : {}", (Object)userId);
        }
        if (Objects.isNull(userId)) {
            return null;
        }
        MerchantUserDTO merchantUserDTO = (MerchantUserDTO)this.merchantCache.getUnchecked((Object)userId);
        if (this.userProperties.getForceShowMerchant().booleanValue() && StringUtils.isNotBlank((CharSequence)merchantUserDTO.getMerchantName())) {
            merchantUserDTO.setMerchantStatus(Integer.valueOf(1));
        }
        return merchantUserDTO;
    }

    private void initCache() {
        this.merchantCache = CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.MINUTES).maximumSize(5000L).build((CacheLoader)new CacheLoader<Long, MerchantUserDTO>(){

            public MerchantUserDTO load(Long key) throws Exception {
                return MerchantRelationServiceImpl.this.merchantIntegrationService.getUserMerchantInfo(key);
            }
        });
    }
}

