package com.bxm.newidea.wanzhuan.news.service;

import com.bxm.newidea.component.vo.Message;

import java.util.Date;

/**
 * 新闻推荐服务接口
 * @author dell 2018/7/30 13:49
 */
public interface NewsRecommendedService {

    /**
     * 复制用户的新闻推荐信息
     * @param fromUid 来源用户ID
     * @param toUid   目标用户ID
     * @param time    来源用户的新闻推荐时间，只截取该时间之后的推荐信息
     * @return 复制结果
     */
    boolean copyRecommendeds(Long fromUid, Long toUid, Date time);

    /**
     * 删除用户
     * @param userId
     * @return
     */
    Message deleteByUserId(Long userId);
}
