package com.bxm.shop.model;


import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author yirenjie
 * createDate:  2018/11/9
 */
@NoArgsConstructor
@Data
public class GoodsList {

    @JSONField(name = "goods_search_response")
    private GoodsSearchResponseBean response = new GoodsSearchResponseBean();
    @JSONField(name = "error_response")
    private ErrorResponseBean errorResponse;

    @Data
    public static class GoodsSearchResponseBean {

        @JSONField(name = "total_count")
        private int totalCount;

        @JSONField(name = "goods_list")
        private List<Good> goodsList;

    }

    @NoArgsConstructor
    @Data
    public static class ErrorResponseBean {
        @JSONField(name = "error_code")
        private Integer errorCode;
        @JSONField(name = "error_msg")
        private String errorMsg;
    }
}
