package com.bxm.shop.model.order.dao;

import com.bxm.shop.facade.model.common.CommonDto;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * 订单信息Dao
 */
@Getter
@Setter
@ToString
public class OrderDao implements Serializable {

    private Long id ;

    /**
     * 订单openid
     */
    private String openid;

    /**
     * 分享者openid
     */
    private String shareOpenid;

    /**
     * 商品id
     */
    private String goodsId;

    /**
     * 拼多多订单编号
     */
    private String orderSn;

    /**
     * 自购返利
     */
    private Integer purchaseRate;

    /**
     * 分享返利
     */
    private Integer shareRate;

    /**
     * 上级返利
     */
    private Integer parentRate;

    /**
     * 上上级返利
     */
    private Integer grandparentRate;


    /**
     * 商品名
     */
    private String goodsName;

    /**
     * 多多券金额
     */
    private Integer duoCouponAmount;

    /**
     * 商品缩略图
     */
    private String goodsThumbnailUrl;

    /**
     * 订单创建时间
     */
    private Long orderCreateTime;

    /**
     * 商品数量
     */
    private Integer goodsQuantity;

    /**
     * 商品价格（分）
     */
    private Long goodsPrice;

    /**
     * 订单价格（分）
     */
    private Long orderAmount;

    /**
     * 佣金（分）
     */
    private Long promotionAmount;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 订单状态描述
     * （ -1 未支付; 0-已支付；1-已成团；2-确认收货；3-审核成功；4-审核失败（不可提现）；
     *  5-已经结算；8-非多多进宝商品（无佣金订单）;10-已处罚）
     */
    private String orderStatusDesc;

    /**
     * 自定义参数
     */
    private String customParameters;

    /**
     * 推广位ID
     */
    private String pid;

    /**
     * 订单类型：0：领券页面， 1： 红包页， 2：领券页， 3： 题页
     */
    private Integer type;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifyTime;

}
