/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.common.utils;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpUtils {
    private static final Logger log = LoggerFactory.getLogger(OkHttpUtils.class);
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static final OkHttpClient mOkHttpClient = new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).build();

    public static String get(String url) throws IOException {
        Request request = new Request.Builder().url(url).get().build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }

    public static String get(String url, Map<String, String> params) throws IOException {
        StringBuffer paramSb = new StringBuffer();
        if (params != null) {
            for (Map.Entry<String, String> e : params.entrySet()) {
                if (e.getValue() == null) continue;
                paramSb.append(URLEncoder.encode(e.getKey(), "UTF-8"));
                paramSb.append("=");
                paramSb.append(URLEncoder.encode(e.getValue(), "UTF-8"));
                paramSb.append("&");
            }
        }
        if (paramSb.length() > 0) {
            String paramStr = paramSb.toString();
            paramStr = paramStr.substring(0, paramStr.length() - 1);
            url = url + "?" + paramStr;
        }
        Request request = new Request.Builder().url(url).get().build();
        try {
            Response response = mOkHttpClient.newCall(request).execute();
            return response.body().string();
        }
        catch (IOException e) {
            log.error("\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38,url={},headers={}", (Object)url, (Object)request.headers());
            throw e;
        }
    }

    public static String post(String url, String params) throws IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)params);
        Request request = new Request.Builder().url(url).post(body).build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }

    public static String post(String url, Map<String, String> params) throws IOException {
        FormBody.Builder build = new FormBody.Builder();
        StringBuilder sb = new StringBuilder(url);
        int count = 0;
        for (String key : params.keySet()) {
            if (0 == count) {
                sb.append("?" + URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(params.get(key).toString(), "UTF-8"));
            } else {
                sb.append("&" + URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(params.get(key).toString(), "UTF-8"));
            }
            ++count;
        }
        FormBody body = build.build();
        Request request = new Request.Builder().url(sb.toString()).post((RequestBody)body).build();
        try {
            Response response = mOkHttpClient.newCall(request).execute();
            return response.body().string();
        }
        catch (IOException e) {
            log.error("\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38,url={},headers={}", (Object)url, (Object)request.headers());
            throw e;
        }
    }

    public static String put(String url, String params) throws IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)params);
        Request request = new Request.Builder().url(url).put(body).build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }

    public static String put(String url, Map<String, Object> params) throws IOException {
        FormBody.Builder build = new FormBody.Builder();
        for (String key : params.keySet()) {
            if (params.get(key) == null) continue;
            build.add(URLEncoder.encode(key, "UTF-8"), URLEncoder.encode(params.get(key).toString(), "UTF-8"));
        }
        FormBody body = build.build();
        Request request = new Request.Builder().url(url).put((RequestBody)body).build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }

    public static String delete(String url) throws IOException {
        Request request = new Request.Builder().url(url).delete().build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }

    public static String patch(String url, Map<String, Object> params) throws IOException {
        FormBody.Builder build = new FormBody.Builder();
        for (String key : params.keySet()) {
            if (params.get(key) == null) continue;
            build.add(URLEncoder.encode(key, "UTF-8"), URLEncoder.encode(params.get(key).toString(), "UTF-8"));
        }
        FormBody body = build.build();
        Request request = new Request.Builder().url(url).patch((RequestBody)body).build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }

    public static String patch(String url, String params) throws IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)params);
        Request request = new Request.Builder().url(url).patch(body).build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }

    public static String head(String url) throws IOException {
        Request request = new Request.Builder().url(url).head().build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }
}

