/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.distributed.zk;

import com.bxm.warcar.integration.distributed.DistributedLock;
import com.bxm.warcar.integration.distributed.DistributedLockBus;
import com.bxm.warcar.integration.distributed.zk.ZooKeeperDistributedLock;
import com.bxm.warcar.integration.distributed.zk.ZooKeeperDistributedPathUtils;
import com.bxm.warcar.zk.ZkClientHolder;
import com.google.common.base.Preconditions;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.annotation.Schedules;
import org.springframework.util.ClassUtils;

public class ZooKeeperDistributedLockBus
implements BeanPostProcessor,
DistributedLockBus {
    private static final Logger logger = LoggerFactory.getLogger(ZooKeeperDistributedLockBus.class);
    private final ConcurrentMap<String, ZooKeeperDistributedLock> locks = new ConcurrentHashMap<String, ZooKeeperDistributedLock>(64);
    private final ZkClientHolder zkClientHolder;

    public ZooKeeperDistributedLockBus(ZkClientHolder zkClientHolder) {
        Preconditions.checkNotNull((Object)zkClientHolder);
        this.zkClientHolder = zkClientHolder;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        Map annotatedMethods = MethodIntrospector.selectMethods((Class)targetClass, (MethodIntrospector.MetadataLookup)new MethodIntrospector.MetadataLookup<Set<Scheduled>>(){

            public Set<Scheduled> inspect(Method method) {
                Set scheduledMethods = AnnotatedElementUtils.getMergedRepeatableAnnotations((AnnotatedElement)method, Scheduled.class, Schedules.class);
                return !scheduledMethods.isEmpty() ? scheduledMethods : null;
            }
        });
        if (annotatedMethods.isEmpty()) {
            if (logger.isTraceEnabled()) {
                logger.trace("No @Scheduled annotations found on bean class: " + bean.getClass());
            }
        } else {
            for (Map.Entry entry : annotatedMethods.entrySet()) {
                Method method = (Method)entry.getKey();
                for (Scheduled scheduled : (Set)entry.getValue()) {
                    this.processScheduled(scheduled, method, bean);
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info(annotatedMethods.size() + " @Scheduled methods created distributed lock on bean '" + beanName + "': " + annotatedMethods);
            }
        }
        return bean;
    }

    private void processScheduled(Scheduled scheduled, Method method, Object bean) {
        String className = this.getClassName(bean);
        String path = ZooKeeperDistributedPathUtils.createPath(className, method);
        ZooKeeperDistributedLock lock = new ZooKeeperDistributedLock(this.zkClientHolder, path);
        if (this.locks.containsKey(path)) {
            throw new RuntimeException("Distributed lock '" + path + "' for ZooKeeper already exist!");
        }
        this.locks.putIfAbsent(path, lock);
    }

    @Override
    public DistributedLock getLock(Object bean, Method method) {
        String path = ZooKeeperDistributedPathUtils.createPath(this.getClassName(bean), method);
        return (DistributedLock)this.locks.get(path);
    }

    private String getClassName(Object bean) {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        String className = targetClass.getName();
        if (ClassUtils.isCglibProxy((Object)bean)) {
            className = StringUtils.split((String)className, (String)"$$")[0];
        }
        return className;
    }
}

