/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.dal.base;

import com.bxm.shop.dal.base.BaseEntity;
import com.bxm.shop.dal.base.Example;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.jdbc.SQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class BaseDaoTemplate<T extends BaseEntity> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public String countByExample(MapperMethod.ParamMap<?> map) {
        final Example example = (Example)map.get((Object)"example");
        String sql = new SQL(){
            {
                this.SELECT("count(id)");
                this.FROM(example.getTableName());
                BaseDaoTemplate.this.exampleWhereClause(this, example);
            }
        }.toString();
        this.logger.debug(sql.replaceAll("\n", " "));
        return sql;
    }

    public String countColByExample(MapperMethod.ParamMap<?> map) {
        final String col = (String)map.get((Object)"col");
        final Example example = (Example)map.get((Object)"example");
        String sql = new SQL(){
            {
                this.SELECT("count(" + col + ")");
                this.FROM(example.getTableName());
                BaseDaoTemplate.this.exampleWhereClause(this, example);
            }
        }.toString();
        this.logger.debug(sql.replaceAll("\n", " "));
        return sql;
    }

    public String deleteByExample(final Example<?> example) {
        String sql = new SQL(){
            {
                this.DELETE_FROM(example.getTableName());
                BaseDaoTemplate.this.exampleWhereClause(this, example);
            }
        }.toString();
        this.logger.debug(sql.replaceAll("\n", " "));
        return sql;
    }

    public String deleteByPrimaryKey(T entity) {
        String sql = new SQL((BaseEntity)entity){
            final /* synthetic */ BaseEntity val$entity;
            {
                this.val$entity = baseEntity;
                this.DELETE_FROM(BaseDaoTemplate.this.getTableName(this.val$entity));
                this.WHERE("id=#{id}");
            }
        }.toString();
        this.logger.debug(sql.replaceAll("\n", " "));
        return sql;
    }

    public String insert(T entity) {
        String sql = new SQL((BaseEntity)entity){
            final /* synthetic */ BaseEntity val$entity;
            {
                this.val$entity = baseEntity;
                this.INSERT_INTO(BaseDaoTemplate.this.getTableName(this.val$entity));
                this.VALUES(BaseDaoTemplate.this.returnInsertColumnsName(this.val$entity, false), BaseDaoTemplate.this.returnInsertColumnsDefine(this.val$entity, false));
            }
        }.toString();
        this.logger.debug(sql.replaceAll("\n", " "));
        return sql;
    }

    public String insertSelective(T entity) {
        String sql = new SQL((BaseEntity)entity){
            final /* synthetic */ BaseEntity val$entity;
            {
                this.val$entity = baseEntity;
                this.INSERT_INTO(BaseDaoTemplate.this.getTableName(this.val$entity));
                this.VALUES(BaseDaoTemplate.this.returnInsertColumnsName(this.val$entity, true), BaseDaoTemplate.this.returnInsertColumnsDefine(this.val$entity, true));
            }
        }.toString();
        this.logger.debug(sql.replaceAll("\n", " "));
        return sql;
    }

    public String selectByExampleAndPage(MapperMethod.ParamMap<?> map) {
        final Example example = (Example)map.get((Object)"example");
        Integer pageSize = map.get((Object)"pageSize") == null ? null : (Integer)map.get((Object)"pageSize");
        Integer pageNum = map.get((Object)"pageNum") == null ? null : (Integer)map.get((Object)"pageNum");
        String sql = new SQL(){
            {
                this.SELECT(BaseDaoTemplate.this.getColumns(example.getEntityClass()));
                this.FROM(example.getTableName());
                BaseDaoTemplate.this.exampleWhereClause(this, example);
            }
        }.toString();
        if (StringUtils.isNotBlank((CharSequence)example.getOrderByClause())) {
            sql = sql + " ORDER BY " + example.getOrderByClause();
        }
        if (pageSize != null && pageNum != null) {
            sql = sql + " limit " + pageSize * (pageNum - 1) + "," + pageSize;
        }
        this.logger.info(sql.replaceAll("\n", " "));
        return sql;
    }

    public String selectByExample(MapperMethod.ParamMap<?> map) {
        final Example example = (Example)map.get((Object)"example");
        String sql = new SQL(){
            {
                this.SELECT(BaseDaoTemplate.this.getColumns(example.getEntityClass()));
                this.FROM(example.getTableName());
                BaseDaoTemplate.this.exampleWhereClause(this, example);
            }
        }.toString();
        if (StringUtils.isNotBlank((CharSequence)example.getOrderByClause())) {
            sql = sql + " ORDER BY " + example.getOrderByClause();
        }
        this.logger.debug(sql.replaceAll("\n", " "));
        return sql;
    }

    public String selectByPrimaryKey(T entity) {
        String sql = new SQL((BaseEntity)entity){
            final /* synthetic */ BaseEntity val$entity;
            {
                this.val$entity = baseEntity;
                this.SELECT(BaseDaoTemplate.this.getColumns(this.val$entity.getClass()));
                this.FROM(BaseDaoTemplate.this.getTableName(this.val$entity));
                this.WHERE("id=#{id}");
            }
        }.toString();
        this.logger.debug(sql.replaceAll("\n", " "));
        return sql;
    }

    public String selectOneByExample(MapperMethod.ParamMap<?> map) {
        final Example example = (Example)map.get((Object)"example");
        String sql = new SQL(){
            {
                this.SELECT(BaseDaoTemplate.this.getColumns(example.getEntityClass()));
                this.FROM(example.getTableName());
                BaseDaoTemplate.this.exampleWhereClause(this, example);
            }
        }.toString();
        if (StringUtils.isNotBlank((CharSequence)example.getOrderByClause())) {
            sql = sql + " ORDER BY " + example.getOrderByClause();
        }
        sql = sql + " limit 0,1";
        this.logger.debug(sql.replaceAll("\n", " "));
        return sql;
    }

    public String sumByExample(MapperMethod.ParamMap<?> map) {
        final String field = (String)map.get((Object)"field");
        final Example example = (Example)map.get((Object)"example");
        String sql = new SQL(){
            {
                this.SELECT("sum(" + field + ")");
                this.FROM(example.getTableName());
                BaseDaoTemplate.this.exampleWhereClause(this, example);
            }
        }.toString();
        this.logger.debug(sql.replaceAll("\n", " "));
        return sql;
    }

    public String updateByExample(MapperMethod.ParamMap<?> map) {
        final BaseEntity entity = (BaseEntity)map.get((Object)"record");
        final Example example = (Example)map.get((Object)"example");
        String sql = new SQL(){
            {
                this.UPDATE(BaseDaoTemplate.this.getTableName(entity));
                Map fields = BaseDaoTemplate.this.getEntityFields(entity.getClass(), entity);
                for (Field field : fields.keySet()) {
                    String columnName = BaseDaoTemplate.this.getColumnName(entity, field);
                    Object value = fields.get(field);
                    if (value == null && BaseEntity.class.isAssignableFrom(field.getType())) {
                        this.SET(columnName + "=null");
                        continue;
                    }
                    if (value instanceof BaseEntity) {
                        this.SET(columnName + "=#{record." + field.getName() + ".id}");
                        continue;
                    }
                    this.SET(columnName + "=#{record." + field.getName() + "}");
                }
                BaseDaoTemplate.this.exampleWhereClause(this, example);
            }
        }.toString();
        this.logger.debug(sql.replaceAll("\n", " "));
        return sql;
    }

    private String getColumnName(T entity, Field field) {
        Column column = field.getAnnotation(Column.class);
        if (StringUtils.isNotBlank((CharSequence)column.name())) {
            return column.name();
        }
        if (this.isAssignableFromBaseEntity(entity, field)) {
            return field.getName() + "_id";
        }
        return field.getName();
    }

    private boolean isAssignableFromBaseEntity(T entity, Field field) {
        Object value = ReflectionUtils.getField((Field)field, entity);
        if (value == null && BaseEntity.class.isAssignableFrom(field.getType())) {
            return true;
        }
        return value != null && value instanceof BaseEntity;
    }

    public String updateByExampleSelective(MapperMethod.ParamMap<?> map) {
        final BaseEntity entity = (BaseEntity)map.get((Object)"record");
        final Example example = (Example)map.get((Object)"example");
        String sql = new SQL(){
            {
                this.UPDATE(BaseDaoTemplate.this.getTableName(entity));
                Map fields = BaseDaoTemplate.this.getEntityFields(entity.getClass(), entity);
                for (Field field : fields.keySet()) {
                    String columnName = BaseDaoTemplate.this.getColumnName(entity, field);
                    Object value = fields.get(field);
                    if (value == null) continue;
                    if (value instanceof BaseEntity) {
                        this.SET(columnName + "=#{record." + field.getName() + ".id}");
                        continue;
                    }
                    this.SET(columnName + "=#{record." + field.getName() + "}");
                }
                BaseDaoTemplate.this.exampleWhereClause(this, example);
            }
        }.toString();
        this.logger.debug(sql.replaceAll("\n", " "));
        return sql;
    }

    public String updateByPrimaryKey(T entity) {
        String sql = new SQL((BaseEntity)entity){
            final /* synthetic */ BaseEntity val$entity;
            {
                this.val$entity = baseEntity;
                this.UPDATE(BaseDaoTemplate.this.getTableName(this.val$entity));
                Map fields = BaseDaoTemplate.this.getEntityFields(this.val$entity.getClass(), this.val$entity);
                for (Field field : fields.keySet()) {
                    String columnName = BaseDaoTemplate.this.getColumnName(this.val$entity, field);
                    Object value = fields.get(field);
                    if (value == null && BaseEntity.class.isAssignableFrom(field.getType())) {
                        this.SET(columnName + "=null");
                        continue;
                    }
                    if (value instanceof BaseEntity) {
                        this.SET(columnName + "=#{" + field.getName() + ".id}");
                        continue;
                    }
                    this.SET(columnName + "=#{" + field.getName() + "}");
                }
                this.WHERE("id=#{id}");
            }
        }.toString();
        this.logger.debug(sql.replaceAll("\n", " "));
        return sql;
    }

    public String updateByPrimaryKeySelective(T entity) {
        String sql = new SQL((BaseEntity)entity){
            final /* synthetic */ BaseEntity val$entity;
            {
                this.val$entity = baseEntity;
                this.UPDATE(BaseDaoTemplate.this.getTableName(this.val$entity));
                Map fields = BaseDaoTemplate.this.getEntityFields(this.val$entity.getClass(), this.val$entity);
                for (Field field : fields.keySet()) {
                    String columnName = BaseDaoTemplate.this.getColumnName(this.val$entity, field);
                    Object value = fields.get(field);
                    if (value == null) continue;
                    if (value instanceof BaseEntity) {
                        this.SET(columnName + "=#{" + field.getName() + ".id}");
                        continue;
                    }
                    this.SET(columnName + "=#{" + field.getName() + "}");
                }
                this.WHERE("id=#{id}");
            }
        }.toString();
        this.logger.debug(sql.replaceAll("\n", " "));
        return sql;
    }

    private SQL exampleWhereClause(SQL sql, Example<?> example) {
        int orCount = 0;
        int i = 0;
        for (Example.Criteria criteria : example.getOredCriteria()) {
            if (orCount != 0) {
                sql.OR();
            }
            ++orCount;
            if (criteria.isValid()) {
                int j = 0;
                for (Example.Criterion criterion : criteria.getCriteria()) {
                    if (criterion.isNoValue()) {
                        sql.WHERE(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        sql.WHERE(criterion.getCondition() + "#{example.oredCriteria[" + i + "].criteria[" + j + "].value}");
                    } else if (criterion.isBetweenValue()) {
                        sql.WHERE(criterion.getCondition() + "#{example.oredCriteria[" + i + "].criteria[" + j + "].value} and #{example.oredCriteria[" + i + "].criteria[" + j + "].secondValue}");
                    } else if (criterion.isListValue()) {
                        StringBuilder valueBuilder = new StringBuilder("(");
                        int vCount = 0;
                        for (Object v : (List)criterion.getValue()) {
                            if (vCount != 0) {
                                valueBuilder.append(",");
                            }
                            valueBuilder.append("#{example.oredCriteria[" + i + "].criteria[" + j + "].value[" + (++vCount - 1) + "]}");
                        }
                        valueBuilder.append(")");
                        sql.WHERE(criterion.getCondition() + valueBuilder.toString());
                    }
                    ++j;
                }
            }
            ++i;
        }
        return sql;
    }

    private Map<Field, Object> getEntityFields(Class<?> clazz, T entity) {
        HashMap<Field, Object> result = null;
        try {
            result = new HashMap<Field, Object>();
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Column.class)) continue;
                field.setAccessible(true);
                result.put(field, field.get(entity));
            }
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null && !superClass.equals(Object.class)) {
                result.putAll(this.getEntityFields(superClass, entity));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
        return result;
    }

    private String getColumns(Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        try {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Column.class)) continue;
                String name = field.getAnnotation(Column.class).name();
                if (StringUtils.isNotEmpty((CharSequence)name)) {
                    sb.append(name).append(" as ");
                }
                sb.append("`").append(field.getName()).append("`,");
            }
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null && !superClass.equals(Object.class)) {
                sb.append(this.getColumns(superClass));
            }
        }
        catch (IllegalArgumentException e) {
            this.logger.error("", (Throwable)e);
        }
        String result = sb.toString();
        if (sb.lastIndexOf(",") == sb.length() - 1) {
            result = sb.substring(0, sb.length() - 1);
        }
        return result;
    }

    private String returnInsertColumnsName(T entity, boolean skipNull) {
        StringBuilder sb = new StringBuilder();
        Map<Field, Object> fields = this.getEntityFields(entity.getClass(), entity);
        int i = 0;
        for (Field field : fields.keySet()) {
            boolean isNull = this.isNull(entity, field);
            if (skipNull && isNull) continue;
            if (i++ != 0) {
                sb.append(',');
            }
            String columnName = "`" + this.getColumnName(entity, field) + "`";
            sb.append(columnName);
        }
        return sb.toString();
    }

    private String returnInsertColumnsDefine(T entity, boolean skipNull) {
        StringBuilder sb = new StringBuilder();
        Map<Field, Object> fields = this.getEntityFields(entity.getClass(), entity);
        int i = 0;
        for (Field field : fields.keySet()) {
            boolean isNull = this.isNull(entity, field);
            if (skipNull && isNull) continue;
            if (i++ != 0) {
                sb.append(',');
            }
            if (isNull) {
                sb.append("null");
                continue;
            }
            if (this.isAssignableFromBaseEntity(entity, field)) {
                sb.append("#{").append(field.getName()).append(".id").append('}');
                continue;
            }
            sb.append("#{").append(field.getName()).append('}');
        }
        return sb.toString();
    }

    private boolean isNull(T entity, Field field) {
        try {
            field.setAccessible(true);
            return field.get(entity) == null;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return false;
    }

    private String getTableName(T entity) {
        Table table = entity.getClass().getAnnotation(Table.class);
        if (table != null) {
            return "`" + table.name() + "`";
        }
        return "`" + entity.getClass().getSimpleName() + "`";
    }
}

