/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils.file;

import com.bxm.warcar.utils.file.DataTracker;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDataTracker
implements DataTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleDataTracker.class);
    private final String url;

    public SimpleDataTracker(String url) {
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getData() {
        byte[] byArray;
        HttpURLConnection urlConnection = null;
        InputStream inputStream = null;
        ByteArrayOutputStream os = null;
        try {
            int len;
            urlConnection = (HttpURLConnection)new URL(this.url).openConnection();
            inputStream = urlConnection.getInputStream();
            int available = inputStream.available();
            long start = System.currentTimeMillis();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("{} Starting download ...", (Object)this.url);
            }
            os = new ByteArrayOutputStream(available);
            byte[] buffer = new byte[0xA00000];
            while ((len = inputStream.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
            os.flush();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("{} Finished in {} ms!", (Object)this.url, (Object)(System.currentTimeMillis() - start));
            }
            byArray = os.toByteArray();
        }
        catch (IOException e) {
            byte[] byArray2;
            try {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("getData: ", (Throwable)e);
                }
                byArray2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                IOUtils.closeQuietly(inputStream);
                if (null != urlConnection) {
                    urlConnection.disconnect();
                }
                throw throwable;
            }
            IOUtils.closeQuietly(os);
            IOUtils.closeQuietly((InputStream)inputStream);
            if (null != urlConnection) {
                urlConnection.disconnect();
            }
            return byArray2;
        }
        IOUtils.closeQuietly((OutputStream)os);
        IOUtils.closeQuietly((InputStream)inputStream);
        if (null != urlConnection) {
            urlConnection.disconnect();
        }
        return byArray;
    }
}

