/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.controllers;

import com.bxm.shop.common.exception.EnhanceResultModel;
import com.bxm.shop.common.exception.ResponseCodeType;
import com.bxm.shop.facade.model.GoodDetailVo;
import com.bxm.shop.facade.model.GoodVo;
import com.bxm.shop.facade.model.GoodsQueryRo;
import com.bxm.shop.facade.model.TagVo;
import com.bxm.shop.integration.pdd.PddGoodsIntegration;
import com.bxm.shop.service.GoodsService;
import com.bxm.shop.service.TagService;
import com.bxm.warcar.utils.response.ResultModel;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.dozer.Mapper;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/goods"})
public class GoodsController {
    @Resource
    private GoodsService goodsService;
    @Resource
    private TagService tagService;
    @Resource
    private PddGoodsIntegration pddGoodsIntegration;
    @Resource
    private Mapper mapper;

    @RequestMapping(value={"/getTags"})
    public ResultModel<List<TagVo>> getTags() {
        EnhanceResultModel resultModel = new EnhanceResultModel();
        resultModel.setReturnValue(this.tagService.getTagsByParentId());
        return resultModel;
    }

    @RequestMapping(value={"/getGoodsList"})
    public ResultModel<List<GoodVo>> getGoodsList(@RequestBody GoodsQueryRo goodsQueryRo) {
        EnhanceResultModel resultModel = new EnhanceResultModel();
        resultModel.setReturnValue(this.goodsService.getList(goodsQueryRo));
        return resultModel;
    }

    @RequestMapping(value={"/search"})
    public ResultModel<List<GoodVo>> search(@RequestBody GoodsQueryRo goodsQueryRo) {
        EnhanceResultModel resultModel = new EnhanceResultModel();
        resultModel.setReturnValue(this.goodsService.search(goodsQueryRo));
        return resultModel;
    }

    @RequestMapping(value={"/queryGoodListByIds"})
    public ResultModel<List<GoodVo>> queryGoodListByIds(@RequestBody List<String> ids) {
        List goods = this.pddGoodsIntegration.queryGoodsList(ids);
        if (goods != null) {
            EnhanceResultModel resultModel = new EnhanceResultModel();
            resultModel.setReturnValue(goods.stream().map(good -> (GoodVo)this.mapper.map(good, GoodVo.class)).collect(Collectors.toList()));
            return resultModel;
        }
        return new EnhanceResultModel(ResponseCodeType.SYSTEM_ERROR, new String[0]);
    }

    @RequestMapping(value={"/detail"})
    public ResultModel<GoodDetailVo> getDetail(@RequestBody String goodId) {
        EnhanceResultModel resultModel = new EnhanceResultModel();
        resultModel.setReturnValue((Object)this.goodsService.getDetail(goodId));
        return resultModel;
    }
}

