/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.controllers;

import com.bxm.shop.common.exception.ResponseCodeType;
import com.bxm.shop.facade.model.order.OrderDto;
import com.bxm.shop.service.OrderService;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/order"})
public class OrderController {
    @Autowired
    private OrderService orderService;
    private static long NINETY_DAY_SECONDE = 7776000L;

    @RequestMapping(value={"/add"})
    public ResultModel add(@RequestBody OrderDto dto) {
        ResultModel rs = new ResultModel();
        rs.setReturnValue((Object)this.orderService.add(dto));
        return rs;
    }

    @RequestMapping(value={"/deleteAbandonOrder"})
    public ResultModel deleteAbandonOrder(@RequestBody OrderDto dto) {
        ResultModel rs = new ResultModel();
        if (null == dto.getDate()) {
            rs.setSuccessed(Boolean.FALSE.booleanValue());
            rs.setErrorCode(ResponseCodeType.PARAM_ILLEGAL.getErrorCode());
            rs.setErrorDesc(ResponseCodeType.PARAM_ILLEGAL.getErrorMsg());
            return rs;
        }
        this.orderService.deleteAbandonOrder(dto.getDate());
        return rs;
    }

    @RequestMapping(value={"/synchronizeOrder"}, method={RequestMethod.POST})
    public ResultModel synchronizeOrder(@RequestBody OrderDto dto) {
        ResultModel rs = new ResultModel();
        if (null == dto.getStartUpdateTime() || dto.getStartUpdateTime() < System.currentTimeMillis() / 1000L - NINETY_DAY_SECONDE) {
            rs.setSuccessed(Boolean.FALSE.booleanValue());
            rs.setErrorCode(ResponseCodeType.PARAM_ILLEGAL.getErrorCode());
            rs.setErrorDesc(ResponseCodeType.PARAM_ILLEGAL.getErrorMsg());
            return rs;
        }
        this.orderService.synchronizeOrder(dto);
        return rs;
    }
}

