/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.handler;

import com.bxm.shop.common.exception.EnhanceResultModel;
import com.bxm.shop.common.exception.ResponseCodeType;
import com.bxm.shop.common.exception.ShopsException;
import com.bxm.warcar.utils.response.ResultModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class GlobalControllerExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalControllerExceptionHandler.class);

    @ExceptionHandler
    @ResponseBody
    public ResultModel runtimeExceptionHandler(Exception e) {
        log.error("\u7cfb\u7edf\u9519\u8bef:", (Throwable)e);
        return new EnhanceResultModel(ResponseCodeType.SYSTEM_ERROR, new String[0]);
    }

    @ExceptionHandler(value={ShopsException.class})
    @ResponseBody
    public ResultModel<Boolean> validateExceptionHandler(ShopsException e) {
        log.error("\u7cfb\u7edf\u5f02\u5e38:", (Throwable)e);
        return new EnhanceResultModel((Exception)e);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    public ResultModel<Boolean> missingServletRequestParameterExceptionHandler(MissingServletRequestParameterException e) {
        log.warn("\u53c2\u6570\u7f3a\u5931:", (Throwable)e);
        return new EnhanceResultModel(ResponseCodeType.PARAM_ILLEGAL, new String[]{e.getMessage()});
    }

    @ExceptionHandler(value={ServletRequestBindingException.class})
    @ResponseBody
    public ResultModel<Boolean> servletRequestBindingExceptionHandler(ServletRequestBindingException e) {
        log.warn("---------> system huge error:", (Throwable)e);
        return new EnhanceResultModel((Exception)e);
    }
}

