/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.service.impl;

import com.bxm.shop.common.exception.ResponseCodeType;
import com.bxm.shop.common.exception.ShopsException;
import com.bxm.shop.dal.Feedback;
import com.bxm.shop.dal.base.BaseEntity;
import com.bxm.shop.dal.base.Example;
import com.bxm.shop.dal.mapper.FeedbackMapper;
import com.bxm.shop.facade.model.FeedbackQueryRo;
import com.bxm.shop.facade.model.FeedbackVo;
import com.bxm.shop.facade.model.Page;
import com.bxm.shop.service.FeedbackService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.dozer.Mapper;
import org.springframework.stereotype.Service;

@Service
public class FeedbackServiceImpl
implements FeedbackService {
    @Resource
    private FeedbackMapper feedbackMapper;
    @Resource
    private Mapper mapper;

    @Override
    public boolean addFeedback(FeedbackVo feedback) {
        if (feedback == null) {
            throw new ShopsException(ResponseCodeType.PARAM_ILLEGAL, new String[0]);
        }
        return this.feedbackMapper.insertSelective((BaseEntity)this.mapper.map((Object)feedback, Feedback.class)) == 1;
    }

    @Override
    public Page<FeedbackVo> listFeedback(FeedbackQueryRo queryRo) {
        Example<Feedback> example = new Example<Feedback>(){};
        if (StringUtils.isNotBlank((CharSequence)queryRo.getKeyword())) {
            example.appendCriterion("keyword = ", (Object)queryRo.getKeyword());
        }
        Page page = new Page();
        page.setTotal(Long.valueOf(this.feedbackMapper.countByExample((Example)example)));
        page.setPageNum(queryRo.getPageNum());
        page.setPageSize(queryRo.getPageSize());
        List feedbackList = this.feedbackMapper.selectByExampleAndPage((Example)example, queryRo.getPageNum(), queryRo.getPageSize());
        page.setList(feedbackList.stream().map(feedback -> (FeedbackVo)this.mapper.map(feedback, FeedbackVo.class)).collect(Collectors.toList()));
        return page;
    }
}

